/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.responses;

import io.hotmoka.beans.responses.JarStoreNonInitialTransactionResponse;
import io.hotmoka.beans.responses.JarStoreTransactionSuccessfulResponse;
import io.hotmoka.network.responses.JarStoreTransactionResponseModel;
import io.hotmoka.network.updates.UpdateModel;
import io.hotmoka.network.values.TransactionReferenceModel;
import java.math.BigInteger;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class JarStoreTransactionSuccessfulResponseModel
extends JarStoreTransactionResponseModel {
    public String instrumentedJar;
    public List<TransactionReferenceModel> dependencies;
    public int verificationToolVersion;

    public JarStoreTransactionSuccessfulResponseModel(JarStoreTransactionSuccessfulResponse response) {
        super((JarStoreNonInitialTransactionResponse)response);
        this.instrumentedJar = Base64.getEncoder().encodeToString(response.getInstrumentedJar());
        this.dependencies = response.getDependencies().map(TransactionReferenceModel::new).collect(Collectors.toList());
        this.verificationToolVersion = response.getVerificationVersion();
    }

    public JarStoreTransactionSuccessfulResponseModel() {
    }

    public JarStoreTransactionSuccessfulResponse toBean() {
        return new JarStoreTransactionSuccessfulResponse(Base64.getDecoder().decode(this.instrumentedJar), this.dependencies.stream().map(TransactionReferenceModel::toBean), this.verificationToolVersion, this.updates.stream().map(UpdateModel::toBean), new BigInteger(this.gasConsumedForCPU), new BigInteger(this.gasConsumedForRAM), new BigInteger(this.gasConsumedForStorage));
    }
}

