/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.requests;

import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.JarStoreTransactionRequest;
import io.hotmoka.beans.requests.NonInitialTransactionRequest;
import io.hotmoka.network.requests.NonInitialTransactionRequestModel;
import io.hotmoka.network.values.TransactionReferenceModel;
import java.math.BigInteger;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JarStoreTransactionRequestModel
extends NonInitialTransactionRequestModel {
    public String jar;
    private List<TransactionReferenceModel> dependencies;
    public String chainId;
    public String signature;

    public JarStoreTransactionRequestModel(JarStoreTransactionRequest request) {
        super((NonInitialTransactionRequest<?>)request);
        this.chainId = request.chainId;
        this.signature = Base64.getEncoder().encodeToString(request.getSignature());
        this.jar = Base64.getEncoder().encodeToString(request.getJar());
        this.dependencies = request.getDependencies().map(TransactionReferenceModel::new).collect(Collectors.toList());
    }

    public JarStoreTransactionRequestModel() {
    }

    public final Stream<TransactionReferenceModel> getDependencies() {
        return this.dependencies.stream();
    }

    public JarStoreTransactionRequest toBean() {
        return new JarStoreTransactionRequest(this.decodeBase64(this.signature), this.caller.toBean(), new BigInteger(this.nonce), this.chainId, new BigInteger(this.gasLimit), new BigInteger(this.gasPrice), this.classpath.toBean(), this.decodeBase64(this.jar), (TransactionReference[])this.dependencies.stream().map(TransactionReferenceModel::toBean).toArray(TransactionReference[]::new));
    }
}

