/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal.transactions;

import io.hotmoka.beans.GasCostModel;
import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.JarStoreTransactionRequest;
import io.hotmoka.beans.responses.JarStoreNonInitialTransactionResponse;
import io.hotmoka.beans.responses.JarStoreTransactionFailedResponse;
import io.hotmoka.beans.responses.JarStoreTransactionSuccessfulResponse;
import io.hotmoka.instrumentation.InstrumentedJar;
import io.hotmoka.local.EngineClassLoader;
import io.hotmoka.local.NonInitialResponseBuilder;
import io.hotmoka.local.internal.EngineClassLoaderImpl;
import io.hotmoka.local.internal.NodeInternal;
import io.hotmoka.verification.TakamakaClassLoader;
import io.hotmoka.verification.VerifiedJar;
import java.math.BigInteger;
import java.util.stream.Stream;

public class JarStoreResponseBuilder
extends NonInitialResponseBuilder<JarStoreTransactionRequest, JarStoreNonInitialTransactionResponse> {
    public JarStoreResponseBuilder(TransactionReference reference, JarStoreTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    @Override
    protected EngineClassLoader mkClassLoader() {
        return new EngineClassLoaderImpl(((JarStoreTransactionRequest)this.request).getJar(), ((JarStoreTransactionRequest)this.request).getDependencies(), this.node, true, this.consensus);
    }

    @Override
    protected BigInteger minimalGasRequiredForTransaction() {
        int jarLength = ((JarStoreTransactionRequest)this.request).getJarLength();
        BigInteger result = super.minimalGasRequiredForTransaction();
        result = result.add(this.gasCostModel.cpuCostForInstallingJar(jarLength));
        result = result.add(this.gasCostModel.ramCostForInstallingJar(jarLength));
        return result;
    }

    @Override
    protected final BigInteger gasForStoringFailedResponse() {
        BigInteger gas = ((JarStoreTransactionRequest)this.request).gasLimit;
        return new JarStoreTransactionFailedResponse("placeholder for the name of the exception", "placeholder for the message of the exception", Stream.empty(), gas, gas, gas, gas).size(this.gasCostModel);
    }

    @Override
    public JarStoreNonInitialTransactionResponse getResponse() throws TransactionRejectedException {
        return (JarStoreNonInitialTransactionResponse)new ResponseCreator().create();
    }

    private class ResponseCreator
    extends NonInitialResponseBuilder.ResponseCreator {
        private ResponseCreator() throws TransactionRejectedException {
            super(JarStoreResponseBuilder.this);
        }

        protected JarStoreNonInitialTransactionResponse body() {
            try {
                this.init();
                int jarLength = ((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getJarLength();
                this.chargeGasForCPU(JarStoreResponseBuilder.this.gasCostModel.cpuCostForInstallingJar(jarLength));
                this.chargeGasForRAM(JarStoreResponseBuilder.this.gasCostModel.ramCostForInstallingJar(jarLength));
                VerifiedJar verifiedJar = VerifiedJar.of((byte[])((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getJar(), (TakamakaClassLoader)JarStoreResponseBuilder.this.classLoader, (boolean)false, (boolean)JarStoreResponseBuilder.this.consensus.allowsSelfCharged, (boolean)JarStoreResponseBuilder.this.consensus.skipsVerification);
                InstrumentedJar instrumentedJar = InstrumentedJar.of((VerifiedJar)verifiedJar, (GasCostModel)JarStoreResponseBuilder.this.gasCostModel);
                byte[] instrumentedBytes = instrumentedJar.toBytes();
                this.chargeGasForStorageOf(new JarStoreTransactionSuccessfulResponse(instrumentedBytes, ((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getDependencies(), JarStoreResponseBuilder.this.consensus.verificationVersion, this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return new JarStoreTransactionSuccessfulResponse(instrumentedBytes, ((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getDependencies(), JarStoreResponseBuilder.this.consensus.verificationVersion, this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                logger.info("jar store failed", t);
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return new JarStoreTransactionFailedResponse(t.getClass().getName(), t.getMessage(), this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage(), this.gasConsumedForPenalty());
            }
        }

        @Override
        public void event(Object event) {
        }
    }
}

