/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.AbstractInstanceMethodCallTransactionRequest;
import io.hotmoka.beans.responses.MethodCallTransactionExceptionResponse;
import io.hotmoka.beans.responses.MethodCallTransactionFailedResponse;
import io.hotmoka.beans.responses.MethodCallTransactionResponse;
import io.hotmoka.beans.responses.MethodCallTransactionSuccessfulResponse;
import io.hotmoka.beans.responses.VoidMethodCallTransactionSuccessfulResponse;
import io.hotmoka.beans.signatures.CodeSignature;
import io.hotmoka.beans.signatures.MethodSignature;
import io.hotmoka.beans.signatures.NonVoidMethodSignature;
import io.hotmoka.beans.types.ClassType;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.local.ViewResponseBuilder;
import io.hotmoka.local.internal.NodeInternal;
import io.hotmoka.local.internal.transactions.CodeCallResponseBuilder;
import io.hotmoka.local.internal.transactions.MethodCallResponseBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class InstanceMethodCallResponseBuilder
extends MethodCallResponseBuilder<AbstractInstanceMethodCallTransactionRequest> {
    public InstanceMethodCallResponseBuilder(TransactionReference reference, AbstractInstanceMethodCallTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
        try {
            if (this.transactionIsSigned()) {
                this.receiverIsExported();
            }
        }
        catch (Throwable t) {
            throw InstanceMethodCallResponseBuilder.wrapAsTransactionRejectedException(t);
        }
    }

    private void receiverIsExported() throws TransactionRejectedException {
        this.enforceExported(((AbstractInstanceMethodCallTransactionRequest)this.request).receiver);
    }

    @Override
    public MethodCallTransactionResponse getResponse() throws TransactionRejectedException {
        return (MethodCallTransactionResponse)new ResponseCreator().create();
    }

    @Override
    protected StorageReference getPayerFromRequest() {
        return this.isSelfCharged() ? ((AbstractInstanceMethodCallTransactionRequest)this.request).receiver : ((AbstractInstanceMethodCallTransactionRequest)this.request).caller;
    }

    @Override
    protected boolean transactionIsSigned() {
        return super.transactionIsSigned() && !this.isCallToFaucet();
    }

    private boolean isCallToFaucet() {
        try {
            return this.consensus.allowsUnsignedFaucet && ((AbstractInstanceMethodCallTransactionRequest)this.request).method.methodName.startsWith("faucet") && ((AbstractInstanceMethodCallTransactionRequest)this.request).method.definingClass.equals((Object)ClassType.GAMETE) && ((AbstractInstanceMethodCallTransactionRequest)this.request).caller.equals((Object)((AbstractInstanceMethodCallTransactionRequest)this.request).receiver) && this.classLoader.getGamete().isAssignableFrom(this.classLoader.loadClass(this.node.getClassTag((StorageReference)((AbstractInstanceMethodCallTransactionRequest)this.request).receiver).clazz.name));
        }
        catch (ClassNotFoundException | NoSuchElementException e) {
            logger.info("cannot load class", (Throwable)e);
            return false;
        }
    }

    private Method getFromContractMethod() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        MethodSignature method = ((AbstractInstanceMethodCallTransactionRequest)this.request).method;
        Class<Void> returnType = method instanceof NonVoidMethodSignature ? this.storageTypeToClass.toClass(((NonVoidMethodSignature)method).returnType) : Void.TYPE;
        Class[] argTypes = this.formalsAsClassForFromContract();
        return (Method)this.classLoader.resolveMethod(method.definingClass.name, method.methodName, argTypes, returnType).orElseThrow(() -> new NoSuchMethodException(method.toString()));
    }

    private boolean isSelfCharged() {
        if (this.consensus != null && this.consensus.allowsSelfCharged) {
            try {
                try {
                    return InstanceMethodCallResponseBuilder.hasAnnotation(this.getMethod(), "io.takamaka.code.lang.SelfCharged");
                }
                catch (NoSuchMethodException e) {
                    return InstanceMethodCallResponseBuilder.hasAnnotation(this.getFromContractMethod(), "io.takamaka.code.lang.SelfCharged");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private class ResponseCreator
    extends MethodCallResponseBuilder.ResponseCreator {
        private Object deserializedReceiver;
        private Object[] deserializedActuals;

        private ResponseCreator() throws TransactionRejectedException {
            super(InstanceMethodCallResponseBuilder.this);
        }

        @Override
        protected Object deserializedPayer() {
            return InstanceMethodCallResponseBuilder.this.isSelfCharged() ? this.deserializer.deserialize((StorageValue)((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).receiver) : this.getDeserializedCaller();
        }

        protected MethodCallTransactionResponse body() {
            try {
                Object result;
                Object[] deserializedActuals;
                Method methodJVM;
                this.init();
                this.deserializedReceiver = this.deserializer.deserialize((StorageValue)((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).receiver);
                this.deserializedActuals = ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).actuals().map(this.deserializer::deserialize).toArray(Object[]::new);
                try {
                    methodJVM = InstanceMethodCallResponseBuilder.this.getMethod();
                    deserializedActuals = this.deserializedActuals;
                }
                catch (NoSuchMethodException e) {
                    try {
                        methodJVM = InstanceMethodCallResponseBuilder.this.getFromContractMethod();
                        deserializedActuals = this.addExtraActualsForFromContract();
                    }
                    catch (NoSuchMethodException ee) {
                        throw e;
                    }
                }
                boolean isView = CodeCallResponseBuilder.hasAnnotation(methodJVM, "io.takamaka.code.lang.View");
                this.validateCallee(methodJVM, isView);
                this.ensureWhiteListingOf(methodJVM, deserializedActuals);
                this.mintCoinsForRewardToValidators();
                try {
                    result = methodJVM.invoke(this.deserializedReceiver, deserializedActuals);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (this.isCheckedForThrowsExceptions(cause, methodJVM)) {
                        this.viewMustBeSatisfied(isView, null);
                        this.chargeGasForStorageOf(new MethodCallTransactionExceptionResponse(cause.getClass().getName(), cause.getMessage(), InstanceMethodCallResponseBuilder.this.where(cause), InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                        this.refundPayerForAllRemainingGas();
                        return new MethodCallTransactionExceptionResponse(cause.getClass().getName(), cause.getMessage(), InstanceMethodCallResponseBuilder.this.where(cause), InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
                    }
                    throw cause;
                }
                this.viewMustBeSatisfied(isView, result);
                if (methodJVM.getReturnType() == Void.TYPE) {
                    this.chargeGasForStorageOf(new VoidMethodCallTransactionSuccessfulResponse(InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                    this.refundPayerForAllRemainingGas();
                    return new VoidMethodCallTransactionSuccessfulResponse(InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
                }
                this.chargeGasForStorageOf(new MethodCallTransactionSuccessfulResponse(this.serializer.serialize(result), InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(result), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return new MethodCallTransactionSuccessfulResponse(this.serializer.serialize(result), InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(result), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                logger.info("transaction failed", t);
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return new MethodCallTransactionFailedResponse(t.getClass().getName(), t.getMessage(), InstanceMethodCallResponseBuilder.this.where(t), InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage(), this.gasConsumedForPenalty());
            }
        }

        private void validateCallee(Method methodJVM, boolean isView) throws NoSuchMethodException {
            if (Modifier.isStatic(methodJVM.getModifiers())) {
                throw new NoSuchMethodException("cannot call a static method");
            }
            if (!isView && InstanceMethodCallResponseBuilder.this instanceof ViewResponseBuilder) {
                throw new NoSuchMethodException("cannot call a method not annotated as @View");
            }
        }

        @Override
        protected final Stream<Object> getDeserializedActuals() {
            return Stream.of(this.deserializedActuals);
        }

        @Override
        protected void scanPotentiallyAffectedObjects(Consumer<Object> consumer) {
            super.scanPotentiallyAffectedObjects(consumer);
            consumer.accept(this.deserializedReceiver);
        }

        @Override
        protected void ensureWhiteListingOf(Method executable, Object[] actuals) throws ClassNotFoundException {
            super.ensureWhiteListingOf(executable, actuals);
            Optional model = InstanceMethodCallResponseBuilder.this.classLoader.getWhiteListingWizard().whiteListingModelOf(executable);
            if (model.isPresent() && !Modifier.isStatic(executable.getModifiers())) {
                this.checkWhiteListingProofObligations(((Method)model.get()).getName(), this.deserializedReceiver, ((Method)model.get()).getAnnotations());
            }
        }

        private void mintCoinsForRewardToValidators() {
            StorageValue value;
            Optional firstArg;
            Optional<StorageReference> manifest = InstanceMethodCallResponseBuilder.this.node.getStoreUtilities().getManifestUncommitted();
            if (this.isSystemCall() && ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).method.equals((Object)CodeSignature.VALIDATORS_REWARD) && manifest.isPresent() && ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).caller.equals((Object)manifest.get()) && (firstArg = ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).actuals().findFirst()).isPresent() && (value = (StorageValue)firstArg.get()) instanceof BigIntegerValue) {
                BigInteger amount = ((BigIntegerValue)value).value;
                Object caller = this.getDeserializedCaller();
                InstanceMethodCallResponseBuilder.this.classLoader.setBalanceOf(caller, InstanceMethodCallResponseBuilder.this.classLoader.getBalanceOf(caller).add(amount));
            }
        }

        private Object[] addExtraActualsForFromContract() {
            int al = this.deserializedActuals.length;
            Object[] result = new Object[al + 2];
            System.arraycopy(this.deserializedActuals, 0, result, 0, al);
            result[al] = this.getDeserializedCaller();
            result[al + 1] = null;
            return result;
        }
    }
}

