/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.SystemTransactionRequest;
import io.hotmoka.beans.requests.TransactionRequest;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfField;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.local.EngineClassLoader;
import io.hotmoka.local.ResponseBuilder;
import io.hotmoka.local.internal.Deserializer;
import io.hotmoka.local.internal.EngineClassLoaderImpl;
import io.hotmoka.local.internal.NodeInternal;
import io.hotmoka.local.internal.StorageTypeToClass;
import io.hotmoka.local.internal.UpdatesExtractorFromRAM;
import io.hotmoka.local.internal.runtime.Runtime;
import io.hotmoka.nodes.ConsensusParams;
import io.hotmoka.nodes.DeserializationError;
import java.math.BigInteger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;

public abstract class AbstractResponseBuilder<Request extends TransactionRequest<Response>, Response extends TransactionResponse>
implements ResponseBuilder<Request, Response> {
    public final NodeInternal node;
    public final StorageTypeToClass storageTypeToClass;
    public final EngineClassLoader classLoader;
    protected final Request request;
    protected final TransactionReference reference;
    protected final ConsensusParams consensus;

    protected AbstractResponseBuilder(TransactionReference reference, Request request, NodeInternal node) throws TransactionRejectedException {
        try {
            this.request = request;
            this.reference = reference;
            this.node = node;
            this.consensus = node.getCaches().getConsensusParams();
            this.classLoader = this.mkClassLoader();
            this.storageTypeToClass = new StorageTypeToClass(this);
        }
        catch (Throwable t) {
            throw AbstractResponseBuilder.wrapAsTransactionRejectedException(t);
        }
    }

    @Override
    public final Request getRequest() {
        return this.request;
    }

    @Override
    public final EngineClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public final void replaceReverifiedResponses() {
        ((EngineClassLoaderImpl)this.classLoader).replaceReverifiedResponses();
    }

    protected abstract EngineClassLoader mkClassLoader();

    protected static TransactionRejectedException wrapAsTransactionRejectedException(Throwable t) {
        return t instanceof TransactionRejectedException ? (TransactionRejectedException)t : new TransactionRejectedException(t);
    }

    public abstract class ResponseCreator {
        protected final Deserializer deserializer;
        protected final UpdatesExtractorFromRAM updatesExtractor;
        private final long now;
        private BigInteger nextProgressive = BigInteger.ZERO;

        protected ResponseCreator() throws TransactionRejectedException {
            try {
                this.deserializer = new Deserializer(AbstractResponseBuilder.this, AbstractResponseBuilder.this.node.getStoreUtilities());
                this.updatesExtractor = new UpdatesExtractorFromRAM(AbstractResponseBuilder.this);
                this.now = AbstractResponseBuilder.this.node.getStore().getNow();
            }
            catch (Throwable t) {
                throw new TransactionRejectedException(t);
            }
        }

        public final Response create() throws TransactionRejectedException {
            try {
                return (TransactionResponse)AbstractResponseBuilder.this.node.submit(new TakamakaCallable(this::body)).get();
            }
            catch (ExecutionException e) {
                throw AbstractResponseBuilder.wrapAsTransactionRejectedException(e.getCause());
            }
            catch (Throwable t) {
                throw AbstractResponseBuilder.wrapAsTransactionRejectedException(t);
            }
        }

        protected abstract Response body();

        public final long now() {
            return this.now;
        }

        public final boolean isSystemCall() {
            return AbstractResponseBuilder.this.request instanceof SystemTransactionRequest;
        }

        public abstract void event(Object var1);

        public abstract <T> T withGas(BigInteger var1, Callable<T> var2) throws Exception;

        public abstract void chargeGasForCPU(BigInteger var1);

        public abstract void chargeGasForRAM(BigInteger var1);

        public final Object deserializeLastUpdateFor(StorageReference object, FieldSignature field) {
            UpdateOfField update = AbstractResponseBuilder.this.node.getStoreUtilities().getLastUpdateToFieldUncommitted(object, field).orElseThrow(() -> new DeserializationError("did not find the last update for " + field + " of " + object));
            return this.deserializer.deserialize(update.getValue());
        }

        public final Object deserializeLastUpdateForFinal(StorageReference object, FieldSignature field) {
            UpdateOfField update = AbstractResponseBuilder.this.node.getStoreUtilities().getLastUpdateToFinalFieldUncommitted(object, field).orElseThrow(() -> new DeserializationError("did not find the last update for " + field + " of " + object));
            return this.deserializer.deserialize(update.getValue());
        }

        public final StorageReference getNextStorageReference() {
            BigInteger result = this.nextProgressive;
            this.nextProgressive = this.nextProgressive.add(BigInteger.ONE);
            return new StorageReference(AbstractResponseBuilder.this.reference, result);
        }

        public final EngineClassLoaderImpl getClassLoader() {
            return (EngineClassLoaderImpl)AbstractResponseBuilder.this.classLoader;
        }

        protected final Stream<Update> extractUpdatesFrom(Stream<Object> objects) {
            return this.updatesExtractor.extractUpdatesFrom(objects);
        }

        private final class TakamakaCallable
        implements Callable<Response> {
            private final Callable<Response> body;

            private TakamakaCallable(Callable<Response> body) {
                this.body = body;
            }

            @Override
            public Response call() throws Exception {
                try {
                    Runtime.responseCreators.set(ResponseCreator.this);
                    TransactionResponse transactionResponse = (TransactionResponse)this.body.call();
                    return transactionResponse;
                }
                finally {
                    Runtime.responseCreators.remove();
                }
            }
        }
    }
}

