/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal;

import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.types.BasicTypes;
import io.hotmoka.beans.types.ClassType;
import io.hotmoka.beans.types.StorageType;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfBigInteger;
import io.hotmoka.beans.updates.UpdateOfBoolean;
import io.hotmoka.beans.updates.UpdateOfByte;
import io.hotmoka.beans.updates.UpdateOfChar;
import io.hotmoka.beans.updates.UpdateOfDouble;
import io.hotmoka.beans.updates.UpdateOfEnumEager;
import io.hotmoka.beans.updates.UpdateOfEnumLazy;
import io.hotmoka.beans.updates.UpdateOfFloat;
import io.hotmoka.beans.updates.UpdateOfInt;
import io.hotmoka.beans.updates.UpdateOfLong;
import io.hotmoka.beans.updates.UpdateOfShort;
import io.hotmoka.beans.updates.UpdateOfStorage;
import io.hotmoka.beans.updates.UpdateOfString;
import io.hotmoka.beans.updates.UpdateToNullEager;
import io.hotmoka.beans.updates.UpdateToNullLazy;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.local.EngineClassLoader;
import io.hotmoka.local.internal.transactions.AbstractResponseBuilder;
import io.hotmoka.nodes.DeserializationError;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpdatesExtractorFromRAM {
    private final AbstractResponseBuilder<?, ?> builder;

    public UpdatesExtractorFromRAM(AbstractResponseBuilder<?, ?> builder) {
        this.builder = builder;
    }

    public Stream<Update> extractUpdatesFrom(Stream<Object> objects) {
        return (UpdatesExtractorFromRAM)this.new Processor(objects).updates.stream();
    }

    private class Processor {
        private final EngineClassLoader classLoader;
        private final List<Object> workingSet;
        private final Set<StorageReference> seen = new HashSet<StorageReference>();
        private final SortedSet<Update> updates = new TreeSet<Update>();

        private Processor(Stream<Object> objects) {
            this.classLoader = UpdatesExtractorFromRAM.this.builder.classLoader;
            this.workingSet = objects.filter(object -> this.seen.add(this.classLoader.getStorageReferenceOf(object))).collect(Collectors.toList());
            do {
                new ExtractedUpdatesSingleObject(this.workingSet.remove(this.workingSet.size() - 1));
            } while (!this.workingSet.isEmpty());
        }

        private class ExtractedUpdatesSingleObject {
            private final StorageReference storageReference;
            private final boolean inStorage;

            private ExtractedUpdatesSingleObject(Object object) {
                Class<?> clazz = object.getClass();
                this.storageReference = Processor.this.classLoader.getStorageReferenceOf(object);
                this.inStorage = Processor.this.classLoader.getInStorageOf(object);
                if (!this.inStorage) {
                    Processor.this.updates.add((Update)new ClassTag(this.storageReference, clazz.getName(), Processor.this.classLoader.transactionThatInstalledJarFor(clazz)));
                }
                Class<?> previous = null;
                while (previous != Processor.this.classLoader.getStorage()) {
                    this.addUpdatesForFieldsDefinedInClass(clazz, object);
                    previous = clazz;
                    clazz = clazz.getSuperclass();
                }
            }

            private void recursiveExtract(Object s) {
                if (s != null) {
                    Class<?> clazz = s.getClass();
                    if (Processor.this.classLoader.getStorage().isAssignableFrom(clazz)) {
                        if (Processor.this.seen.add(Processor.this.classLoader.getStorageReferenceOf(s))) {
                            Processor.this.workingSet.add(s);
                        }
                    } else if (Processor.this.classLoader.isLazilyLoaded(clazz)) {
                        throw new DeserializationError("a field of a storage object cannot hold a " + clazz.getName());
                    }
                }
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, String fieldClassName, Object s) {
                FieldSignature field = new FieldSignature(fieldDefiningClass, fieldName, (StorageType)new ClassType(fieldClassName));
                if (s == null) {
                    Processor.this.updates.add((Update)new UpdateToNullLazy(this.storageReference, field));
                } else if (Processor.this.classLoader.getStorage().isAssignableFrom(s.getClass())) {
                    StorageReference storageReference2 = Processor.this.classLoader.getStorageReferenceOf(s);
                    Processor.this.updates.add((Update)new UpdateOfStorage(this.storageReference, field, storageReference2));
                    if (Processor.this.seen.add(storageReference2)) {
                        Processor.this.workingSet.add(s);
                    }
                } else if (s instanceof String) {
                    Processor.this.updates.add((Update)new UpdateOfString(this.storageReference, field, (String)s));
                } else if (s instanceof BigInteger) {
                    Processor.this.updates.add((Update)new UpdateOfBigInteger(this.storageReference, field, (BigInteger)s));
                } else if (s instanceof Enum) {
                    if (this.hasInstanceFields(s.getClass())) {
                        throw new DeserializationError("field " + field + " of a storage object cannot hold an enumeration of class " + s.getClass().getName() + ": it has instance non-transient fields");
                    }
                    Processor.this.updates.add((Update)new UpdateOfEnumLazy(this.storageReference, field, s.getClass().getName(), ((Enum)s).name()));
                } else {
                    throw new DeserializationError("field " + field + " of a storage object cannot hold a " + s.getClass().getName());
                }
            }

            private boolean hasInstanceFields(Class<?> clazz) {
                return Stream.of(clazz.getDeclaredFields()).map(Field::getModifiers).anyMatch(modifiers -> !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, boolean s) {
                Processor.this.updates.add((Update)new UpdateOfBoolean(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.BOOLEAN), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, byte s) {
                Processor.this.updates.add((Update)new UpdateOfByte(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.BYTE), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, char s) {
                Processor.this.updates.add((Update)new UpdateOfChar(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.CHAR), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, double s) {
                Processor.this.updates.add((Update)new UpdateOfDouble(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.DOUBLE), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, float s) {
                Processor.this.updates.add((Update)new UpdateOfFloat(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.FLOAT), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, int s) {
                Processor.this.updates.add((Update)new UpdateOfInt(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.INT), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, long s) {
                Processor.this.updates.add((Update)new UpdateOfLong(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.LONG), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, short s) {
                Processor.this.updates.add((Update)new UpdateOfShort(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)BasicTypes.SHORT), s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, String s) {
                if (s == null) {
                    Processor.this.updates.add((Update)new UpdateToNullEager(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)ClassType.STRING)));
                } else {
                    Processor.this.updates.add((Update)new UpdateOfString(this.storageReference, new FieldSignature(fieldDefiningClass, fieldName, (StorageType)ClassType.STRING), s));
                }
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, BigInteger bi) {
                FieldSignature field = new FieldSignature(fieldDefiningClass, fieldName, (StorageType)ClassType.BIG_INTEGER);
                if (bi == null) {
                    Processor.this.updates.add((Update)new UpdateToNullEager(this.storageReference, field));
                } else {
                    Processor.this.updates.add((Update)new UpdateOfBigInteger(this.storageReference, field, bi));
                }
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, String fieldClassName, Enum<?> element) {
                FieldSignature field = new FieldSignature(fieldDefiningClass, fieldName, (StorageType)new ClassType(fieldClassName));
                if (element == null) {
                    Processor.this.updates.add((Update)new UpdateToNullEager(this.storageReference, field));
                } else {
                    Processor.this.updates.add((Update)new UpdateOfEnumEager(this.storageReference, field, element.getClass().getName(), element.name()));
                }
            }

            private void addUpdatesForFieldsDefinedInClass(Class<?> clazz, Object object) {
                for (Field field : clazz.getDeclaredFields()) {
                    Object oldValue;
                    Object currentValue;
                    if (this.isStaticOrTransient(field)) continue;
                    field.setAccessible(true);
                    try {
                        currentValue = field.get(object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new IllegalStateException("cannot access field " + field.getDeclaringClass().getName() + "." + field.getName(), e);
                    }
                    String oldName = "\u00a7old_" + field.getName();
                    try {
                        Field oldField = field.getDeclaringClass().getDeclaredField(oldName);
                        oldField.setAccessible(true);
                        oldValue = oldField.get(object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        throw new IllegalStateException("cannot access old value for field " + field.getDeclaringClass().getName() + "." + field.getName(), e);
                    }
                    if (!this.inStorage || !Objects.equals(oldValue, currentValue)) {
                        this.addUpdateFor(field, currentValue);
                    }
                    if (!this.inStorage || !Processor.this.classLoader.isLazilyLoaded(field.getType())) continue;
                    this.recursiveExtract(oldValue);
                }
            }

            private void addUpdateFor(Field field, Object currentValue) {
                Class<?> fieldType = field.getType();
                String fieldDefiningClass = field.getDeclaringClass().getName();
                String fieldName = field.getName();
                if (fieldType == Character.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, ((Character)currentValue).charValue());
                } else if (fieldType == Boolean.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Boolean)currentValue);
                } else if (fieldType == Byte.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Byte)currentValue);
                } else if (fieldType == Short.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Short)currentValue);
                } else if (fieldType == Integer.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Integer)currentValue);
                } else if (fieldType == Long.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Long)currentValue);
                } else if (fieldType == Float.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, ((Float)currentValue).floatValue());
                } else if (fieldType == Double.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Double)currentValue);
                } else if (fieldType == BigInteger.class) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (BigInteger)currentValue);
                } else if (fieldType == String.class) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (String)currentValue);
                } else if (fieldType.isEnum()) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, fieldType.getName(), (Enum)currentValue);
                } else if (Processor.this.classLoader.isLazilyLoaded(fieldType)) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, fieldType.getName(), currentValue);
                } else {
                    throw new IllegalStateException("unexpected field in storage object: " + fieldDefiningClass + "." + fieldName);
                }
            }

            private boolean isStaticOrTransient(Field field) {
                int modifiers = field.getModifiers();
                return Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers);
            }
        }
    }
}

