/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal;

import io.hotmoka.beans.InternalFailureException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseWithUpdates;
import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfField;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.local.NodeCaches;
import io.hotmoka.local.Store;
import io.hotmoka.local.StoreUtilities;
import io.hotmoka.local.internal.NodeInternal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreUtilitiesImpl
implements StoreUtilities {
    private static final Logger logger = LoggerFactory.getLogger(StoreUtilitiesImpl.class);
    private final NodeInternal node;
    private Store store;

    public StoreUtilitiesImpl(NodeInternal node) {
        this.node = node;
    }

    private Store getStore() {
        return this.store != null ? this.store : this.node.getStore();
    }

    public StoreUtilitiesImpl(NodeInternal node, Store store) {
        this.node = node;
        this.store = store;
    }

    @Override
    public Optional<TransactionReference> getTakamakaCodeUncommitted() {
        return this.getStore().getManifestUncommitted().map(this::getClassTagUncommitted).map(_classTag -> _classTag.jar);
    }

    @Override
    public Optional<StorageReference> getManifestUncommitted() {
        return this.getStore().getManifestUncommitted();
    }

    @Override
    public boolean nodeIsInitializedUncommitted() {
        return this.getManifestUncommitted().isPresent();
    }

    @Override
    public Optional<StorageReference> getGasStationUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignature.MANIFEST_GAS_STATION_FIELD));
    }

    @Override
    public Optional<StorageReference> getValidatorsUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignature.MANIFEST_VALIDATORS_FIELD));
    }

    @Override
    public Optional<StorageReference> getVersionsUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignature.MANIFEST_VERSIONS_FIELD));
    }

    @Override
    public BigInteger getBalanceUncommitted(StorageReference contract) {
        return this.getBigIntegerFieldUncommitted(contract, FieldSignature.BALANCE_FIELD);
    }

    @Override
    public BigInteger getRedBalanceUncommitted(StorageReference contract) {
        return this.getBigIntegerFieldUncommitted(contract, FieldSignature.RED_BALANCE_FIELD);
    }

    @Override
    public String getPublicKeyUncommitted(StorageReference account) {
        return this.getStringFieldUncommitted(account, FieldSignature.EOA_PUBLIC_KEY_FIELD);
    }

    @Override
    public StorageReference getCreatorUncommitted(StorageReference event) {
        return this.getReferenceFieldUncommitted(event, FieldSignature.EVENT_CREATOR_FIELD);
    }

    @Override
    public BigInteger getNonceUncommitted(StorageReference account) {
        return this.getBigIntegerFieldUncommitted(account, FieldSignature.EOA_NONCE_FIELD);
    }

    @Override
    public BigInteger getTotalBalanceUncommitted(StorageReference contract) {
        return this.getBalanceUncommitted(contract).add(this.getRedBalanceUncommitted(contract));
    }

    @Override
    public String getClassNameUncommitted(StorageReference reference) {
        return this.getClassTagUncommitted((StorageReference)reference).clazz.name;
    }

    @Override
    public ClassTag getClassTagUncommitted(StorageReference reference) {
        try {
            Optional<TransactionResponse> response = this.node.getCaches().getResponseUncommitted(reference.transaction);
            if (!(response.get() instanceof TransactionResponseWithUpdates)) {
                throw new InternalFailureException("transaction reference " + reference.transaction + " does not contain updates");
            }
            return ((TransactionResponseWithUpdates)response.get()).getUpdates().filter(update -> update instanceof ClassTag && update.object.equals((Object)reference)).map(update -> (ClassTag)update).findFirst().get();
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    @Override
    public Stream<Update> getStateCommitted(StorageReference object) {
        try {
            HashSet updates = new HashSet();
            Stream<TransactionReference> history = this.getStore().getHistory(object);
            history.forEachOrdered(transaction -> this.addUpdatesCommitted(object, (TransactionReference)transaction, updates));
            return updates.stream();
        }
        catch (Throwable t) {
            logger.error("unexpected exception", t);
            throw InternalFailureException.of((Throwable)t);
        }
    }

    @Override
    public Stream<UpdateOfField> getEagerFieldsUncommitted(StorageReference object) {
        try {
            HashSet fieldsAlreadySeen = new HashSet();
            NodeCaches caches = this.node.getCaches();
            return this.getStore().getHistoryUncommitted(object).flatMap(transaction -> StoreUtilitiesImpl.enforceHasUpdates(caches.getResponseUncommitted((TransactionReference)transaction).get()).getUpdates()).filter(update -> update.isEager() && update instanceof UpdateOfField && update.object.equals((Object)object) && fieldsAlreadySeen.add(((UpdateOfField)update).getField())).map(update -> (UpdateOfField)update);
        }
        catch (Throwable t) {
            logger.error("unexpected exception", t);
            throw InternalFailureException.of((Throwable)t);
        }
    }

    @Override
    public Optional<UpdateOfField> getLastUpdateToFieldUncommitted(StorageReference object, FieldSignature field) {
        return this.getStore().getHistoryUncommitted(object).map(transaction -> this.getLastUpdateUncommitted(object, field, (TransactionReference)transaction)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public Optional<UpdateOfField> getLastUpdateToFinalFieldUncommitted(StorageReference object, FieldSignature field) {
        return this.getLastUpdateUncommitted(object, field, object.transaction);
    }

    private static TransactionResponseWithUpdates enforceHasUpdates(TransactionResponse response) {
        if (response instanceof TransactionResponseWithUpdates) {
            return (TransactionResponseWithUpdates)response;
        }
        throw new InternalFailureException("Transaction " + response + " does not contain updates");
    }

    private void addUpdatesCommitted(StorageReference object, TransactionReference transaction, Set<Update> updates) {
        try {
            TransactionResponse response = this.node.getResponse(transaction);
            if (!(response instanceof TransactionResponseWithUpdates)) {
                throw new InternalFailureException("Storage reference " + transaction + " does not contain updates");
            }
            ((TransactionResponseWithUpdates)response).getUpdates().filter(update -> {
                if (!update.object.equals((Object)object)) return false;
                if (!updates.stream().noneMatch(arg_0 -> ((Update)update).sameProperty(arg_0))) return false;
                return true;
            }).forEach(updates::add);
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    private StorageReference getReferenceFieldUncommitted(StorageReference object, FieldSignature field) {
        try {
            return (StorageReference)this.getLastUpdateToFieldUncommitted(object, field).get().getValue();
        }
        catch (Throwable t) {
            logger.error("unexpected exception", t);
            throw InternalFailureException.of((Throwable)t);
        }
    }

    private BigInteger getBigIntegerFieldUncommitted(StorageReference object, FieldSignature field) {
        try {
            return ((BigIntegerValue)this.getLastUpdateToFieldUncommitted((StorageReference)object, (FieldSignature)field).get().getValue()).value;
        }
        catch (Throwable t) {
            logger.error("unexpected exception", t);
            throw InternalFailureException.of((Throwable)t);
        }
    }

    private String getStringFieldUncommitted(StorageReference object, FieldSignature field) {
        try {
            return ((StringValue)this.getLastUpdateToFieldUncommitted((StorageReference)object, (FieldSignature)field).get().getValue()).value;
        }
        catch (Throwable t) {
            logger.error("unexpected exception", t);
            throw InternalFailureException.of((Throwable)t);
        }
    }

    private Optional<UpdateOfField> getLastUpdateUncommitted(StorageReference object, FieldSignature field, TransactionReference transaction) {
        TransactionResponse response = this.node.getCaches().getResponseUncommitted(transaction).orElseThrow(() -> new InternalFailureException("unknown transaction reference " + transaction));
        if (!(response instanceof TransactionResponseWithUpdates)) {
            throw new InternalFailureException("transaction reference " + transaction + " does not contain updates");
        }
        return ((TransactionResponseWithUpdates)response).getUpdates().filter(update -> update instanceof UpdateOfField).map(update -> (UpdateOfField)update).filter(update -> update.object.equals((Object)object) && update.getField().equals((Object)field)).findFirst();
    }
}

