/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal;

import io.hotmoka.beans.types.BasicTypes;
import io.hotmoka.beans.types.ClassType;
import io.hotmoka.beans.types.StorageType;
import io.hotmoka.local.EngineClassLoader;
import io.hotmoka.local.internal.transactions.AbstractResponseBuilder;

public class StorageTypeToClass {
    private final EngineClassLoader classLoader;

    public StorageTypeToClass(AbstractResponseBuilder<?, ?> builder) {
        this.classLoader = builder.classLoader;
    }

    public StorageTypeToClass(EngineClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> toClass(StorageType type) throws ClassNotFoundException {
        if (type instanceof BasicTypes) {
            switch ((BasicTypes)type) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case INT: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
            }
        } else if (type instanceof ClassType) {
            return this.classLoader.loadClass(((ClassType)type).name);
        }
        throw new IllegalArgumentException("unexpected storage type");
    }
}

