/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal;

import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.BooleanValue;
import io.hotmoka.beans.values.ByteValue;
import io.hotmoka.beans.values.CharValue;
import io.hotmoka.beans.values.DoubleValue;
import io.hotmoka.beans.values.EnumValue;
import io.hotmoka.beans.values.FloatValue;
import io.hotmoka.beans.values.IntValue;
import io.hotmoka.beans.values.LongValue;
import io.hotmoka.beans.values.NullValue;
import io.hotmoka.beans.values.ShortValue;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.local.internal.transactions.AbstractResponseBuilder;
import java.math.BigInteger;

public class Serializer {
    private final AbstractResponseBuilder<?, ?> builder;

    public Serializer(AbstractResponseBuilder<?, ?> builder) {
        this.builder = builder;
    }

    public StorageValue serialize(Object object) throws IllegalArgumentException {
        if (this.isStorage(object)) {
            return this.builder.classLoader.getStorageReferenceOf(object);
        }
        if (object instanceof BigInteger) {
            return new BigIntegerValue((BigInteger)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValue(((Boolean)object).booleanValue());
        }
        if (object instanceof Byte) {
            return new ByteValue(((Byte)object).byteValue());
        }
        if (object instanceof Character) {
            return new CharValue(((Character)object).charValue());
        }
        if (object instanceof Double) {
            return new DoubleValue(((Double)object).doubleValue());
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return new IntValue(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new LongValue(((Long)object).longValue());
        }
        if (object instanceof Short) {
            return new ShortValue(((Short)object).shortValue());
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Enum) {
            return new EnumValue(object.getClass().getName(), ((Enum)object).name());
        }
        if (object == null) {
            return NullValue.INSTANCE;
        }
        throw new IllegalArgumentException("an object of class " + object.getClass().getName() + " cannot be kept in store since it does not implement io.takamaka.code.lang.Storage");
    }

    private boolean isStorage(Object object) {
        return object != null && this.builder.classLoader.getStorage().isAssignableFrom(object.getClass());
    }
}

