/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal;

import io.hotmoka.beans.InternalFailureException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.AbstractJarStoreTransactionRequest;
import io.hotmoka.beans.requests.InitialTransactionRequest;
import io.hotmoka.beans.responses.JarStoreInitialTransactionResponse;
import io.hotmoka.beans.responses.JarStoreTransactionFailedResponse;
import io.hotmoka.beans.responses.JarStoreTransactionResponse;
import io.hotmoka.beans.responses.JarStoreTransactionSuccessfulResponse;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseWithInstrumentedJar;
import io.hotmoka.local.internal.NodeInternal;
import io.hotmoka.nodes.ConsensusParams;
import io.hotmoka.verification.TakamakaClassLoader;
import io.hotmoka.verification.VerificationException;
import io.hotmoka.verification.VerifiedJar;
import io.hotmoka.verification.issues.Error;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reverification {
    protected static final Logger logger = LoggerFactory.getLogger(Reverification.class);
    private final ConcurrentMap<TransactionReference, TransactionResponse> reverified = new ConcurrentHashMap<TransactionReference, TransactionResponse>();
    private final NodeInternal node;
    private final ConsensusParams consensus;

    public Reverification(Stream<TransactionReference> transactions, NodeInternal node, ConsensusParams consensus) {
        this.node = node;
        this.consensus = consensus;
        AtomicInteger counter = new AtomicInteger();
        transactions.forEachOrdered(dependency -> this.reverify((TransactionReference)dependency, counter));
    }

    public Optional<TransactionResponse> getReverifiedResponse(TransactionReference transaction) {
        return Optional.ofNullable((TransactionResponse)this.reverified.get(transaction));
    }

    public void replace() {
        this.reverified.forEach((reference, response) -> {
            this.node.getStore().replace((TransactionReference)reference, this.node.getRequest((TransactionReference)reference), (TransactionResponse)response);
            logger.info(reference + ": updated after reverification");
        });
        this.reverified.clear();
    }

    private List<JarStoreTransactionResponse> reverify(TransactionReference transaction, AtomicInteger counter) {
        if (this.consensus != null && counter.incrementAndGet() > this.consensus.maxDependencies) {
            throw new IllegalArgumentException("too many dependencies in classpath: max is " + this.consensus.maxDependencies);
        }
        TransactionResponseWithInstrumentedJar response = this.getResponseWithInstrumentedJarAtUncommitted(transaction);
        List<JarStoreTransactionResponse> reverifiedDependencies = this.reverifiedDependenciesOf(response, counter);
        if (this.anyFailed(reverifiedDependencies)) {
            return List.of(this.transformIntoFailed(response, transaction, "the reverification of a dependency failed"));
        }
        if (!this.needsReverification(response)) {
            return this.union(reverifiedDependencies, (JarStoreTransactionResponse)response);
        }
        VerifiedJar vj = this.recomputeVerifiedJarFor(transaction, reverifiedDependencies);
        if (vj.hasErrors()) {
            return List.of(this.transformIntoFailed(response, transaction, ((Error)vj.getFirstError().get()).message));
        }
        return this.union(reverifiedDependencies, this.updateVersion(response, transaction));
    }

    private VerifiedJar recomputeVerifiedJarFor(TransactionReference transaction, List<JarStoreTransactionResponse> reverifiedDependencies) {
        AbstractJarStoreTransactionRequest jarStoreRequestOfTransaction = (AbstractJarStoreTransactionRequest)this.node.getRequest(transaction);
        byte[] jar = jarStoreRequestOfTransaction.getJar();
        ArrayList<byte[]> jars = new ArrayList<byte[]>();
        jars.add(jar);
        reverifiedDependencies.stream().map(dependency -> (TransactionResponseWithInstrumentedJar)dependency).map(TransactionResponseWithInstrumentedJar::getInstrumentedJar).forEachOrdered(jars::add);
        if (this.consensus != null && jars.stream().mapToLong(bytes -> ((byte[])bytes).length).sum() > this.consensus.maxCumulativeSizeOfDependencies) {
            throw new IllegalArgumentException("too large cumulative size of dependencies in classpath: max is " + this.consensus.maxCumulativeSizeOfDependencies + " bytes");
        }
        TakamakaClassLoader tcl = TakamakaClassLoader.of(jars.stream(), (int)(this.consensus != null ? this.consensus.verificationVersion : 0));
        try {
            return VerifiedJar.of((byte[])jar, (TakamakaClassLoader)tcl, (boolean)(jarStoreRequestOfTransaction instanceof InitialTransactionRequest), (this.consensus != null && this.consensus.allowsSelfCharged ? 1 : 0) != 0, (this.consensus != null && this.consensus.skipsVerification ? 1 : 0) != 0);
        }
        catch (IOException e) {
            throw InternalFailureException.of((Throwable)e);
        }
    }

    private boolean needsReverification(TransactionResponseWithInstrumentedJar response) {
        return response.getVerificationVersion() != this.consensus.verificationVersion;
    }

    private List<JarStoreTransactionResponse> reverifiedDependenciesOf(TransactionResponseWithInstrumentedJar response, AtomicInteger counter) {
        ArrayList<JarStoreTransactionResponse> reverifiedDependencies = new ArrayList<JarStoreTransactionResponse>();
        response.getDependencies().map(dependency -> this.reverify((TransactionReference)dependency, counter)).forEachOrdered(reverifiedDependencies::addAll);
        return reverifiedDependencies;
    }

    private boolean anyFailed(List<JarStoreTransactionResponse> responses) {
        return responses.stream().anyMatch(response -> response instanceof JarStoreTransactionFailedResponse);
    }

    private List<JarStoreTransactionResponse> union(List<JarStoreTransactionResponse> responses, JarStoreTransactionResponse added) {
        responses.add(added);
        return responses;
    }

    private JarStoreTransactionFailedResponse transformIntoFailed(TransactionResponseWithInstrumentedJar response, TransactionReference transaction, String error) {
        if (response instanceof JarStoreInitialTransactionResponse) {
            throw new InternalFailureException("the reverification of the initial jar store transaction " + transaction + " failed: its jar cannot be used");
        }
        JarStoreTransactionSuccessfulResponse currentResponseAsNonInitial = (JarStoreTransactionSuccessfulResponse)response;
        JarStoreTransactionFailedResponse replacement = new JarStoreTransactionFailedResponse(VerificationException.class.getName(), error, currentResponseAsNonInitial.getUpdates(), currentResponseAsNonInitial.gasConsumedForCPU, currentResponseAsNonInitial.gasConsumedForRAM, currentResponseAsNonInitial.gasConsumedForStorage, BigInteger.ZERO);
        this.reverified.put(transaction, (TransactionResponse)replacement);
        return replacement;
    }

    private JarStoreTransactionResponse updateVersion(TransactionResponseWithInstrumentedJar response, TransactionReference transaction) {
        JarStoreInitialTransactionResponse replacement;
        if (response instanceof JarStoreInitialTransactionResponse) {
            replacement = new JarStoreInitialTransactionResponse(response.getInstrumentedJar(), response.getDependencies(), this.consensus.verificationVersion);
        } else {
            JarStoreTransactionSuccessfulResponse currentResponseAsNonInitial = (JarStoreTransactionSuccessfulResponse)response;
            replacement = new JarStoreTransactionSuccessfulResponse(response.getInstrumentedJar(), response.getDependencies(), this.consensus.verificationVersion, currentResponseAsNonInitial.getUpdates(), currentResponseAsNonInitial.gasConsumedForCPU, currentResponseAsNonInitial.gasConsumedForRAM, currentResponseAsNonInitial.gasConsumedForStorage);
        }
        this.reverified.put(transaction, (TransactionResponse)replacement);
        return replacement;
    }

    private TransactionResponseWithInstrumentedJar getResponseWithInstrumentedJarAtUncommitted(TransactionReference reference) throws NoSuchElementException {
        TransactionResponse response = this.node.getCaches().getResponseUncommitted(reference).orElseThrow(() -> new InternalFailureException("unknown transaction reference " + reference));
        if (!(response instanceof TransactionResponseWithInstrumentedJar)) {
            throw new NoSuchElementException("the transaction " + reference + " did not install a jar in store");
        }
        return (TransactionResponseWithInstrumentedJar)response;
    }
}

