/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local.internal;

import io.hotmoka.beans.InternalFailureException;
import io.hotmoka.beans.SignatureAlgorithm;
import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.InstanceMethodCallTransactionRequest;
import io.hotmoka.beans.requests.SignedTransactionRequest;
import io.hotmoka.beans.requests.TransactionRequest;
import io.hotmoka.beans.responses.InitializationTransactionResponse;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseWithEvents;
import io.hotmoka.beans.responses.TransactionResponseWithUpdates;
import io.hotmoka.beans.signatures.CodeSignature;
import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.signatures.MethodSignature;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfString;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.BooleanValue;
import io.hotmoka.beans.values.IntValue;
import io.hotmoka.beans.values.LongValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.local.EngineClassLoader;
import io.hotmoka.local.NodeCaches;
import io.hotmoka.local.internal.EngineClassLoaderImpl;
import io.hotmoka.local.internal.LRUCache;
import io.hotmoka.local.internal.NodeInternal;
import io.hotmoka.nodes.ConsensusParams;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCachesImpl
implements NodeCaches {
    protected static final Logger logger = LoggerFactory.getLogger(NodeCachesImpl.class);
    private final NodeInternal node;
    private final LRUCache<TransactionReference, TransactionRequest<?>> requests;
    private final LRUCache<TransactionReference, TransactionResponse> responses;
    private final LRUCache<SignedTransactionRequest, Boolean> checkedSignatures;
    private final LRUCache<TransactionReference, EngineClassLoader> classLoaders = new LRUCache(100, 1000);
    private volatile ConsensusParams consensus;
    private volatile Optional<StorageReference> validators;
    private volatile Optional<StorageReference> versions;
    private volatile Optional<StorageReference> gasStation;
    private volatile BigInteger gasPrice;
    private static final BigInteger _100_000 = BigInteger.valueOf(100000L);

    public NodeCachesImpl(NodeInternal node, ConsensusParams consensus) {
        this.node = node;
        this.requests = new LRUCache(100, node.getConfig().requestCacheSize);
        this.responses = new LRUCache(100, node.getConfig().responseCacheSize);
        this.checkedSignatures = new LRUCache(100, 1000);
        this.validators = Optional.empty();
        this.versions = Optional.empty();
        this.gasStation = Optional.empty();
        this.consensus = consensus;
    }

    @Override
    public final void invalidate() {
        this.requests.clear();
        this.responses.clear();
        this.checkedSignatures.clear();
        this.classLoaders.clear();
        this.consensus = null;
        this.validators = Optional.empty();
        this.versions = Optional.empty();
        this.gasStation = Optional.empty();
        this.gasPrice = null;
    }

    @Override
    public final void invalidateIfNeeded(TransactionResponse response, EngineClassLoader classLoader) {
        if (this.consensusParametersMightHaveChanged(response, classLoader)) {
            int versionBefore = this.consensus.verificationVersion;
            logger.info("recomputing the consensus cache since the information in the manifest might have changed");
            this.recomputeConsensus();
            logger.info("the consensus cache has been recomputed");
            this.classLoaders.clear();
            if (versionBefore != this.consensus.verificationVersion) {
                logger.info("the version of the verification module has changed from " + versionBefore + " to " + this.consensus.verificationVersion);
            }
        }
        if (this.gasPriceMightHaveChanged(response, classLoader)) {
            BigInteger gasPriceBefore = this.gasPrice;
            logger.info("recomputing the gas price cache since it has changed");
            this.recomputeGasPrice();
            logger.info("the gas price cache has been recomputed and changed from " + gasPriceBefore + " to " + this.gasPrice);
        }
    }

    @Override
    public final void recomputeConsensus() {
        try {
            StorageReference gasStation = this.getGasStation().get();
            StorageReference validators = this.getValidators().get();
            StorageReference versions = this.getVersions().get();
            TransactionReference takamakaCode = this.node.getStoreUtilities().getTakamakaCodeUncommitted().get();
            StorageReference manifest = this.node.getStore().getManifestUncommitted().get();
            String chainId = ((StringValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_CHAIN_ID, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            int maxErrorLength = ((IntValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_ERROR_LENGTH, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            int maxDependencies = ((IntValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_DEPENDENCIES, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            long maxCumulativeSizeOfDependencies = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_CUMULATIVE_SIZE_OF_DEPENDENCIES, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            boolean allowsSelfCharged = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.ALLOWS_SELF_CHARGED, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            boolean allowsFaucet = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.ALLOWS_UNSIGNED_FAUCET, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            boolean skipsVerification = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.SKIPS_VERIFICATION, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            String signature = ((StringValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_SIGNATURE, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            BigInteger ticketForNewPoll = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_TICKET_FOR_NEW_POLL, (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            BigInteger maxGasPerTransaction = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_GAS_PER_TRANSACTION, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            boolean ignoresGasPrice = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.IGNORES_GAS_PRICE, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            BigInteger targetGasAtReward = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_TARGET_GAS_AT_REWARD, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            long oblivion = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_OBLIVION, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            long inflation = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_INFLATION, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            int verificationVersion = ((IntValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_VERIFICATION_VERSION, (StorageReference)versions, (StorageValue[])new StorageValue[0]))).value;
            this.consensus = new ConsensusParams.Builder().setChainId(chainId).setMaxGasPerTransaction(maxGasPerTransaction).ignoreGasPrice(ignoresGasPrice).signRequestsWith(signature).setTargetGasAtReward(targetGasAtReward).setOblivion(oblivion).setInflation(inflation).setMaxErrorLength(maxErrorLength).setMaxDependencies(maxDependencies).setMaxCumulativeSizeOfDependencies(maxCumulativeSizeOfDependencies).allowSelfCharged(allowsSelfCharged).allowUnsignedFaucet(allowsFaucet).skipVerification(skipsVerification).setVerificationVersion(verificationVersion).setTicketForNewPoll(ticketForNewPoll).build();
        }
        catch (Throwable t) {
            logger.error("could not reconstruct the consensus parameters from the manifest", t);
            throw InternalFailureException.of((String)"could not reconstruct the consensus parameters from the manifest", (Throwable)t);
        }
    }

    @Override
    public final Optional<TransactionRequest<?>> getRequest(TransactionReference reference) {
        Objects.requireNonNull(reference);
        return this.requests.computeIfAbsentOptional(reference, _reference -> this.node.getStore().getRequest((TransactionReference)_reference));
    }

    @Override
    public final Optional<TransactionResponse> getResponse(TransactionReference reference) {
        Objects.requireNonNull(reference);
        return this.responses.computeIfAbsentOptional(reference, _reference -> this.node.getStore().getResponse((TransactionReference)_reference));
    }

    @Override
    public final Optional<TransactionResponse> getResponseUncommitted(TransactionReference reference) {
        return this.getResponse(reference).or(() -> this.node.getStore().getResponseUncommitted(reference));
    }

    @Override
    public final EngineClassLoader getClassLoader(TransactionReference classpath) {
        return this.classLoaders.computeIfAbsentNoException(classpath, _classpath -> new EngineClassLoaderImpl(null, Stream.of(_classpath), this.node, true, this.consensus));
    }

    @Override
    public final boolean signatureIsValid(SignedTransactionRequest request, SignatureAlgorithm<SignedTransactionRequest> signatureAlgorithm) throws Exception {
        return this.checkedSignatures.computeIfAbsent(request, _request -> signatureAlgorithm.verify(_request, this.getPublicKey(_request.getCaller(), signatureAlgorithm), _request.getSignature()));
    }

    @Override
    public final ConsensusParams getConsensusParams() {
        return this.consensus;
    }

    @Override
    public final Optional<StorageReference> getValidators() {
        if (this.validators.isEmpty()) {
            this.validators = this.node.getStoreUtilities().getValidatorsUncommitted();
        }
        return this.validators;
    }

    @Override
    public final Optional<StorageReference> getVersions() {
        if (this.versions.isEmpty()) {
            this.versions = this.node.getStoreUtilities().getVersionsUncommitted();
        }
        return this.versions;
    }

    @Override
    public final Optional<StorageReference> getGasStation() {
        if (this.gasStation.isEmpty()) {
            this.gasStation = this.node.getStoreUtilities().getGasStationUncommitted();
        }
        return this.gasStation;
    }

    @Override
    public final Optional<BigInteger> getGasPrice() {
        if (this.gasPrice == null) {
            this.recomputeGasPrice();
        }
        return Optional.ofNullable(this.gasPrice);
    }

    private PublicKey getPublicKey(StorageReference reference, SignatureAlgorithm<SignedTransactionRequest> signatureAlgorithm) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        TransactionResponse response;
        try {
            response = this.node.getResponse(reference.transaction);
        }
        catch (TransactionRejectedException e) {
            throw new NoSuchElementException("unknown transaction reference " + reference.transaction);
        }
        if (!(response instanceof TransactionResponseWithUpdates)) {
            throw new NoSuchElementException("transaction reference " + reference.transaction + " does not contain updates");
        }
        String publicKeyEncodedBase64 = ((TransactionResponseWithUpdates)response).getUpdates().filter((Predicate<Update>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPublicKey$5(io.hotmoka.beans.values.StorageReference io.hotmoka.beans.updates.Update ), (Lio/hotmoka/beans/updates/Update;)Z)((StorageReference)reference)).map((Function<Update, UpdateOfString>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getPublicKey$6(io.hotmoka.beans.updates.Update ), (Lio/hotmoka/beans/updates/Update;)Lio/hotmoka/beans/updates/UpdateOfString;)()).filter((Predicate<UpdateOfString>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPublicKey$7(io.hotmoka.beans.updates.UpdateOfString ), (Lio/hotmoka/beans/updates/UpdateOfString;)Z)()).findFirst().get().value;
        byte[] publicKeyEncoded = Base64.getDecoder().decode(publicKeyEncodedBase64);
        return signatureAlgorithm.publicKeyFromEncoded(publicKeyEncoded);
    }

    private void recomputeGasPrice() {
        Optional<StorageReference> manifest = this.node.getStore().getManifestUncommitted();
        if (manifest.isPresent()) {
            try {
                this.gasPrice = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest.get(), (BigInteger)NodeCachesImpl._100_000, (TransactionReference)this.node.getStoreUtilities().getTakamakaCodeUncommitted().get(), (MethodSignature)CodeSignature.GET_GAS_PRICE, (StorageReference)this.getGasStation().get(), (StorageValue[])new StorageValue[0]))).value;
            }
            catch (Throwable t) {
                throw InternalFailureException.of((String)"could not determine the gas price", (Throwable)t);
            }
        }
    }

    private boolean consensusParametersMightHaveChanged(TransactionResponse response, EngineClassLoader classLoader) {
        if (response instanceof InitializationTransactionResponse) {
            return true;
        }
        if (this.isInitializedUncommitted() && response instanceof TransactionResponseWithEvents) {
            Stream events = ((TransactionResponseWithEvents)response).getEvents();
            StorageReference manifest = this.node.getStore().getManifestUncommitted().get();
            StorageReference gasStation = this.getGasStation().get();
            StorageReference versions = this.getVersions().get();
            StorageReference validators = this.getValidators().get();
            return events.filter(event -> this.isConsensusUpdateEvent((StorageReference)event, classLoader)).map(this.node.getStoreUtilities()::getCreatorUncommitted).anyMatch(creator -> creator.equals((Object)manifest) || creator.equals((Object)validators) || creator.equals((Object)gasStation) || creator.equals((Object)versions));
        }
        return false;
    }

    private boolean isInitializedUncommitted() {
        return this.node.getStore().getManifestUncommitted().isPresent();
    }

    private boolean isConsensusUpdateEvent(StorageReference event, EngineClassLoader classLoader) {
        return classLoader.isConsensusUpdateEvent(this.node.getStoreUtilities().getClassNameUncommitted(event));
    }

    private boolean gasPriceMightHaveChanged(TransactionResponse response, EngineClassLoader classLoader) {
        if (response instanceof InitializationTransactionResponse) {
            return true;
        }
        if (this.isInitializedUncommitted() && response instanceof TransactionResponseWithEvents) {
            Stream events = ((TransactionResponseWithEvents)response).getEvents();
            StorageReference gasStation = this.getGasStation().get();
            return events.filter(event -> this.isGasPriceUpdateEvent((StorageReference)event, classLoader)).map(this.node.getStoreUtilities()::getCreatorUncommitted).anyMatch(arg_0 -> ((StorageReference)gasStation).equals(arg_0));
        }
        return false;
    }

    private boolean isGasPriceUpdateEvent(StorageReference event, EngineClassLoader classLoader) {
        return classLoader.isGasPriceUpdateEvent(this.node.getStoreUtilities().getClassNameUncommitted(event));
    }

    private static /* synthetic */ boolean lambda$getPublicKey$7(UpdateOfString update) {
        return update.getField().equals((Object)FieldSignature.EOA_PUBLIC_KEY_FIELD);
    }

    private static /* synthetic */ UpdateOfString lambda$getPublicKey$6(Update update) {
        return (UpdateOfString)update;
    }

    private static /* synthetic */ boolean lambda$getPublicKey$5(StorageReference reference, Update update) {
        return update instanceof UpdateOfString && update.object.equals((Object)reference);
    }
}

