/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local;

import io.hotmoka.beans.GasCostModel;
import io.hotmoka.beans.SignatureAlgorithm;
import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.NonInitialTransactionRequest;
import io.hotmoka.beans.requests.SignedTransactionRequest;
import io.hotmoka.beans.responses.NonInitialTransactionResponse;
import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfField;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.crypto.SignatureAlgorithmForTransactionRequests;
import io.hotmoka.local.AbstractLocalNode;
import io.hotmoka.local.EngineClassLoader;
import io.hotmoka.local.ViewResponseBuilder;
import io.hotmoka.local.internal.NodeInternal;
import io.hotmoka.local.internal.transactions.AbstractResponseBuilder;
import io.hotmoka.nodes.OutOfGasError;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NonInitialResponseBuilder<Request extends NonInitialTransactionRequest<Response>, Response extends NonInitialTransactionResponse>
extends AbstractResponseBuilder<Request, Response> {
    protected static final Logger logger = LoggerFactory.getLogger(NonInitialResponseBuilder.class);
    protected final GasCostModel gasCostModel;

    protected NonInitialResponseBuilder(TransactionReference reference, Request request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
        try {
            this.gasCostModel = node.getGasCostModel();
            this.callerMustBeExternallyOwnedAccount();
            this.payerMustBeContract();
            this.gasLimitIsInsideBounds();
            this.requestPromisesEnoughGas();
            this.gasPriceIsLargeEnough();
            this.requestMustHaveCorrectChainId();
            this.signatureMustBeValid();
            this.callerAndRequestMustAgreeOnNonce();
            this.payerCanPayForAllPromisedGas();
        }
        catch (Throwable t) {
            throw NonInitialResponseBuilder.wrapAsTransactionRejectedException(t);
        }
    }

    protected NonInitialResponseBuilder(TransactionReference reference, Request request, AbstractLocalNode<?, ?> node) throws TransactionRejectedException {
        this(reference, request, node.internal);
    }

    protected boolean transactionIsSigned() {
        return !this.transactionIsView() && this.request instanceof SignedTransactionRequest;
    }

    @Override
    protected EngineClassLoader mkClassLoader() {
        return this.node.getCaches().getClassLoader(((NonInitialTransactionRequest)this.request).classpath);
    }

    protected BigInteger minimalGasRequiredForTransaction() {
        BigInteger result = this.gasCostModel.cpuBaseTransactionCost();
        result = result.add(((NonInitialTransactionRequest)this.request).size(this.gasCostModel));
        result = result.add(this.gasForStoringFailedResponse());
        result = result.add(this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)this.gasCostModel).cpuCostForLoadingJar(arg_0)).reduce(BigInteger.ZERO, BigInteger::add));
        result = result.add(this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)this.gasCostModel).ramCostForLoadingJar(arg_0)).reduce(BigInteger.ZERO, BigInteger::add));
        return result;
    }

    protected StorageReference getPayerFromRequest() {
        return ((NonInitialTransactionRequest)this.request).caller;
    }

    protected abstract BigInteger gasForStoringFailedResponse();

    private boolean transactionIsView() {
        return this instanceof ViewResponseBuilder;
    }

    private SignatureAlgorithm<SignedTransactionRequest> determineSignatureAlgorithm() throws NoSuchAlgorithmException, ClassNotFoundException {
        ClassTag classTag = this.node.getClassTag(((NonInitialTransactionRequest)this.request).caller);
        Class clazz = this.classLoader.loadClass(classTag.clazz.name);
        if (this.classLoader.getAccountED25519().isAssignableFrom(clazz)) {
            return SignatureAlgorithmForTransactionRequests.ed25519();
        }
        if (this.classLoader.getAccountSHA256DSA().isAssignableFrom(clazz)) {
            return SignatureAlgorithmForTransactionRequests.sha256dsa();
        }
        if (this.classLoader.getAccountQTESLA1().isAssignableFrom(clazz)) {
            return SignatureAlgorithmForTransactionRequests.qtesla1();
        }
        if (this.classLoader.getAccountQTESLA3().isAssignableFrom(clazz)) {
            return SignatureAlgorithmForTransactionRequests.qtesla3();
        }
        return SignatureAlgorithmForTransactionRequests.mk((String)this.consensus.signature);
    }

    private void callerMustBeExternallyOwnedAccount() throws TransactionRejectedException, ClassNotFoundException {
        ClassTag classTag = this.node.getClassTag(((NonInitialTransactionRequest)this.request).caller);
        Class clazz = this.classLoader.loadClass(classTag.clazz.name);
        if (!this.classLoader.getExternallyOwnedAccount().isAssignableFrom(clazz)) {
            throw new TransactionRejectedException("the caller of a request must be an externally owned account");
        }
    }

    private void payerMustBeContract() throws TransactionRejectedException, ClassNotFoundException {
        StorageReference payer = this.getPayerFromRequest();
        if (payer.equals((Object)((NonInitialTransactionRequest)this.request).caller)) {
            return;
        }
        ClassTag classTag = this.node.getClassTag(payer);
        Class clazz = this.classLoader.loadClass(classTag.clazz.name);
        if (!this.classLoader.getContract().isAssignableFrom(clazz)) {
            throw new TransactionRejectedException("the payer of a request must be a contract");
        }
    }

    private void signatureMustBeValid() throws Exception {
        if (this.transactionIsSigned() && !this.node.getCaches().signatureIsValid((SignedTransactionRequest)this.request, this.determineSignatureAlgorithm())) {
            throw new TransactionRejectedException("invalid request signature");
        }
    }

    private void requestMustHaveCorrectChainId() throws TransactionRejectedException {
        String chainId;
        String chainIdOfNode;
        if (this.transactionIsSigned() && this.node.getStoreUtilities().nodeIsInitializedUncommitted() && !(chainIdOfNode = this.consensus.chainId).equals(chainId = ((SignedTransactionRequest)this.request).getChainId())) {
            throw new TransactionRejectedException("incorrect chain id: the request reports " + chainId + " but the node requires " + chainIdOfNode);
        }
    }

    private void callerAndRequestMustAgreeOnNonce() throws TransactionRejectedException {
        BigInteger expected;
        if (!this.transactionIsView() && !(expected = this.node.getStoreUtilities().getNonceUncommitted(((NonInitialTransactionRequest)this.request).caller)).equals(((NonInitialTransactionRequest)this.request).nonce)) {
            throw new TransactionRejectedException("incorrect nonce: the request reports " + ((NonInitialTransactionRequest)this.request).nonce + " but the account " + ((NonInitialTransactionRequest)this.request).caller + " contains " + expected);
        }
    }

    private void requestPromisesEnoughGas() throws TransactionRejectedException {
        BigInteger minimum = this.minimalGasRequiredForTransaction();
        if (((NonInitialTransactionRequest)this.request).gasLimit.compareTo(minimum) < 0) {
            throw new TransactionRejectedException("not enough gas to start the transaction, expected at least " + minimum + " units of gas");
        }
    }

    private void gasLimitIsInsideBounds() throws TransactionRejectedException {
        if (((NonInitialTransactionRequest)this.request).gasLimit.compareTo(BigInteger.ZERO) < 0) {
            throw new TransactionRejectedException("the gas limit cannot be negative");
        }
        BigInteger maxGas = this.transactionIsView() ? this.node.getConfig().maxGasPerViewTransaction : this.consensus.maxGasPerTransaction;
        if (((NonInitialTransactionRequest)this.request).gasLimit.compareTo(maxGas) > 0) {
            throw new TransactionRejectedException("the gas limit of the request is larger than the maximum allowed (" + ((NonInitialTransactionRequest)this.request).gasLimit + " > " + maxGas + ")");
        }
    }

    private void gasPriceIsLargeEnough() throws TransactionRejectedException {
        BigInteger currentGasPrice;
        if (this.transactionIsSigned() && this.node.getStoreUtilities().nodeIsInitializedUncommitted() && !this.consensus.ignoresGasPrice && ((NonInitialTransactionRequest)this.request).gasPrice.compareTo(currentGasPrice = this.node.getCaches().getGasPrice().get()) < 0) {
            throw new TransactionRejectedException("the gas price of the request is smaller than the current gas price (" + ((NonInitialTransactionRequest)this.request).gasPrice + " < " + currentGasPrice + ")");
        }
    }

    private void payerCanPayForAllPromisedGas() throws TransactionRejectedException {
        BigInteger cost = this.costOf(((NonInitialTransactionRequest)this.request).gasLimit);
        BigInteger totalBalance = this.node.getStoreUtilities().getTotalBalanceUncommitted(this.getPayerFromRequest());
        if (totalBalance.subtract(cost).signum() < 0) {
            throw new TransactionRejectedException("the payer has not enough funds to buy " + ((NonInitialTransactionRequest)this.request).gasLimit + " units of gas");
        }
    }

    private BigInteger costOf(BigInteger gas) {
        return gas.multiply(((NonInitialTransactionRequest)this.request).gasPrice);
    }

    protected abstract class ResponseCreator
    extends AbstractResponseBuilder.ResponseCreator {
        private Object deserializedCaller;
        private Object deserializedPayer;
        private Optional<Object> deserializedValidators;
        private final LinkedList<BigInteger> oldGas = new LinkedList();
        private BigInteger gas;
        private BigInteger gasConsumedForCPU = BigInteger.ZERO;
        private BigInteger gasConsumedForRAM = BigInteger.ZERO;
        private BigInteger gasConsumedForStorage = BigInteger.ZERO;
        private BigInteger greenInitiallyPaidForGas;
        private BigInteger greenBalanceOfPayerInCaseOfTransactionException;
        private BigInteger redBalanceOfPayerInCaseOfTransactionException;

        protected ResponseCreator() throws TransactionRejectedException {
            try {
                this.gas = ((NonInitialTransactionRequest)((NonInitialResponseBuilder)NonInitialResponseBuilder.this).request).gasLimit;
            }
            catch (Throwable t) {
                logger.error("response creation rejected", t);
                throw NonInitialResponseBuilder.wrapAsTransactionRejectedException(t);
            }
        }

        protected final void init() {
            this.deserializedCaller = this.deserializer.deserialize((StorageValue)((NonInitialTransactionRequest)((NonInitialResponseBuilder)NonInitialResponseBuilder.this).request).caller);
            this.deserializedPayer = this.deserializedPayer();
            this.deserializedValidators = NonInitialResponseBuilder.this.node.getCaches().getValidators().map(this.deserializer::deserialize);
            this.increaseNonceOfCaller();
            this.chargeGasForCPU(NonInitialResponseBuilder.this.gasCostModel.cpuBaseTransactionCost());
            this.chargeGasForStorage(NonInitialResponseBuilder.this.node.getRequestStorageCost((NonInitialTransactionRequest)NonInitialResponseBuilder.this.request));
            this.chargeGasForClassLoader();
            this.greenInitiallyPaidForGas = this.chargePayerForAllGasPromised();
            this.greenBalanceOfPayerInCaseOfTransactionException = NonInitialResponseBuilder.this.classLoader.getBalanceOf(this.deserializedPayer);
            this.redBalanceOfPayerInCaseOfTransactionException = NonInitialResponseBuilder.this.classLoader.getRedBalanceOf(this.deserializedPayer);
        }

        protected Object deserializedPayer() {
            return this.deserializedCaller;
        }

        protected final Object getDeserializedCaller() {
            return this.deserializedCaller;
        }

        protected final Optional<Object> getDeserializedValidators() {
            return this.deserializedValidators;
        }

        protected final BigInteger gasConsumedForCPU() {
            return this.gasConsumedForCPU;
        }

        protected final BigInteger gasConsumedForRAM() {
            return this.gasConsumedForRAM;
        }

        protected final BigInteger gasConsumedForStorage() {
            return this.gasConsumedForStorage;
        }

        protected final BigInteger gasConsumedForPenalty() {
            return ((NonInitialTransactionRequest)((NonInitialResponseBuilder)NonInitialResponseBuilder.this).request).gasLimit.subtract(this.gasConsumedForCPU).subtract(this.gasConsumedForRAM).subtract(this.gasConsumedForStorage);
        }

        private void charge(BigInteger amount, Consumer<BigInteger> forWhat) {
            if (amount.signum() < 0) {
                throw new IllegalArgumentException("gas cannot increase");
            }
            if (this.gas.signum() < 0) {
                return;
            }
            if (this.gas.compareTo(amount) < 0) {
                throw new OutOfGasError();
            }
            this.gas = this.gas.subtract(amount);
            forWhat.accept(amount);
        }

        private void chargeGasForStorage(BigInteger amount) {
            this.charge(amount, x -> {
                this.gasConsumedForStorage = this.gasConsumedForStorage.add((BigInteger)x);
            });
        }

        protected final void chargeGasForStorageOf(Response response) {
            this.chargeGasForStorage(response.size(NonInitialResponseBuilder.this.gasCostModel));
        }

        @Override
        public final void chargeGasForCPU(BigInteger amount) {
            this.charge(amount, x -> {
                this.gasConsumedForCPU = this.gasConsumedForCPU.add((BigInteger)x);
            });
        }

        @Override
        public final void chargeGasForRAM(BigInteger amount) {
            this.charge(amount, x -> {
                this.gasConsumedForRAM = this.gasConsumedForRAM.add((BigInteger)x);
            });
        }

        protected final void chargeGasForClassLoader() {
            NonInitialResponseBuilder.this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)NonInitialResponseBuilder.this.gasCostModel).cpuCostForLoadingJar(arg_0)).forEach(this::chargeGasForCPU);
            NonInitialResponseBuilder.this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)NonInitialResponseBuilder.this.gasCostModel).ramCostForLoadingJar(arg_0)).forEach(this::chargeGasForRAM);
        }

        protected final Stream<Update> updatesToBalanceOrNonceOfCaller() {
            return this.updatesExtractor.extractUpdatesFrom(Stream.of(this.deserializedCaller)).filter(this::isUpdateToBalanceOrNonceOfCaller);
        }

        protected final boolean isUpdateToBalanceOrNonceOfCaller(Update update) {
            if (update instanceof UpdateOfField && update.object.equals((Object)((NonInitialTransactionRequest)((NonInitialResponseBuilder)NonInitialResponseBuilder.this).request).caller)) {
                FieldSignature field = ((UpdateOfField)update).getField();
                return FieldSignature.BALANCE_FIELD.equals((Object)field) || FieldSignature.RED_BALANCE_FIELD.equals((Object)field) || FieldSignature.EOA_NONCE_FIELD.equals((Object)field);
            }
            return false;
        }

        private BigInteger chargePayerForAllGasPromised() {
            BigInteger cost = NonInitialResponseBuilder.this.costOf(((NonInitialTransactionRequest)((NonInitialResponseBuilder)NonInitialResponseBuilder.this).request).gasLimit);
            BigInteger greenBalance = NonInitialResponseBuilder.this.classLoader.getBalanceOf(this.deserializedPayer);
            BigInteger redBalance = NonInitialResponseBuilder.this.classLoader.getRedBalanceOf(this.deserializedPayer);
            BigInteger newRedBalance = redBalance.subtract(cost);
            if (newRedBalance.signum() >= 0) {
                NonInitialResponseBuilder.this.classLoader.setRedBalanceOf(this.deserializedPayer, newRedBalance);
                return BigInteger.ZERO;
            }
            NonInitialResponseBuilder.this.classLoader.setRedBalanceOf(this.deserializedPayer, BigInteger.ZERO);
            NonInitialResponseBuilder.this.classLoader.setBalanceOf(this.deserializedPayer, greenBalance.add(newRedBalance));
            return newRedBalance.negate();
        }

        protected final void refundPayerForAllRemainingGas() {
            BigInteger refund = NonInitialResponseBuilder.this.costOf(this.gas);
            BigInteger greenBalance = NonInitialResponseBuilder.this.classLoader.getBalanceOf(this.deserializedPayer);
            if (refund.subtract(this.greenInitiallyPaidForGas).signum() <= 0) {
                NonInitialResponseBuilder.this.classLoader.setBalanceOf(this.deserializedPayer, greenBalance.add(refund));
            } else {
                BigInteger redBalance = NonInitialResponseBuilder.this.classLoader.getRedBalanceOf(this.deserializedPayer);
                NonInitialResponseBuilder.this.classLoader.setBalanceOf(this.deserializedPayer, greenBalance.add(this.greenInitiallyPaidForGas));
                NonInitialResponseBuilder.this.classLoader.setRedBalanceOf(this.deserializedPayer, redBalance.add(refund.subtract(this.greenInitiallyPaidForGas)));
            }
        }

        protected final void resetBalanceOfPayerToInitialValueMinusAllPromisedGas() {
            NonInitialResponseBuilder.this.classLoader.setBalanceOf(this.deserializedPayer, this.greenBalanceOfPayerInCaseOfTransactionException);
            NonInitialResponseBuilder.this.classLoader.setRedBalanceOf(this.deserializedPayer, this.redBalanceOfPayerInCaseOfTransactionException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> T withGas(BigInteger amount, Callable<T> what) throws Exception {
            this.chargeGasForCPU(amount);
            this.oldGas.addFirst(this.gas);
            this.gas = amount;
            try {
                T t = what.call();
                return t;
            }
            finally {
                this.gas = this.gas.add(this.oldGas.removeFirst());
            }
        }

        private void increaseNonceOfCaller() {
            if (!NonInitialResponseBuilder.this.transactionIsView()) {
                NonInitialResponseBuilder.this.classLoader.setNonceOf(this.deserializedCaller, ((NonInitialTransactionRequest)((NonInitialResponseBuilder)NonInitialResponseBuilder.this).request).nonce.add(BigInteger.ONE));
            }
        }
    }
}

