/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local;

import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Config {
    public final Path dir;
    public final int maxPollingAttempts;
    public final int pollingDelay;
    public final int requestCacheSize;
    public final int responseCacheSize;
    public final BigInteger maxGasPerViewTransaction;

    private Config(Path dir, int maxPollingAttempts, int pollingDelay, int requestCacheSize, int responseCacheSize, BigInteger maxGasPerViewTransaction) {
        this.dir = dir;
        this.maxPollingAttempts = maxPollingAttempts;
        this.pollingDelay = pollingDelay;
        this.requestCacheSize = requestCacheSize;
        this.responseCacheSize = responseCacheSize;
        this.maxGasPerViewTransaction = maxGasPerViewTransaction;
    }

    protected Config(Config parent) {
        this.dir = parent.dir;
        this.maxPollingAttempts = parent.maxPollingAttempts;
        this.pollingDelay = parent.pollingDelay;
        this.requestCacheSize = parent.requestCacheSize;
        this.responseCacheSize = parent.responseCacheSize;
        this.maxGasPerViewTransaction = parent.maxGasPerViewTransaction;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private Path dir = Paths.get("chain", new String[0]);
        private int maxPollingAttempts = 60;
        private int pollingDelay = 10;
        private int requestCacheSize = 1000;
        private int responseCacheSize = 1000;
        private BigInteger maxGasPerViewTransaction = BigInteger.valueOf(1000000L);

        protected abstract T getThis();

        public T setMaxGasPerViewTransaction(BigInteger maxGasPerViewTransaction) {
            if (maxGasPerViewTransaction == null) {
                throw new NullPointerException("the maximal amount of gas per transaction cannot be null");
            }
            this.maxGasPerViewTransaction = maxGasPerViewTransaction;
            return this.getThis();
        }

        public T setDir(Path dir) {
            this.dir = dir;
            return this.getThis();
        }

        public T setMaxPollingAttempts(int maxPollingAttempts) {
            this.maxPollingAttempts = maxPollingAttempts;
            return this.getThis();
        }

        public T setPollingDelay(int pollingDelay) {
            this.pollingDelay = pollingDelay;
            return this.getThis();
        }

        public T setRequestCacheSize(int requestCacheSize) {
            this.requestCacheSize = requestCacheSize;
            return this.getThis();
        }

        public T setResponseCacheSize(int responseCacheSize) {
            this.responseCacheSize = responseCacheSize;
            return this.getThis();
        }

        public Config build() {
            return new Config(this.dir, this.maxPollingAttempts, this.pollingDelay, this.requestCacheSize, this.responseCacheSize, this.maxGasPerViewTransaction);
        }
    }
}

