/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local;

import io.hotmoka.beans.InternalFailureException;
import io.hotmoka.beans.annotations.ThreadSafe;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.InitializationTransactionRequest;
import io.hotmoka.beans.requests.TransactionRequest;
import io.hotmoka.beans.responses.GameteCreationTransactionResponse;
import io.hotmoka.beans.responses.InitializationTransactionResponse;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseWithUpdates;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.local.AbstractLocalNode;
import io.hotmoka.local.Config;
import io.hotmoka.local.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractStore<C extends Config>
implements Store {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractStore.class);
    private final AtomicLong timeSpent = new AtomicLong();
    protected final Object lock = new Object();
    protected final AbstractLocalNode<? extends C, ? extends AbstractStore<? extends C>> node;
    protected final C config;

    protected AbstractStore(AbstractLocalNode<? extends C, ? extends AbstractStore<? extends C>> node) {
        this.node = node;
        this.config = node.config;
    }

    protected AbstractStore(AbstractStore<? extends C> parent) {
        this.node = parent.node;
        this.config = parent.config;
    }

    @Override
    public void close() {
        logger.info("Time spent in state procedures: " + this.timeSpent + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void push(TransactionReference reference, TransactionRequest<?> request, TransactionResponse response) {
        Object object = this.lock;
        synchronized (object) {
            this.setResponse(reference, request, response);
            if (response instanceof TransactionResponseWithUpdates) {
                this.expandHistory(reference, (TransactionResponseWithUpdates)response);
            }
            if (response instanceof InitializationTransactionResponse) {
                StorageReference manifest = ((InitializationTransactionRequest)request).manifest;
                this.setManifest(manifest);
                logger.info(manifest + ": set as manifest");
                logger.info("the node has been initialized");
            }
            if (response instanceof GameteCreationTransactionResponse) {
                logger.info(((GameteCreationTransactionResponse)response).gamete + ": created as gamete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void replace(TransactionReference reference, TransactionRequest<?> request, TransactionResponse response) {
        Object object = this.lock;
        synchronized (object) {
            this.setResponse(reference, request, response);
        }
    }

    protected abstract void setResponse(TransactionReference var1, TransactionRequest<?> var2, TransactionResponse var3);

    protected abstract void setHistory(StorageReference var1, Stream<TransactionReference> var2);

    protected abstract void setManifest(StorageReference var1);

    protected final void recordTime(Runnable task) {
        long start = System.currentTimeMillis();
        task.run();
        this.timeSpent.addAndGet(System.currentTimeMillis() - start);
    }

    protected final <T> T recordTime(Supplier<T> task) {
        long start = System.currentTimeMillis();
        T result = task.get();
        this.timeSpent.addAndGet(System.currentTimeMillis() - start);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T recordTimeSynchronized(Supplier<T> task) {
        T result;
        long start = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            result = task.get();
        }
        this.timeSpent.addAndGet(System.currentTimeMillis() - start);
        return result;
    }

    private void expandHistory(TransactionReference reference, TransactionResponseWithUpdates response) {
        response.getUpdates().map(Update::getObject).distinct().forEachOrdered(object -> this.setHistory((StorageReference)object, this.simplifiedHistory((StorageReference)object, reference, response.getUpdates())));
    }

    private Stream<TransactionReference> simplifiedHistory(StorageReference object, TransactionReference added, Stream<Update> addedUpdates) {
        Stream<TransactionReference> old = this.getHistoryUncommitted(object);
        Set<Update> covered = addedUpdates.filter(update -> update.object.equals((Object)object)).collect(Collectors.toSet());
        ArrayList<TransactionReference> simplified = new ArrayList<TransactionReference>();
        simplified.add(added);
        TransactionReference[] oldAsArray = (TransactionReference[])old.toArray(TransactionReference[]::new);
        int length = oldAsArray.length;
        for (int pos = 0; pos < length - 1; ++pos) {
            this.addIfUncovered(oldAsArray[pos], object, covered, simplified);
        }
        if (length >= 1) {
            simplified.add(oldAsArray[length - 1]);
        }
        return simplified.stream();
    }

    private void addIfUncovered(TransactionReference reference, StorageReference object, Set<Update> covered, List<TransactionReference> history) {
        Optional<TransactionResponse> response = this.node.caches.getResponseUncommitted(reference);
        if (response.isEmpty()) {
            logger.error("history contains a reference to a transaction not in store");
            throw new InternalFailureException("history contains a reference to a transaction not in store");
        }
        if (!(response.get() instanceof TransactionResponseWithUpdates)) {
            logger.error("history contains a reference to a transaction without updates");
            throw new InternalFailureException("history contains a reference to a transaction without updates");
        }
        Set diff = ((TransactionResponseWithUpdates)response.get()).getUpdates().filter(update -> {
            if (!update.object.equals((Object)object)) return false;
            if (!covered.stream().noneMatch(arg_0 -> ((Update)update).sameProperty(arg_0))) return false;
            return true;
        }).collect(Collectors.toSet());
        if (!diff.isEmpty()) {
            history.add(reference);
            covered.addAll(diff);
        }
    }
}

