/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.local;

import io.hotmoka.beans.CodeExecutionException;
import io.hotmoka.beans.GasCostModel;
import io.hotmoka.beans.InternalFailureException;
import io.hotmoka.beans.TransactionException;
import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.annotations.ThreadSafe;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.AbstractInstanceMethodCallTransactionRequest;
import io.hotmoka.beans.requests.ConstructorCallTransactionRequest;
import io.hotmoka.beans.requests.GameteCreationTransactionRequest;
import io.hotmoka.beans.requests.InitialTransactionRequest;
import io.hotmoka.beans.requests.InitializationTransactionRequest;
import io.hotmoka.beans.requests.InstanceMethodCallTransactionRequest;
import io.hotmoka.beans.requests.InstanceSystemMethodCallTransactionRequest;
import io.hotmoka.beans.requests.JarStoreInitialTransactionRequest;
import io.hotmoka.beans.requests.JarStoreTransactionRequest;
import io.hotmoka.beans.requests.NonInitialTransactionRequest;
import io.hotmoka.beans.requests.StaticMethodCallTransactionRequest;
import io.hotmoka.beans.requests.SystemTransactionRequest;
import io.hotmoka.beans.requests.TransactionRequest;
import io.hotmoka.beans.responses.GameteCreationTransactionResponse;
import io.hotmoka.beans.responses.JarStoreInitialTransactionResponse;
import io.hotmoka.beans.responses.MethodCallTransactionFailedResponse;
import io.hotmoka.beans.responses.NonInitialTransactionResponse;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseFailed;
import io.hotmoka.beans.responses.TransactionResponseWithEvents;
import io.hotmoka.beans.responses.TransactionResponseWithUpdates;
import io.hotmoka.beans.signatures.CodeSignature;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.instrumentation.StandardGasCostModel;
import io.hotmoka.local.AbstractStore;
import io.hotmoka.local.Config;
import io.hotmoka.local.EngineClassLoader;
import io.hotmoka.local.NodeCaches;
import io.hotmoka.local.ResponseBuilder;
import io.hotmoka.local.Store;
import io.hotmoka.local.StoreUtilities;
import io.hotmoka.local.internal.LRUCache;
import io.hotmoka.local.internal.NodeCachesImpl;
import io.hotmoka.local.internal.NodeInternal;
import io.hotmoka.local.internal.StoreUtilitiesImpl;
import io.hotmoka.local.internal.transactions.ConstructorCallResponseBuilder;
import io.hotmoka.local.internal.transactions.GameteCreationResponseBuilder;
import io.hotmoka.local.internal.transactions.InitializationResponseBuilder;
import io.hotmoka.local.internal.transactions.InstanceMethodCallResponseBuilder;
import io.hotmoka.local.internal.transactions.InstanceViewMethodCallResponseBuilder;
import io.hotmoka.local.internal.transactions.JarStoreInitialResponseBuilder;
import io.hotmoka.local.internal.transactions.JarStoreResponseBuilder;
import io.hotmoka.local.internal.transactions.StaticMethodCallResponseBuilder;
import io.hotmoka.local.internal.transactions.StaticViewMethodCallResponseBuilder;
import io.hotmoka.nodes.AbstractNode;
import io.hotmoka.nodes.ConsensusParams;
import io.hotmoka.nodes.Node;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractLocalNode<C extends Config, S extends AbstractStore<C>>
extends AbstractNode {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractLocalNode.class);
    protected final C config;
    protected final StoreUtilities storeUtilities;
    protected final NodeCaches caches;
    protected final S store;
    private final GasCostModel gasCostModel = new StandardGasCostModel();
    private final ConcurrentMap<TransactionReference, Semaphore> semaphores;
    private final ExecutorService executor;
    private final AtomicLong checkTime;
    private final AtomicLong deliverTime;
    private final LRUCache<TransactionReference, String> recentCheckTransactionErrors;
    private final AtomicBoolean closed;
    private volatile BigInteger gasConsumedSinceLastReward;
    private volatile BigInteger coinsSinceLastReward;
    private volatile BigInteger numberOfTransactionsSinceLastReward;
    final NodeInternal internal = new NodeInternalImpl();
    private static final BigInteger GAS_FOR_REWARD = BigInteger.valueOf(100000L);
    private static final BigInteger _1_000_000 = BigInteger.valueOf(1000000L);
    private final Object deliverTransactionLock = new Object();

    protected AbstractLocalNode(C config, ConsensusParams consensus) {
        this(config, consensus, true);
    }

    protected AbstractLocalNode(C config) {
        this(config, null, false);
    }

    private AbstractLocalNode(C config, ConsensusParams consensus, boolean deleteDir) {
        try {
            this.config = config;
            this.storeUtilities = new StoreUtilitiesImpl(this.internal);
            this.caches = new NodeCachesImpl(this.internal, consensus);
            this.recentCheckTransactionErrors = new LRUCache(100, 1000);
            this.gasConsumedSinceLastReward = BigInteger.ZERO;
            this.coinsSinceLastReward = BigInteger.ZERO;
            this.numberOfTransactionsSinceLastReward = BigInteger.ZERO;
            this.executor = Executors.newCachedThreadPool();
            this.semaphores = new ConcurrentHashMap<TransactionReference, Semaphore>();
            this.checkTime = new AtomicLong();
            this.deliverTime = new AtomicLong();
            this.closed = new AtomicBoolean();
            if (deleteDir) {
                AbstractLocalNode.deleteRecursively(((Config)config).dir);
                Files.createDirectories(((Config)config).dir, new FileAttribute[0]);
            }
            this.store = this.mkStore();
            this.addShutdownHook();
        }
        catch (Exception e) {
            logger.error("failed to create the node", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    protected AbstractLocalNode(AbstractLocalNode<C, S> parent) {
        super(parent);
        this.config = parent.config;
        this.caches = new NodeCachesImpl(this.internal, parent.caches.getConsensusParams());
        this.recentCheckTransactionErrors = parent.recentCheckTransactionErrors;
        this.gasConsumedSinceLastReward = parent.gasConsumedSinceLastReward;
        this.coinsSinceLastReward = parent.coinsSinceLastReward;
        this.numberOfTransactionsSinceLastReward = parent.numberOfTransactionsSinceLastReward;
        this.executor = parent.executor;
        this.store = this.mkStore();
        this.storeUtilities = new StoreUtilitiesImpl(this.internal, (Store)this.store);
        this.semaphores = parent.semaphores;
        this.checkTime = parent.checkTime;
        this.deliverTime = parent.deliverTime;
        this.closed = parent.closed;
    }

    protected abstract S mkStore();

    protected final boolean isNotYetClosed() {
        return !this.closed.getAndSet(true);
    }

    public void close() throws Exception {
        S store = this.store;
        if (store != null) {
            ((AbstractStore)store).close();
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        logger.info("Time spent checking requests: " + this.checkTime + "ms");
        logger.info("Time spent delivering requests: " + this.deliverTime + "ms");
    }

    public final String getNameOfSignatureAlgorithmForRequests() {
        return this.caches.getConsensusParams().signature;
    }

    public final TransactionReference getTakamakaCode() throws NoSuchElementException {
        return this.getClassTag((StorageReference)this.getManifest()).jar;
    }

    public final StorageReference getManifest() throws NoSuchElementException {
        return this.store.getManifest().orElseThrow(() -> new NoSuchElementException("no manifest set for this node"));
    }

    public final TransactionResponse getPolledResponse(TransactionReference reference) throws TransactionRejectedException, TimeoutException, InterruptedException {
        try {
            Objects.requireNonNull(reference);
            Semaphore semaphore = (Semaphore)this.semaphores.get(reference);
            if (semaphore != null) {
                semaphore.acquire();
            }
            int delay = ((Config)this.config).pollingDelay;
            for (int attempt = 1; attempt <= Math.max(1, ((Config)this.config).maxPollingAttempts); ++attempt) {
                try {
                    TransactionResponse response = this.getResponse(reference);
                    this.getRequest(reference);
                    return response;
                }
                catch (NoSuchElementException e) {
                    Thread.sleep(delay);
                    delay = delay * 110 / 100;
                    continue;
                }
            }
            throw new TimeoutException("cannot find the response of transaction reference " + reference + ": tried " + ((Config)this.config).maxPollingAttempts + " times");
        }
        catch (TransactionRejectedException | InterruptedException | TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    public final TransactionRequest<?> getRequest(TransactionReference reference) throws NoSuchElementException {
        Optional<TransactionRequest<?>> request;
        Objects.requireNonNull(reference);
        try {
            request = this.caches.getRequest(reference);
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
        return request.orElseThrow(() -> new NoSuchElementException("unknown transaction reference " + reference));
    }

    public final TransactionResponse getResponse(TransactionReference reference) throws TransactionRejectedException, NoSuchElementException {
        String error;
        Objects.requireNonNull(reference);
        try {
            Optional<TransactionResponse> response = this.caches.getResponse(reference);
            if (response.isPresent()) {
                return response.get();
            }
            error = this.store.getError(reference).orElseGet(() -> this.recentCheckTransactionErrors.get(reference));
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
        if (error != null) {
            throw new TransactionRejectedException(error);
        }
        throw new NoSuchElementException("unknown transaction reference " + reference);
    }

    public final ClassTag getClassTag(StorageReference reference) throws NoSuchElementException {
        Objects.requireNonNull(reference);
        try {
            if (this.isNotCommitted(reference.transaction)) {
                throw new NoSuchElementException("unknown transaction reference " + reference.transaction);
            }
            return this.storeUtilities.getClassTagUncommitted(reference);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    public final Stream<Update> getState(StorageReference reference) throws NoSuchElementException {
        Objects.requireNonNull(reference);
        try {
            if (this.isNotCommitted(reference.transaction)) {
                throw new NoSuchElementException("unknown transaction reference " + reference.transaction);
            }
            return this.storeUtilities.getStateCommitted(reference);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    public final TransactionReference addJarStoreInitialTransaction(JarStoreInitialTransactionRequest request) throws TransactionRejectedException {
        return (TransactionReference)AbstractLocalNode.wrapInCaseOfExceptionSimple(() -> {
            TransactionReference reference = this.post((TransactionRequest<?>)request);
            return ((JarStoreInitialTransactionResponse)this.getPolledResponse(reference)).getOutcomeAt(reference);
        });
    }

    public void addInitializationTransaction(InitializationTransactionRequest request) throws TransactionRejectedException {
        AbstractLocalNode.wrapInCaseOfExceptionSimple(() -> this.getPolledResponse(this.post((TransactionRequest<?>)request)));
    }

    public final StorageReference addGameteCreationTransaction(GameteCreationTransactionRequest request) throws TransactionRejectedException {
        return (StorageReference)AbstractLocalNode.wrapInCaseOfExceptionSimple(() -> ((GameteCreationTransactionResponse)this.getPolledResponse(this.post((TransactionRequest<?>)request))).getOutcome());
    }

    public final TransactionReference addJarStoreTransaction(JarStoreTransactionRequest request) throws TransactionRejectedException, TransactionException {
        return (TransactionReference)AbstractLocalNode.wrapInCaseOfExceptionMedium(() -> this.postJarStoreTransaction(request).get());
    }

    public final StorageReference addConstructorCallTransaction(ConstructorCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageReference)AbstractLocalNode.wrapInCaseOfExceptionFull(() -> (StorageReference)this.postConstructorCallTransaction(request).get());
    }

    public final StorageValue addInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNode.wrapInCaseOfExceptionFull(() -> this.postInstanceMethodCallTransaction(request).get());
    }

    public final StorageValue addStaticMethodCallTransaction(StaticMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNode.wrapInCaseOfExceptionFull(() -> this.postStaticMethodCallTransaction(request).get());
    }

    public final StorageValue runInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNode.wrapInCaseOfExceptionFull(() -> {
            StorageValue result;
            TransactionReference reference = request.getReference();
            logger.info(reference + ": running start (" + request.getClass().getSimpleName() + " -> " + request.method.methodName + ")");
            Object object = this.deliverTransactionLock;
            synchronized (object) {
                result = new InstanceViewMethodCallResponseBuilder(reference, request, this.internal).getResponse().getOutcome();
            }
            logger.info(reference + ": running success");
            return result;
        });
    }

    public final StorageValue runStaticMethodCallTransaction(StaticMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNode.wrapInCaseOfExceptionFull(() -> {
            StorageValue result;
            TransactionReference reference = request.getReference();
            logger.info(reference + ": running start (" + request.getClass().getSimpleName() + " -> " + request.method.methodName + ")");
            Object object = this.deliverTransactionLock;
            synchronized (object) {
                result = new StaticViewMethodCallResponseBuilder(reference, request, this.internal).getResponse().getOutcome();
            }
            logger.info(reference + ": running success");
            return result;
        });
    }

    public final Node.JarSupplier postJarStoreTransaction(JarStoreTransactionRequest request) throws TransactionRejectedException {
        return (Node.JarSupplier)AbstractLocalNode.wrapInCaseOfExceptionSimple(() -> this.jarSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    public final Node.CodeSupplier<StorageReference> postConstructorCallTransaction(ConstructorCallTransactionRequest request) throws TransactionRejectedException {
        return (Node.CodeSupplier)AbstractLocalNode.wrapInCaseOfExceptionSimple(() -> this.constructorSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    public final Node.CodeSupplier<StorageValue> postInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException {
        return (Node.CodeSupplier)AbstractLocalNode.wrapInCaseOfExceptionSimple(() -> this.methodSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    public final Node.CodeSupplier<StorageValue> postStaticMethodCallTransaction(StaticMethodCallTransactionRequest request) throws TransactionRejectedException {
        return (Node.CodeSupplier)AbstractLocalNode.wrapInCaseOfExceptionSimple(() -> this.methodSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    protected final void checkTransaction(TransactionRequest<?> request) throws TransactionRejectedException {
        long start = System.currentTimeMillis();
        TransactionReference reference = request.getReference();
        this.recentCheckTransactionErrors.put(reference, null);
        try {
            logger.info(reference + ": checking start (" + request.getClass().getSimpleName() + ")");
            this.responseBuilderFor(reference, request);
            logger.info(reference + ": checking success");
        }
        catch (TransactionRejectedException e) {
            this.signalSemaphore(reference);
            this.recentCheckTransactionErrors.put(reference, this.trimmedMessage(e));
            logger.info(reference + ": checking failed: " + this.trimmedMessage(e));
            logger.info("transaction rejected", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.signalSemaphore(reference);
            this.recentCheckTransactionErrors.put(reference, this.trimmedMessage(e));
            logger.error(reference + ": checking failed with unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
        finally {
            this.checkTime.addAndGet(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TransactionResponse deliverTransaction(TransactionRequest<?> request) throws TransactionRejectedException {
        long start = System.currentTimeMillis();
        TransactionReference reference = request.getReference();
        try {
            Object response;
            logger.info(reference + ": delivering start");
            Object object = this.deliverTransactionLock;
            synchronized (object) {
                ResponseBuilder<?, ?> responseBuilder = this.responseBuilderFor(reference, request);
                response = responseBuilder.getResponse();
                ((AbstractStore)this.store).push(reference, request, (TransactionResponse)response);
                responseBuilder.replaceReverifiedResponses();
                this.scheduleForNotificationOfEvents((TransactionResponse)response);
                this.takeNoteForNextReward(request, (TransactionResponse)response);
                this.invalidateCachesIfNeeded((TransactionResponse)response, responseBuilder.getClassLoader());
            }
            logger.info(reference + ": delivering success");
            object = response;
            return object;
        }
        catch (TransactionRejectedException e) {
            this.store.push(reference, request, this.trimmedMessage(e));
            logger.info(reference + ": delivering failed: " + this.trimmedMessage(e));
            logger.info("transaction rejected", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.store.push(reference, request, this.trimmedMessage(e));
            logger.error(reference + ": delivering failed with unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
        finally {
            this.signalSemaphore(reference);
            this.deliverTime.addAndGet(System.currentTimeMillis() - start);
        }
    }

    protected final boolean rewardValidators(String behaving, String misbehaving) {
        block5: {
            if (this.caches.getConsensusParams() == null) {
                return false;
            }
            try {
                Optional<StorageReference> manifest = this.store.getManifestUncommitted();
                if (!manifest.isPresent()) break block5;
                StorageReference caller = manifest.get();
                BigInteger nonce = this.storeUtilities.getNonceUncommitted(caller);
                StorageReference validators = this.caches.getValidators().get();
                TransactionReference takamakaCode = this.getTakamakaCode();
                InstanceSystemMethodCallTransactionRequest request = new InstanceSystemMethodCallTransactionRequest(caller, nonce, GAS_FOR_REWARD, takamakaCode, CodeSignature.VALIDATORS_REWARD, validators, new StorageValue[]{new BigIntegerValue(this.coinsSinceLastReward), new StringValue(behaving), new StringValue(misbehaving), new BigIntegerValue(this.gasConsumedSinceLastReward), new BigIntegerValue(this.numberOfTransactionsSinceLastReward)});
                this.checkTransaction((TransactionRequest<?>)request);
                ResponseBuilder<?, ?> responseBuilder = this.responseBuilderFor(request.getReference(), (TransactionRequest<?>)request);
                Object response = responseBuilder.getResponse();
                if (!(response instanceof TransactionResponseWithUpdates) || ((TransactionResponseWithUpdates)response).getUpdates().count() > 1L) {
                    response = this.deliverTransaction((TransactionRequest<?>)request);
                }
                if (response instanceof MethodCallTransactionFailedResponse) {
                    MethodCallTransactionFailedResponse responseAsFailed = (MethodCallTransactionFailedResponse)response;
                    logger.error("could not reward the validators: " + responseAsFailed.where + ": " + responseAsFailed.classNameOfCause + ": " + responseAsFailed.messageOfCause);
                    break block5;
                }
                logger.info("units of gas consumed for CPU or storage since the previous reward: " + this.gasConsumedSinceLastReward);
                logger.info("units of coin rewarded to the validators for their work since the previous reward: " + this.coinsSinceLastReward);
                this.gasConsumedSinceLastReward = BigInteger.ZERO;
                this.coinsSinceLastReward = BigInteger.ZERO;
                this.numberOfTransactionsSinceLastReward = BigInteger.ZERO;
                return true;
            }
            catch (Exception e) {
                logger.error("could not reward the validators", (Throwable)e);
            }
        }
        return false;
    }

    protected final String trimmedMessage(Throwable t) {
        int maxErrorLength;
        String message = t.getMessage();
        int length = message.length();
        if (length > (maxErrorLength = this.caches.getConsensusParams().maxErrorLength)) {
            return message.substring(0, maxErrorLength) + "...";
        }
        return message;
    }

    protected final void notifyEventsOf(TransactionResponseWithEvents response) {
        try {
            response.getEvents().forEachOrdered(event -> this.notifyEvent(this.storeUtilities.getCreatorUncommitted((StorageReference)event), (StorageReference)event));
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    protected final TransactionReference post(TransactionRequest<?> request) throws TransactionRejectedException {
        TransactionReference reference = request.getReference();
        logger.info(reference + ": posting (" + request.getClass().getSimpleName() + ")");
        if (this.caches.getResponseUncommitted(reference).isPresent()) {
            throw new TransactionRejectedException("repeated request");
        }
        this.createSemaphore(reference);
        this.postRequest(request);
        return reference;
    }

    protected void invalidateCaches() {
        this.caches.invalidate();
        this.gasConsumedSinceLastReward = BigInteger.ZERO;
        this.coinsSinceLastReward = BigInteger.ZERO;
        this.numberOfTransactionsSinceLastReward = BigInteger.ZERO;
        this.recentCheckTransactionErrors.clear();
        logger.info("the caches of the node have been invalidated");
    }

    protected void invalidateCachesIfNeeded(TransactionResponse response, EngineClassLoader classLoader) {
        this.caches.invalidateIfNeeded(response, classLoader);
    }

    protected BigInteger getRequestStorageCost(NonInitialTransactionRequest<?> request) {
        return request.size(this.gasCostModel);
    }

    protected ResponseBuilder<?, ?> responseBuilderFor(TransactionReference reference, TransactionRequest<?> request) throws TransactionRejectedException {
        if (request instanceof JarStoreInitialTransactionRequest) {
            return new JarStoreInitialResponseBuilder(reference, (JarStoreInitialTransactionRequest)request, this.internal);
        }
        if (request instanceof GameteCreationTransactionRequest) {
            return new GameteCreationResponseBuilder(reference, (GameteCreationTransactionRequest)request, this.internal);
        }
        if (request instanceof JarStoreTransactionRequest) {
            return new JarStoreResponseBuilder(reference, (JarStoreTransactionRequest)request, this.internal);
        }
        if (request instanceof ConstructorCallTransactionRequest) {
            return new ConstructorCallResponseBuilder(reference, (ConstructorCallTransactionRequest)request, this.internal);
        }
        if (request instanceof AbstractInstanceMethodCallTransactionRequest) {
            return new InstanceMethodCallResponseBuilder(reference, (AbstractInstanceMethodCallTransactionRequest)request, this.internal);
        }
        if (request instanceof StaticMethodCallTransactionRequest) {
            return new StaticMethodCallResponseBuilder(reference, (StaticMethodCallTransactionRequest)request, this.internal);
        }
        if (request instanceof InitializationTransactionRequest) {
            return new InitializationResponseBuilder(reference, (InitializationTransactionRequest)request, this.internal);
        }
        throw new TransactionRejectedException("unexpected transaction request of class " + request.getClass().getName());
    }

    protected boolean admitsAfterInitialization(InitialTransactionRequest<?> request) {
        return false;
    }

    protected abstract void postRequest(TransactionRequest<?> var1);

    protected abstract void scheduleForNotificationOfEvents(TransactionResponseWithEvents var1);

    private boolean isNotCommitted(TransactionReference transaction) {
        try {
            this.getResponse(transaction);
            return false;
        }
        catch (TransactionRejectedException | NoSuchElementException e) {
            return true;
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
            throw InternalFailureException.of((Throwable)e);
        }
    }

    private void takeNoteForNextReward(TransactionRequest<?> request, TransactionResponse response) {
        if (!(request instanceof SystemTransactionRequest)) {
            this.numberOfTransactionsSinceLastReward = this.numberOfTransactionsSinceLastReward.add(BigInteger.ONE);
            if (response instanceof NonInitialTransactionResponse) {
                NonInitialTransactionResponse responseAsNonInitial = (NonInitialTransactionResponse)response;
                BigInteger gasConsumedButPenalty = responseAsNonInitial.gasConsumedForCPU.add(responseAsNonInitial.gasConsumedForStorage).add(responseAsNonInitial.gasConsumedForRAM);
                this.gasConsumedSinceLastReward = this.gasConsumedSinceLastReward.add(gasConsumedButPenalty);
                BigInteger gasConsumedTotal = gasConsumedButPenalty;
                if (response instanceof TransactionResponseFailed) {
                    gasConsumedTotal = gasConsumedTotal.add(((TransactionResponseFailed)response).gasConsumedForPenalty());
                }
                gasConsumedTotal = this.addInflation(gasConsumedTotal);
                BigInteger reward = gasConsumedTotal.multiply(((NonInitialTransactionRequest)request).gasPrice);
                this.coinsSinceLastReward = this.coinsSinceLastReward.add(reward);
            }
        }
    }

    private BigInteger addInflation(BigInteger gas) {
        ConsensusParams consensus = this.caches.getConsensusParams();
        if (consensus != null) {
            gas = gas.multiply(_1_000_000.add(BigInteger.valueOf(consensus.inflation))).divide(_1_000_000);
        }
        return gas;
    }

    private void scheduleForNotificationOfEvents(TransactionResponse response) {
        TransactionResponseWithEvents responseWithEvents;
        if (response instanceof TransactionResponseWithEvents && (responseWithEvents = (TransactionResponseWithEvents)response).getEvents().count() > 0L) {
            this.scheduleForNotificationOfEvents(responseWithEvents);
        }
    }

    private void createSemaphore(TransactionReference reference) {
        if (this.semaphores.putIfAbsent(reference, new Semaphore(0)) != null) {
            throw new InternalFailureException("repeated request");
        }
    }

    private void signalSemaphore(TransactionReference reference) {
        Semaphore semaphore = (Semaphore)this.semaphores.remove(reference);
        if (semaphore != null) {
            semaphore.release();
        }
    }

    private static void deleteRecursively(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private class NodeInternalImpl
    implements NodeInternal {
        private NodeInternalImpl() {
        }

        @Override
        public Config getConfig() {
            return AbstractLocalNode.this.config;
        }

        @Override
        public NodeCaches getCaches() {
            return AbstractLocalNode.this.caches;
        }

        @Override
        public GasCostModel getGasCostModel() {
            return AbstractLocalNode.this.gasCostModel;
        }

        @Override
        public Store getStore() {
            return AbstractLocalNode.this.store;
        }

        @Override
        public StoreUtilities getStoreUtilities() {
            return AbstractLocalNode.this.storeUtilities;
        }

        @Override
        public BigInteger getRequestStorageCost(NonInitialTransactionRequest<?> request) {
            return AbstractLocalNode.this.getRequestStorageCost(request);
        }

        @Override
        public boolean admitsAfterInitialization(InitialTransactionRequest<?> request) {
            return AbstractLocalNode.this.admitsAfterInitialization(request);
        }

        @Override
        public TransactionRequest<?> getRequest(TransactionReference reference) throws NoSuchElementException {
            return AbstractLocalNode.this.getRequest(reference);
        }

        @Override
        public TransactionResponse getResponse(TransactionReference reference) throws TransactionRejectedException, NoSuchElementException {
            return AbstractLocalNode.this.getResponse(reference);
        }

        @Override
        public ClassTag getClassTag(StorageReference object) throws NoSuchElementException {
            return AbstractLocalNode.this.getClassTag(object);
        }

        @Override
        public StorageValue runInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
            return AbstractLocalNode.this.runInstanceMethodCallTransaction(request);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return AbstractLocalNode.this.executor.submit(task);
        }

        @Override
        public void submit(Runnable task) {
            AbstractLocalNode.this.executor.submit(task);
        }
    }
}

