/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.core;

import com.adelean.inject.resources.commons.AnnotationSupport;
import com.adelean.inject.resources.commons.FieldAsserts;
import com.adelean.inject.resources.commons.MethodAsserts;
import com.adelean.inject.resources.core.Parsable;
import com.adelean.inject.resources.junit.jupiter.WithGson;
import com.adelean.inject.resources.junit.jupiter.WithJacksonMapper;
import com.adelean.inject.resources.junit.jupiter.WithSnakeYaml;
import com.adelean.inject.resources.junit.jupiter.core.ResourceParser;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import com.adelean.inject.resources.junit.jupiter.json.GsonProvider;
import com.adelean.inject.resources.junit.jupiter.json.JacksonMapperProvider;
import com.adelean.inject.resources.junit.jupiter.yaml.SnakeYamlProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ReflectionUtils;

public abstract class AbstractParserProvider<A extends Annotation, R, P extends ResourceParser<? extends Parsable<?>, ?>> {
    public static final Map<Class<? extends Annotation>, Class<? extends AbstractParserProvider<?, ?, ?>>> PARSER_PROVIDERS = AbstractParserProvider.allParserProviders();
    protected final InjectionContext injectionContext;
    protected final Object testInstance;
    protected final Class<?> testClass;
    protected final Class<A> annotationType;

    public AbstractParserProvider(InjectionContext injectionContext, @Nullable Object testInstance, Class<?> testClass, Class<A> annotationType) {
        this.injectionContext = injectionContext;
        this.testInstance = testInstance;
        this.testClass = testClass;
        this.annotationType = annotationType;
    }

    public static <T extends Annotation> AbstractParserProvider<T, ?, ?> providerFor(Class<T> annotationType, @Nullable Object testInstance, Class<?> testClass, InjectionContext injectionContext) {
        Class<? extends AbstractParserProvider<?, ?, ?>> providerClass = PARSER_PROVIDERS.get(annotationType);
        try {
            return (AbstractParserProvider)ReflectionUtils.getDeclaredConstructor(providerClass).newInstance(injectionContext, testInstance, testClass);
        }
        catch (Exception instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public void provideFromMethod(Method method, Object target) {
        MethodAsserts.assertReturnsSupportedType(method, this.annotationType);
        MethodAsserts.assertNonPrivate(method, this.annotationType);
        MethodAsserts.assertNoArguments(method, this.annotationType);
        A parserAnnotation = method.getAnnotation(this.annotationType);
        try {
            Object parser = ((Method)ReflectionUtils.makeAccessible((AccessibleObject)method)).invoke(target, new Object[0]);
            String parserName = this.parserNameFromMethod(method, parserAnnotation);
            P parserBean = this.createParser(parserAnnotation, parser);
            this.injectionContext.defineBean(this.testClass, parserName, parserBean.getClass(), parserBean);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void provideFromField(Field field) {
        FieldAsserts.assertSupportedType(field, this.annotationType);
        FieldAsserts.assertNonPrivate(field, this.annotationType);
        A parserAnnotation = field.getAnnotation(this.annotationType);
        Object parser = ReflectionSupport.tryToReadFieldValue((Field)field, (Object)this.testInstance).getOrThrow(RuntimeException::new);
        String parserName = this.parserNameFromField(field, parserAnnotation);
        P parserBean = this.createParser(parserAnnotation, parser);
        this.injectionContext.defineBean(this.testClass, parserName, parserBean.getClass(), parserBean);
    }

    protected String parserNameFromMethod(Method method, A annotation) {
        String parserName = AnnotationSupport.getName(annotation);
        return parserName != null ? parserName : method.getName();
    }

    protected String parserNameFromField(Field field, A annotation) {
        String parserName = AnnotationSupport.getName(annotation);
        return parserName != null ? parserName : field.getName();
    }

    protected abstract P createParser(A var1, R var2);

    public static Map<Class<? extends Annotation>, Class<? extends AbstractParserProvider<?, ?, ?>>> allParserProviders() {
        HashMap<Class<WithSnakeYaml>, Class<SnakeYamlProvider>> providers = new HashMap<Class<WithSnakeYaml>, Class<SnakeYamlProvider>>();
        providers.put(WithJacksonMapper.class, JacksonMapperProvider.class);
        providers.put(WithGson.class, GsonProvider.class);
        providers.put(WithSnakeYaml.class, SnakeYamlProvider.class);
        return Collections.unmodifiableMap(providers);
    }
}

