/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.commons;

import com.adelean.inject.resources.annotations.Extends;
import com.adelean.inject.resources.annotations.Named;
import com.adelean.inject.resources.annotations.WithPath;
import com.adelean.inject.resources.commons.AnnotationUtils;
import com.adelean.inject.resources.commons.Errors;
import com.adelean.inject.resources.core.helpers.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections.ReflectionUtils;

public final class AnnotationSupport {
    private static final String ERR_ANNOTATION_NOT_EXTENDS = "@%s missing @Extends(%s.class)";
    private static final String ERR_ANNOTATION_MISSING_METHODS = "@%s missing methods: %s";
    private static final String[] FROM_METHOD_NAMES = new String[]{"from", "value"};
    private static final String[] NAME_METHOD_NAMES = new String[]{"name", "value"};

    private AnnotationSupport() {
    }

    public static String getFrom(Annotation resourceAnnotation) {
        AnnotationSupport.assertInheritProperly(resourceAnnotation.annotationType());
        AnnotationSupport.assertAnnotationExtends(resourceAnnotation.annotationType(), WithPath.class);
        return AnnotationSupport.getFirst(resourceAnnotation, FROM_METHOD_NAMES);
    }

    public static String getName(Annotation parserAnnotation) {
        AnnotationSupport.assertInheritProperly(parserAnnotation.annotationType());
        AnnotationSupport.assertAnnotationExtends(parserAnnotation.annotationType(), Named.class);
        return AnnotationSupport.getFirst(parserAnnotation, NAME_METHOD_NAMES);
    }

    static String getFirst(Annotation resourceAnnotation, String ... methodNames) {
        Class<? extends Annotation> annotationType = resourceAnnotation.annotationType();
        return Stream.of(methodNames).map(methodName -> ReflectionUtils.getMethods((Class)annotationType, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)methodName)}).stream().map(method -> AnnotationSupport.valueFromMethod(method, resourceAnnotation)).filter(Optional::isPresent).map(Optional::get).findAny()).filter(Optional::isPresent).map(Optional::get).findAny().orElse(null);
    }

    static Optional<String> valueFromMethod(Method method, Annotation resourceAnnotation) {
        try {
            Object value = method.invoke((Object)resourceAnnotation, new Object[0]);
            String strValue = (String)value;
            return Optional.ofNullable(StringUtils.blankToNull((String)strValue));
        }
        catch (IllegalAccessException | InvocationTargetException methodInvocationException) {
            throw new RuntimeException(methodInvocationException);
        }
    }

    static void assertAnnotationExtends(Class<? extends Annotation> annotationType, Class<? extends Annotation> annotationSuperType) {
        if (!AnnotationSupport.isAnnotationExtends(annotationType, annotationSuperType)) {
            throw new RuntimeException(Errors.internalError(String.format(ERR_ANNOTATION_NOT_EXTENDS, annotationType.getSimpleName(), annotationSuperType.getSimpleName())));
        }
    }

    static boolean isAnnotationExtends(Class<? extends Annotation> annotationType, Class<? extends Annotation> annotationSuperType) {
        List extendedAnnotationTypes = AnnotationUtils.findAnnotation(annotationType, Extends.class).map(Extends::value).map(Arrays::asList).orElseGet(Collections::emptyList);
        if (extendedAnnotationTypes.contains(annotationSuperType)) {
            return true;
        }
        return extendedAnnotationTypes.stream().anyMatch(extendedAnnotationType -> AnnotationSupport.isAnnotationExtends(extendedAnnotationType, annotationSuperType));
    }

    public static void assertInheritProperly(Class<? extends Annotation> annotationType) {
        Extends extendsAnnotation = AnnotationUtils.findAnnotation(annotationType, Extends.class).orElse(null);
        if (extendsAnnotation == null) {
            return;
        }
        Class<? extends Annotation>[] extended = extendsAnnotation.value();
        Set requiredMethods = Stream.of(extended).map(Class::getDeclaredMethods).flatMap(Stream::of).collect(Collectors.toSet());
        Set missingMethods = requiredMethods.stream().filter(requiredMethod -> !AnnotationSupport.isHasMethod(annotationType, requiredMethod)).collect(Collectors.toSet());
        if (!missingMethods.isEmpty()) {
            String missing = missingMethods.stream().map(missingMethod -> String.format("[%s %s()]", missingMethod.getReturnType().getSimpleName(), missingMethod.getName())).collect(Collectors.joining(", "));
            throw new RuntimeException(Errors.internalError(String.format(ERR_ANNOTATION_MISSING_METHODS, annotationType.getSimpleName(), missing)));
        }
    }

    static boolean isHasMethod(Class<?> clazz, Method method) {
        return !ReflectionUtils.getMethods(clazz, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)method.getName()), ReflectionUtils.withReturnType(method.getReturnType())}).isEmpty();
    }
}

