/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.json;

import com.adelean.inject.resources.commons.ClasspathSupport;
import com.adelean.inject.resources.commons.OptionalsSupport;
import com.adelean.inject.resources.junit.jupiter.core.AbstractResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import com.adelean.inject.resources.junit.jupiter.json.GsonResourceParser;
import com.adelean.inject.resources.junit.jupiter.json.JacksonResourceParser;
import com.adelean.inject.resources.junit.jupiter.json.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.platform.commons.util.StringUtils;

abstract class AbstractJsonResourcesInjector<A extends Annotation>
extends AbstractResourcesInjector<A> {
    private static final String ERR_NAMED_JACKSON_MAPPER_MISSING = "Can't find named ObjectMapper '%s' in execution context. You probably forgot @WithJacksonMapper(\"%s\").";
    private static final String ERR_NAMED_GSON_MISSING = "Can't find named Gson '%s' in execution context. You probably forgot @WithGson(\"%s\").";
    private static final String ERR_BOTH_JACKSON_AND_GSON_ON_ANNOTATION = "@GivenJsonResource cannot have both 'jacksonMapper' & 'gson'.";
    private static final String ERR_JACKSON_AND_GSON_MISSING_ON_CLASS_PATH = "Jackson & Gson are missing on classpath.";

    protected AbstractJsonResourcesInjector(InjectionContext injectionContext, @Nullable Object testInstance, Class<?> testClass, Class<A> annotationType) {
        super(injectionContext, testInstance, testClass, annotationType);
    }

    protected JsonParser findJsonParser(A resourceAnnotation) {
        boolean parsedWithJackson = this.isParsedWithJackson(resourceAnnotation);
        boolean parsedWithGson = this.isParsedWithGson(resourceAnnotation);
        if (parsedWithJackson && !parsedWithGson) {
            return this.getNamedJacksonParser(this.jacksonMapperName(resourceAnnotation));
        }
        if (!parsedWithJackson && parsedWithGson) {
            return this.getNamedGsonParser(this.gsonName(resourceAnnotation));
        }
        if (!parsedWithJackson) {
            JsonParser jsonParser = OptionalsSupport.firstPresent(this::findAnonymousJacksonParser, this::findAnonymousGsonParser).orElse(null);
            if (jsonParser != null) {
                return jsonParser;
            }
            if (ClasspathSupport.isJackson2Present()) {
                return new JacksonResourceParser(new ObjectMapper());
            }
            if (ClasspathSupport.isGsonPresent()) {
                return new GsonResourceParser(new Gson());
            }
            throw new RuntimeException(ERR_JACKSON_AND_GSON_MISSING_ON_CLASS_PATH);
        }
        throw new ExtensionConfigurationException(ERR_BOTH_JACKSON_AND_GSON_ON_ANNOTATION);
    }

    protected JacksonResourceParser getNamedJacksonParser(String jacksonMapperName) {
        if (StringUtils.isBlank((String)jacksonMapperName)) {
            throw new IllegalArgumentException("Argument 'jacksonMapperName' must not be a blank string");
        }
        return this.injectionContext.findBean(this.testClass, jacksonMapperName, JacksonResourceParser.class).orElseThrow(() -> new RuntimeException(String.format(ERR_NAMED_JACKSON_MAPPER_MISSING, jacksonMapperName, jacksonMapperName)));
    }

    protected GsonResourceParser getNamedGsonParser(String gsonName) {
        if (StringUtils.isBlank((String)gsonName)) {
            throw new IllegalArgumentException("Argument 'gsonName' must not be a blank string");
        }
        return this.injectionContext.findBean(this.testClass, gsonName, GsonResourceParser.class).orElseThrow(() -> new RuntimeException(String.format(ERR_NAMED_GSON_MISSING, gsonName, gsonName)));
    }

    protected Optional<JacksonResourceParser> findAnonymousJacksonParser() {
        return this.injectionContext.findBean(this.testClass, null, JacksonResourceParser.class);
    }

    protected Optional<GsonResourceParser> findAnonymousGsonParser() {
        return this.injectionContext.findBean(this.testClass, null, GsonResourceParser.class);
    }

    abstract boolean isParsedWithJackson(A var1);

    abstract String jacksonMapperName(A var1);

    abstract boolean isParsedWithGson(A var1);

    abstract String gsonName(A var1);
}

