/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.core;

import com.adelean.inject.resources.commons.FieldAsserts;
import com.adelean.inject.resources.junit.jupiter.GivenBinaryResource;
import com.adelean.inject.resources.junit.jupiter.GivenJsonLinesResource;
import com.adelean.inject.resources.junit.jupiter.GivenJsonResource;
import com.adelean.inject.resources.junit.jupiter.GivenPropertiesResource;
import com.adelean.inject.resources.junit.jupiter.GivenTextResource;
import com.adelean.inject.resources.junit.jupiter.GivenYamlDocumentsResource;
import com.adelean.inject.resources.junit.jupiter.GivenYamlResource;
import com.adelean.inject.resources.junit.jupiter.binary.BinaryResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import com.adelean.inject.resources.junit.jupiter.json.JsonLinesResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.json.JsonResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.properties.PropertiesResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.text.TextResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.yaml.YamlDocumentsResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.yaml.YamlResourcesInjector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.commons.util.ReflectionUtils;

public abstract class AbstractResourcesInjector<A extends Annotation> {
    public static final Map<Class<? extends Annotation>, Class<? extends AbstractResourcesInjector<? extends Annotation>>> INJECTORS = AbstractResourcesInjector.allInjectors();
    protected final InjectionContext injectionContext;
    protected final Object testInstance;
    protected final Class<?> testClass;
    protected final Class<A> annotationType;

    protected AbstractResourcesInjector(InjectionContext injectionContext, @Nullable Object testInstance, Class<?> testClass, Class<A> annotationType) {
        this.injectionContext = injectionContext;
        this.testInstance = testInstance;
        this.testClass = testClass;
        this.annotationType = annotationType;
    }

    public static <T extends Annotation> AbstractResourcesInjector<T> injectorFor(Class<T> annotationType, @Nullable Object testInstance, Class<?> testClass, InjectionContext injectionContext) {
        Class<? extends AbstractResourcesInjector<? extends Annotation>> injectorClass = INJECTORS.get(annotationType);
        try {
            return (AbstractResourcesInjector)ReflectionUtils.getDeclaredConstructor(injectorClass).newInstance(injectionContext, testInstance, testClass);
        }
        catch (Exception instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public void injectField(Field field) {
        this.assertValidField(field);
        Type valueType = field.getGenericType();
        A resourceAnnotation = field.getAnnotation(this.annotationType);
        Object valueToInject = this.valueToInject(valueType, resourceAnnotation);
        try {
            ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(this.testInstance, valueToInject);
        }
        catch (IllegalAccessException makeAccessibleException) {
            throw new RuntimeException(makeAccessibleException);
        }
    }

    protected void assertValidField(Field field) {
        FieldAsserts.assertNonPrivate(field, this.annotationType);
        FieldAsserts.assertSupportedType(field, this.annotationType);
    }

    public void assertValidParameter(Parameter parameter) {
        FieldAsserts.assertSupportedType(parameter, this.annotationType);
    }

    public abstract Object valueToInject(Type var1, A var2);

    public static Map<Class<? extends Annotation>, Class<? extends AbstractResourcesInjector<? extends Annotation>>> allInjectors() {
        HashMap<Class<GivenYamlDocumentsResource>, Class<YamlDocumentsResourcesInjector>> injectors = new HashMap<Class<GivenYamlDocumentsResource>, Class<YamlDocumentsResourcesInjector>>();
        injectors.put(GivenBinaryResource.class, BinaryResourcesInjector.class);
        injectors.put(GivenTextResource.class, TextResourcesInjector.class);
        injectors.put(GivenPropertiesResource.class, PropertiesResourcesInjector.class);
        injectors.put(GivenJsonResource.class, JsonResourcesInjector.class);
        injectors.put(GivenJsonLinesResource.class, JsonLinesResourcesInjector.class);
        injectors.put(GivenYamlResource.class, YamlResourcesInjector.class);
        injectors.put(GivenYamlDocumentsResource.class, YamlDocumentsResourcesInjector.class);
        return Collections.unmodifiableMap(injectors);
    }
}

