/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.json;

import com.adelean.inject.resources.core.ResourceAsReader;
import com.adelean.inject.resources.junit.jupiter.GivenJsonResource;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import com.adelean.inject.resources.junit.jupiter.json.AbstractJsonResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.json.JsonParser;
import com.adelean.inject.resources.junit.jupiter.json.JsonResourceResolver;
import java.io.IOException;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.commons.util.StringUtils;

public final class JsonResourcesInjector
extends AbstractJsonResourcesInjector<GivenJsonResource> {
    private final JsonResourceResolver resourceResolver;

    public JsonResourcesInjector(InjectionContext injectionContext, @Nullable Object testInstance, Class<?> testClass) {
        super(injectionContext, testInstance, testClass, GivenJsonResource.class);
        this.resourceResolver = new JsonResourceResolver(testClass);
    }

    @Override
    public Object valueToInject(Type valueType, GivenJsonResource resourceAnnotation) {
        Object o;
        block8: {
            JsonParser parser = this.findJsonParser(resourceAnnotation);
            ResourceAsReader resource = this.resourceResolver.resolve(resourceAnnotation);
            try {
                o = parser.parse(resource, valueType);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
            resource.close();
        }
        return o;
    }

    @Override
    boolean isParsedWithJackson(GivenJsonResource resourceAnnotation) {
        return StringUtils.isNotBlank((String)resourceAnnotation.jacksonMapper());
    }

    @Override
    String jacksonMapperName(GivenJsonResource resourceAnnotation) {
        return resourceAnnotation.jacksonMapper();
    }

    @Override
    boolean isParsedWithGson(GivenJsonResource resourceAnnotation) {
        return StringUtils.isNotBlank((String)resourceAnnotation.gson());
    }

    @Override
    String gsonName(GivenJsonResource resourceAnnotation) {
        return resourceAnnotation.gson();
    }
}

