/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.core;

import com.adelean.inject.resources.commons.ClassSupport;
import com.adelean.inject.resources.commons.FieldAsserts;
import com.adelean.inject.resources.junit.jupiter.TestWithResourcesExtension;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ReflectionUtils;

public abstract class AbstractResourcesInjector<A extends Annotation> {
    public static final Map<Class<? extends Annotation>, Class<? extends AbstractResourcesInjector<? extends Annotation>>> INJECTORS = AbstractResourcesInjector.allInjectors();
    protected final InjectionContext injectionContext;
    protected final Object testInstance;
    protected final Class<?> testClass;
    protected final Class<A> annotationType;

    protected AbstractResourcesInjector(InjectionContext injectionContext, @Nullable Object testInstance, Class<?> testClass, Class<A> annotationType) {
        this.injectionContext = injectionContext;
        this.testInstance = testInstance;
        this.testClass = testClass;
        this.annotationType = annotationType;
    }

    public static <T extends Annotation> AbstractResourcesInjector<T> injectorFor(Class<T> annotationType, @Nullable Object testInstance, Class<?> testClass, InjectionContext injectionContext) {
        Class<? extends AbstractResourcesInjector<? extends Annotation>> injectorClass = INJECTORS.get(annotationType);
        try {
            return (AbstractResourcesInjector)ReflectionUtils.getDeclaredConstructor(injectorClass).newInstance(injectionContext, testInstance, testClass);
        }
        catch (Exception instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public void injectField(Field field) {
        this.assertValidField(field);
        Type valueType = field.getGenericType();
        A resourceAnnotation = field.getAnnotation(this.annotationType);
        Object valueToInject = this.valueToInject(valueType, resourceAnnotation);
        try {
            ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(this.testInstance, valueToInject);
        }
        catch (IllegalAccessException makeAccessibleException) {
            throw new RuntimeException(makeAccessibleException);
        }
    }

    protected void assertValidField(Field field) {
        FieldAsserts.assertNonPrivate(field, this.annotationType);
        FieldAsserts.assertSupportedType(field, this.annotationType);
    }

    public void assertValidParameter(Parameter parameter) {
        FieldAsserts.assertSupportedType(parameter, this.annotationType);
    }

    public abstract Object valueToInject(Type var1, A var2);

    public static Map<Class<? extends Annotation>, Class<? extends AbstractResourcesInjector<? extends Annotation>>> allInjectors() {
        return ReflectionSupport.findAllClassesInPackage((String)TestWithResourcesExtension.class.getPackage().getName(), clazz -> ClassSupport.isSubclass(clazz, AbstractResourcesInjector.class), any -> true).stream().filter(ModifierSupport::isPublic).map(clazz -> clazz).collect(Collectors.toMap(injectorClass -> (Class)((ParameterizedType)injectorClass.getGenericSuperclass()).getActualTypeArguments()[0], injectorClass -> injectorClass));
    }
}

