/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.parsers;

import com.adelean.inject.resources.core.function.ThrowingFunction;
import com.adelean.inject.resources.parsers.ParseWithGson;
import com.adelean.inject.resources.parsers.ParseWithJackson;
import java.io.Reader;
import java.lang.reflect.Type;

public final class Parsers {
    private static final String ERR_WRONG_PARSER_TYPE = "Wrong parser type: %s.\nAccepted parser types:\n\t- com.fasterxml.jackson.databind.ObjectMapper\n\t- com.google.gson.Gson";

    private Parsers() {
    }

    public static <U> ThrowingFunction<Reader, U> parseFunction(Object parser, Type targetType) {
        String parserClassName = parser.getClass().getName();
        if ("com.fasterxml.jackson.databind.ObjectMapper".equals(parserClassName)) {
            return new ParseWithJackson(parser, targetType);
        }
        if ("com.google.gson.Gson".equals(parserClassName)) {
            return new ParseWithGson(parser, targetType);
        }
        throw new IllegalArgumentException(String.format(ERR_WRONG_PARSER_TYPE, parserClassName));
    }
}

