/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.json;

import com.adelean.inject.resources.commons.ClassSupport;
import com.adelean.inject.resources.commons.CollectionFactory;
import com.adelean.inject.resources.commons.FieldAsserts;
import com.adelean.inject.resources.core.ResourceAsReader;
import com.adelean.inject.resources.junit.jupiter.GivenJsonLinesResource;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import com.adelean.inject.resources.junit.jupiter.json.AbstractJsonResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.json.JsonLinesResourceResolver;
import com.adelean.inject.resources.junit.jupiter.json.JsonParser;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.commons.util.StringUtils;

public final class JsonLinesResourcesInjector
extends AbstractJsonResourcesInjector<GivenJsonLinesResource> {
    private final JsonLinesResourceResolver resourceResolver;

    public JsonLinesResourcesInjector(InjectionContext injectionContext, @Nullable Object testInstance, Class<?> testClass) {
        super(injectionContext, testInstance, testClass, GivenJsonLinesResource.class);
        this.resourceResolver = new JsonLinesResourceResolver(testClass);
    }

    @Override
    protected void assertValidField(Field field) {
        FieldAsserts.assertNonPrivate(field, this.annotationType);
        FieldAsserts.assertArrayOrCollection("field", field.getType(), this.annotationType);
    }

    @Override
    public void assertValidParameter(Parameter parameter) {
        FieldAsserts.assertArrayOrCollection("parameter", parameter.getType(), this.annotationType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object valueToInject(Type valueType, GivenJsonLinesResource resourceAnnotation) {
        JsonParser jsonParser = this.findJsonParser(resourceAnnotation);
        Type elementType = ClassSupport.elementType(valueType);
        try (ResourceAsReader resource = this.resourceResolver.resolve(resourceAnnotation);){
            Stream items = resource.asLines().parseLines(line -> jsonParser.parse((String)line, elementType));
            if (ClassSupport.isArray(valueType)) {
                A[] AArray = items.toArray(length -> (Object[])Array.newInstance((Class)elementType, length));
                return AArray;
            }
            if (!ClassSupport.isCollection(valueType)) return null;
            Collection collection = CollectionFactory.newCollection((ParameterizedType)valueType);
            items.forEach(collection::add);
            Collection collection2 = collection;
            return collection2;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    boolean isParsedWithJackson(GivenJsonLinesResource resourceAnnotation) {
        return StringUtils.isNotBlank((String)resourceAnnotation.jacksonMapper());
    }

    @Override
    String jacksonMapperName(GivenJsonLinesResource resourceAnnotation) {
        return resourceAnnotation.jacksonMapper();
    }

    @Override
    boolean isParsedWithGson(GivenJsonLinesResource resourceAnnotation) {
        return StringUtils.isNotBlank((String)resourceAnnotation.gson());
    }

    @Override
    String gsonName(GivenJsonLinesResource resourceAnnotation) {
        return resourceAnnotation.gson();
    }
}

