/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter;

import com.adelean.inject.resources.commons.MethodAsserts;
import com.adelean.inject.resources.junit.jupiter.core.AbstractParserProvider;
import com.adelean.inject.resources.junit.jupiter.core.AbstractResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.core.Annotations;
import com.adelean.inject.resources.junit.jupiter.core.TestContext;
import com.adelean.inject.resources.junit.jupiter.core.TestsAdviceProcessor;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class TestWithResourcesExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    public void beforeAll(ExtensionContext context) {
        TestContext testContext = TestContext.ofClass(context.getRequiredTestClass(), context);
        this.inject(testContext);
        if (!TestWithResourcesExtension.isNestedTestClassContext(context)) {
            TestsAdviceProcessor.findAdviceClass().map(x$0 -> ReflectionSupport.newInstance((Class)x$0, (Object[])new Object[0])).ifPresent(adviceInstance -> this.provideParsersFromAdvice(adviceInstance, context));
        }
    }

    static boolean isNestedTestClassContext(ExtensionContext context) {
        return context.getParent().flatMap(ExtensionContext::getElement).isPresent();
    }

    public void beforeEach(ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().stream().map(testInstance -> TestContext.ofInstance(testInstance, context)).forEach(this::inject);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Annotation resourceAnnotation = TestWithResourcesExtension.getResourceAnnotation(parameterContext).orElse(null);
        if (resourceAnnotation != null) {
            TestWithResourcesExtension.assertParameter(resourceAnnotation.annotationType(), parameterContext, extensionContext);
            return true;
        }
        return false;
    }

    static void assertParameter(Class<? extends Annotation> annotationType, ParameterContext parameterContext, ExtensionContext extensionContext) {
        MethodAsserts.assertNotConstructor(parameterContext.getDeclaringExecutable(), annotationType);
        MethodAsserts.assertNotStaticMethod(parameterContext.getDeclaringExecutable(), annotationType);
        Object testInstance = parameterContext.getTarget().get();
        TestContext testContext = TestContext.ofInstance(testInstance, extensionContext);
        AbstractResourcesInjector<? extends Annotation> injector = AbstractResourcesInjector.injectorFor(annotationType, testInstance, testContext.getTestClass(), testContext.getInjectionContext());
        injector.assertValidParameter(parameterContext.getParameter());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Object testInstance = parameterContext.getTarget().get();
        Annotation resourceAnnotation = TestWithResourcesExtension.getResourceAnnotation(parameterContext).get();
        TestContext testContext = TestContext.ofInstance(testInstance, extensionContext);
        AbstractResourcesInjector<? extends Annotation> injector = AbstractResourcesInjector.injectorFor(resourceAnnotation.annotationType(), testInstance, testContext.getTestClass(), testContext.getInjectionContext());
        Type parameterType = parameterContext.getParameter().getParameterizedType();
        return injector.valueToInject(parameterType, resourceAnnotation);
    }

    static Optional<? extends Annotation> getResourceAnnotation(ParameterContext parameterContext) {
        return Annotations.RESOURCE_ANNOTATIONS.stream().filter(arg_0 -> ((ParameterContext)parameterContext).isAnnotated(arg_0)).findAny().flatMap(arg_0 -> ((ParameterContext)parameterContext).findAnnotation(arg_0));
    }

    private void inject(TestContext testContext) {
        this.provideParsers(testContext);
        this.injectFields(testContext);
    }

    private void provideParsers(TestContext testContext) {
        for (Class<? extends Annotation> annotationType : Annotations.PARSER_ANNOTATIONS) {
            List providingFields = AnnotationSupport.findAnnotatedFields(testContext.getTestClass(), annotationType, testContext.memberSelector(), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
            List<Method> providingMethods = AnnotationSupport.findAnnotatedMethods(testContext.getTestClass(), annotationType, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).stream().filter(testContext.memberSelector()).collect(Collectors.toList());
            if (providingFields.isEmpty() && providingMethods.isEmpty()) continue;
            AbstractParserProvider<? extends Annotation, ?, ?> parserProvider = AbstractParserProvider.providerFor(annotationType, testContext.getTestInstance(), testContext.getTestClass(), testContext.getInjectionContext());
            providingFields.forEach(parserProvider::provideFromField);
            providingMethods.forEach(method -> parserProvider.provideFromMethod((Method)method, testContext.getTestInstance()));
        }
    }

    private void provideParsersFromAdvice(Object adviceInstance, ExtensionContext context) {
        InjectionContext injectionContext = new InjectionContext(context);
        for (Class<? extends Annotation> annotationType : Annotations.PARSER_ANNOTATIONS) {
            List providingFields = AnnotationSupport.findAnnotatedFields(adviceInstance.getClass(), annotationType, anyField -> true, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
            ArrayList providingMethods = new ArrayList(AnnotationSupport.findAnnotatedMethods(adviceInstance.getClass(), annotationType, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN));
            if (providingFields.isEmpty() && providingMethods.isEmpty()) continue;
            AbstractParserProvider<? extends Annotation, Object, Object> parserProvider = AbstractParserProvider.providerFor(annotationType, adviceInstance, Object.class, injectionContext);
            providingFields.forEach(parserProvider::provideFromField);
            providingMethods.forEach(method -> parserProvider.provideFromMethod((Method)method, adviceInstance));
        }
    }

    private void injectFields(TestContext testContext) {
        for (Class<? extends Annotation> annotationType : Annotations.RESOURCE_ANNOTATIONS) {
            List fieldsForInjection = AnnotationSupport.findAnnotatedFields(testContext.getTestClass(), annotationType, testContext.memberSelector(), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
            if (fieldsForInjection.isEmpty()) continue;
            AbstractResourcesInjector<? extends Annotation> resourcesInjector = AbstractResourcesInjector.injectorFor(annotationType, testContext.getTestInstance(), testContext.getTestClass(), testContext.getInjectionContext());
            fieldsForInjection.forEach(resourcesInjector::injectField);
        }
    }
}

