/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.vrfnative;

import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.vrfnative.VRFProveResult;
import com.horizen.vrfnative.VRFPublicKey;
import com.horizen.vrfnative.VRFSecretKey;

public class VRFKeyPair
implements AutoCloseable {
    private VRFSecretKey secretKey;
    private VRFPublicKey publicKey;

    public VRFKeyPair(VRFSecretKey secretKey, VRFPublicKey publicKey) {
        this.secretKey = secretKey;
        this.publicKey = publicKey;
    }

    public VRFKeyPair(VRFSecretKey secretKey) {
        this.secretKey = secretKey;
        this.publicKey = secretKey.getPublicKey();
    }

    private static native VRFKeyPair nativeGenerate();

    public static VRFKeyPair generate() {
        return VRFKeyPair.nativeGenerate();
    }

    private static native VRFKeyPair nativeDeriveFromSeed(byte[] var0);

    public static VRFKeyPair generate(byte[] seed) {
        return VRFKeyPair.nativeDeriveFromSeed(seed);
    }

    private native VRFProveResult nativeProve(FieldElement var1);

    public VRFProveResult prove(FieldElement message) {
        return this.nativeProve(message);
    }

    public VRFSecretKey getSecretKey() {
        return this.secretKey;
    }

    public VRFPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void close() throws Exception {
        this.publicKey.close();
        this.secretKey.close();
    }

    static {
        Library.load();
    }
}

