/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.schnorrnative;

import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.schnorrnative.SchnorrPublicKey;
import com.horizen.schnorrnative.SchnorrSignature;
import java.util.List;

public class ValidatorKeysUpdatesList
implements AutoCloseable {
    private SchnorrPublicKey[] signingKeys;
    private SchnorrPublicKey[] masterKeys;
    private SchnorrPublicKey[] updatedSigningKeys;
    private SchnorrPublicKey[] updatedMasterKeys;
    private SchnorrSignature[] updatedSigningKeysSkSignatures;
    private SchnorrSignature[] updatedSigningKeysMkSignatures;
    private SchnorrSignature[] updatedMasterKeysSkSignatures;
    private SchnorrSignature[] updatedMasterKeysMkSignatures;
    private long maxPks;

    private static native FieldElement nativeKeysRootHash(SchnorrPublicKey[] var0, SchnorrPublicKey[] var1, long var2) throws Exception;

    public ValidatorKeysUpdatesList(List<SchnorrPublicKey> signingKeysList, List<SchnorrPublicKey> masterKeysList, List<SchnorrPublicKey> updatedSigningKeysList, List<SchnorrPublicKey> updatedMasterKeysList, List<SchnorrSignature> updatedSigningKeysSkSignaturesList, List<SchnorrSignature> updatedSigningKeysMkSignaturesList, List<SchnorrSignature> updatedMasterKeysSkSignaturesList, List<SchnorrSignature> updatedMasterKeysMkSignaturesList, long maxPks) {
        this.signingKeys = signingKeysList.toArray(new SchnorrPublicKey[0]);
        this.masterKeys = masterKeysList.toArray(new SchnorrPublicKey[0]);
        this.updatedSigningKeys = updatedSigningKeysList.toArray(new SchnorrPublicKey[0]);
        this.updatedMasterKeys = updatedMasterKeysList.toArray(new SchnorrPublicKey[0]);
        this.updatedSigningKeysSkSignatures = updatedSigningKeysSkSignaturesList.toArray(new SchnorrSignature[0]);
        this.updatedSigningKeysMkSignatures = updatedSigningKeysMkSignaturesList.toArray(new SchnorrSignature[0]);
        this.updatedMasterKeysSkSignatures = updatedMasterKeysSkSignaturesList.toArray(new SchnorrSignature[0]);
        this.updatedMasterKeysMkSignatures = updatedMasterKeysMkSignaturesList.toArray(new SchnorrSignature[0]);
        this.maxPks = maxPks;
    }

    public SchnorrPublicKey[] getSigningKeys() {
        return this.signingKeys;
    }

    public SchnorrPublicKey[] getMasterKeys() {
        return this.masterKeys;
    }

    public static FieldElement getInputKeysRootHash(SchnorrPublicKey[] signingKeys, SchnorrPublicKey[] masterKeys, long maxPks) throws Exception {
        return ValidatorKeysUpdatesList.nativeKeysRootHash(signingKeys, masterKeys, maxPks);
    }

    public FieldElement getKeysRootHash() throws Exception {
        return ValidatorKeysUpdatesList.nativeKeysRootHash(this.signingKeys, this.masterKeys, this.maxPks);
    }

    public SchnorrPublicKey[] getUpdatedSigningKeys() {
        return this.updatedSigningKeys;
    }

    public SchnorrPublicKey[] getUpdatedMasterKeys() {
        return this.updatedMasterKeys;
    }

    public FieldElement getUpdatedKeysRootHash() throws Exception {
        return ValidatorKeysUpdatesList.nativeKeysRootHash(this.updatedSigningKeys, this.updatedMasterKeys, this.maxPks);
    }

    public SchnorrSignature[] getUpdatedSigningKeysSkSignatures() {
        return this.updatedSigningKeysSkSignatures;
    }

    public SchnorrSignature[] getUpdatedSigningKeysMkSignatures() {
        return this.updatedSigningKeysMkSignatures;
    }

    public SchnorrSignature[] getUpdatedMasterKeysSkSignatures() {
        return this.updatedMasterKeysSkSignatures;
    }

    public SchnorrSignature[] getUpdatedMasterKeysMkSignatures() {
        return this.updatedMasterKeysMkSignatures;
    }

    public void setUpdatedSigningKeysSkSignatures(SchnorrSignature[] updatedSigningKeysSkSignatures) {
        this.updatedSigningKeysSkSignatures = updatedSigningKeysSkSignatures;
    }

    public void setUpdatedSigningKeysMkSignatures(SchnorrSignature[] updatedSigningKeysMkSignatures) {
        this.updatedSigningKeysMkSignatures = updatedSigningKeysMkSignatures;
    }

    public void setUpdatedMasterKeysSkSignatures(SchnorrSignature[] updatedMasterKeysSkSignatures) {
        this.updatedMasterKeysSkSignatures = updatedMasterKeysSkSignatures;
    }

    public void setUpdatedMasterKeysMkSignatures(SchnorrSignature[] updatedMasterKeysMkSignatures) {
        this.updatedMasterKeysMkSignatures = updatedMasterKeysMkSignatures;
    }

    public void setSigningKeys(SchnorrPublicKey[] signingKeys) {
        this.signingKeys = signingKeys;
    }

    public void setMasterKeys(SchnorrPublicKey[] masterKeys) {
        this.masterKeys = masterKeys;
    }

    public void setUpdatedSigningKeys(SchnorrPublicKey[] updatedSigningKeys) {
        this.updatedSigningKeys = updatedSigningKeys;
    }

    public void setUpdatedMasterKeys(SchnorrPublicKey[] updatedMasterKeys) {
        this.updatedMasterKeys = updatedMasterKeys;
    }

    @Override
    public void close() throws Exception {
        for (SchnorrPublicKey schnorrPublicKey : this.signingKeys) {
            schnorrPublicKey.close();
        }
        for (SchnorrPublicKey schnorrPublicKey : this.masterKeys) {
            schnorrPublicKey.close();
        }
        for (SchnorrPublicKey schnorrPublicKey : this.updatedSigningKeys) {
            schnorrPublicKey.close();
        }
        for (SchnorrPublicKey schnorrPublicKey : this.updatedMasterKeys) {
            schnorrPublicKey.close();
        }
        for (AutoCloseable autoCloseable : this.updatedSigningKeysSkSignatures) {
            ((SchnorrSignature)autoCloseable).close();
        }
        for (AutoCloseable autoCloseable : this.updatedSigningKeysMkSignatures) {
            ((SchnorrSignature)autoCloseable).close();
        }
        for (AutoCloseable autoCloseable : this.updatedMasterKeysSkSignatures) {
            ((SchnorrSignature)autoCloseable).close();
        }
        for (AutoCloseable autoCloseable : this.updatedMasterKeysMkSignatures) {
            ((SchnorrSignature)autoCloseable).close();
        }
    }

    static {
        Library.load();
    }
}

