/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.librustsidechains;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.Library;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class FieldElement
implements AutoCloseable {
    private long fieldElementPointer;

    protected FieldElement(long fieldElementPointer) {
        this.fieldElementPointer = fieldElementPointer;
    }

    private static native FieldElement nativeCreateFromLong(long var0);

    public static FieldElement createFromLong(long value) {
        return FieldElement.nativeCreateFromLong(value);
    }

    private static native FieldElement nativeCreateRandom(long var0);

    public static FieldElement createRandom(long seed) {
        return FieldElement.nativeCreateRandom(seed);
    }

    public static FieldElement createRandom() {
        long seed = new Random().nextLong();
        return FieldElement.nativeCreateRandom(seed);
    }

    public static FieldElement createRandom(Random r) {
        long seed = r.nextLong();
        return FieldElement.nativeCreateRandom(seed);
    }

    protected native byte[] nativeSerializeFieldElement();

    public byte[] serializeFieldElement() {
        if (this.fieldElementPointer == 0L) {
            throw new IllegalStateException("Field element was freed.");
        }
        return this.nativeSerializeFieldElement();
    }

    private static native FieldElement nativeDeserializeFieldElement(byte[] var0);

    public static FieldElement deserialize(byte[] fieldElementBytes) throws IllegalArgumentException {
        if (fieldElementBytes.length > Constants.FIELD_ELEMENT_LENGTH()) {
            throw new IllegalArgumentException(String.format("Field element length exceeded: limit %d , %d found", Constants.FIELD_ELEMENT_LENGTH(), fieldElementBytes.length));
        }
        return FieldElement.nativeDeserializeFieldElement(fieldElementBytes);
    }

    public List<FieldElement> splitAt(int index) throws IndexOutOfBoundsException {
        if (index >= Constants.FIELD_ELEMENT_LENGTH() || index <= 0) {
            throw new IndexOutOfBoundsException("Invalid split index");
        }
        byte[] feBytes = this.serializeFieldElement();
        byte[] newFeBytes1 = new byte[index];
        byte[] newFeBytes2 = new byte[Constants.FIELD_ELEMENT_LENGTH() - index];
        System.arraycopy(feBytes, 0, newFeBytes1, 0, newFeBytes1.length);
        System.arraycopy(feBytes, index, newFeBytes2, 0, newFeBytes2.length);
        return Arrays.asList(FieldElement.deserialize(newFeBytes1), FieldElement.deserialize(newFeBytes2));
    }

    public static FieldElement joinAt(FieldElement fe1, int index1, FieldElement fe2, int index2, boolean checkZeroAfterIdx) throws IllegalArgumentException {
        if (index1 + index2 > Constants.FIELD_ELEMENT_LENGTH()) {
            throw new IllegalArgumentException("Invalid values for index1 + index2: the resulting array would overflow FIELD_ELEMENT_LENGTH");
        }
        byte[] newFeBytes = new byte[index1 + index2];
        byte[] fe1Bytes = fe1.serializeFieldElement();
        byte[] fe2Bytes = fe2.serializeFieldElement();
        if (checkZeroAfterIdx) {
            int i;
            for (i = index1; i < fe1Bytes.length; ++i) {
                if (fe1Bytes[i] == 0) continue;
                throw new IllegalArgumentException("Zero check failed on bytes of fe1");
            }
            for (i = index2; i < fe2Bytes.length; ++i) {
                if (fe2Bytes[i] == 0) continue;
                throw new IllegalArgumentException("Zero check failed on bytes of fe2");
            }
        }
        System.arraycopy(fe1Bytes, 0, newFeBytes, 0, index1);
        System.arraycopy(fe2Bytes, 0, newFeBytes, index1, index2);
        return FieldElement.deserialize(newFeBytes);
    }

    public static FieldElement joinAt(FieldElement fe1, int index1, FieldElement fe2, int index2) throws IllegalArgumentException {
        return FieldElement.joinAt(fe1, index1, fe2, index2, false);
    }

    protected native void nativePrintFieldElementBytes();

    public void printFieldElementBytes() {
        if (this.fieldElementPointer == 0L) {
            throw new IllegalStateException("Field element was freed.");
        }
        this.nativePrintFieldElementBytes();
    }

    private static native void nativeFreeFieldElement(long var0);

    public void freeFieldElement() {
        if (this.fieldElementPointer != 0L) {
            FieldElement.nativeFreeFieldElement(this.fieldElementPointer);
            this.fieldElementPointer = 0L;
        }
    }

    private native boolean nativeEquals(FieldElement var1);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldElement)) {
            return false;
        }
        return this.nativeEquals((FieldElement)o);
    }

    @Override
    public void close() {
        this.freeFieldElement();
    }

    static {
        Library.load();
    }
}

