/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.fwtnative;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.poseidonnative.PoseidonHashable;
import java.util.Random;

public class ForwardTransferOutput
implements PoseidonHashable {
    private long amount;
    private byte[] receiverPubKey;
    private byte[] paybackAddrDataHash;
    private byte[] txHash;
    private int outIdx;

    public ForwardTransferOutput(long amount, byte[] receiverPubKey, byte[] paybackAddrDataHash, byte[] txHash, int outIdx) {
        this.amount = amount;
        if (receiverPubKey.length != Constants.SC_PK_HASH_SIZE()) {
            throw new IllegalArgumentException(String.format("Incorrect receiverPubKey element length, %d expected, %d found", Constants.SC_PK_HASH_SIZE(), receiverPubKey.length));
        }
        this.receiverPubKey = receiverPubKey;
        if (paybackAddrDataHash.length != Constants.MC_PK_HASH_SIZE()) {
            throw new IllegalArgumentException(String.format("Incorrect paybackAddrDataHash element length, %d expected, %d found", Constants.MC_PK_HASH_SIZE(), paybackAddrDataHash.length));
        }
        this.paybackAddrDataHash = paybackAddrDataHash;
        if (txHash.length != Constants.SC_TX_HASH_SIZE()) {
            throw new IllegalArgumentException(String.format("Incorrect txHash element length, %d expected, %d found", Constants.SC_TX_HASH_SIZE(), txHash.length));
        }
        this.txHash = txHash;
        this.outIdx = outIdx;
    }

    public long getAmount() {
        return this.amount;
    }

    public byte[] getReceiverPubKey() {
        return this.receiverPubKey;
    }

    public byte[] getPaybackAddrDataHash() {
        return this.paybackAddrDataHash;
    }

    public byte[] getTxHash() {
        return this.txHash;
    }

    public int getOutIdx() {
        return this.outIdx;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setReceiverPubKey(byte[] receiverPubKey) {
        this.receiverPubKey = receiverPubKey;
    }

    public void setPaybackAddrDataHash(byte[] paybackAddrDataHash) {
        this.paybackAddrDataHash = paybackAddrDataHash;
    }

    public void setTxHash(byte[] txHash) {
        this.txHash = txHash;
    }

    public void setOutIdx(int outIdx) {
        this.outIdx = outIdx;
    }

    public static ForwardTransferOutput getRandom(Random r) {
        byte[] receiverPubKey = new byte[Constants.SC_PK_HASH_SIZE()];
        r.nextBytes(receiverPubKey);
        byte[] paybackAddrDataHash = new byte[Constants.MC_PK_HASH_SIZE()];
        r.nextBytes(paybackAddrDataHash);
        byte[] txHash = new byte[Constants.SC_TX_HASH_SIZE()];
        r.nextBytes(txHash);
        return new ForwardTransferOutput(r.nextLong(), receiverPubKey, paybackAddrDataHash, txHash, r.nextInt());
    }

    private native FieldElement nativeGetHash();

    @Override
    public FieldElement getHash() {
        return this.nativeGetHash();
    }

    public FieldElement getNullifier() {
        return this.getHash();
    }

    static {
        Library.load();
    }
}

