/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.vrfnative;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.Library;
import com.horizen.vrfnative.VRFPublicKey;

public class VRFSecretKey
implements AutoCloseable {
    private long secretKeyPointer;

    private static native int nativeGetSecretKeySize();

    private VRFSecretKey(long secretKeyPointer) {
        if (secretKeyPointer == 0L) {
            throw new IllegalArgumentException("Secret key pointer must be not null.");
        }
        this.secretKeyPointer = secretKeyPointer;
    }

    private static native VRFSecretKey nativeDeserializeSecretKey(byte[] var0);

    public static VRFSecretKey deserialize(byte[] secretKeyBytes) {
        if (secretKeyBytes.length != Constants.VRF_SK_LENGTH()) {
            throw new IllegalArgumentException(String.format("Incorrect secret key length, %d expected, %d found", Constants.VRF_SK_LENGTH(), secretKeyBytes.length));
        }
        return VRFSecretKey.nativeDeserializeSecretKey(secretKeyBytes);
    }

    private native byte[] nativeSerializeSecretKey();

    public byte[] serializeSecretKey() {
        if (this.secretKeyPointer == 0L) {
            throw new IllegalStateException("Secret key was freed.");
        }
        return this.nativeSerializeSecretKey();
    }

    private native void nativeFreeSecretKey();

    public void freeSecretKey() {
        if (this.secretKeyPointer != 0L) {
            this.nativeFreeSecretKey();
            this.secretKeyPointer = 0L;
        }
    }

    private native VRFPublicKey nativeGetPublicKey();

    public VRFPublicKey getPublicKey() {
        if (this.secretKeyPointer == 0L) {
            throw new IllegalStateException("Secret key was freed.");
        }
        return this.nativeGetPublicKey();
    }

    @Override
    public void close() throws Exception {
        this.freeSecretKey();
    }

    static {
        Library.load();
    }
}

