/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.vrfnative;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.vrfnative.VRFProof;

public class VRFPublicKey
implements AutoCloseable {
    private long publicKeyPointer;

    private static native int nativeGetPublicKeySize();

    private VRFPublicKey(long publicKeyPointer) {
        if (publicKeyPointer == 0L) {
            throw new IllegalArgumentException("Public key pointer must be not null.");
        }
        this.publicKeyPointer = publicKeyPointer;
    }

    private static native VRFPublicKey nativeDeserializePublicKey(byte[] var0, boolean var1, boolean var2);

    public static VRFPublicKey deserialize(byte[] publicKeyBytes, boolean checkPublicKey, boolean compressed) {
        if (publicKeyBytes.length != Constants.VRF_PK_LENGTH()) {
            throw new IllegalArgumentException(String.format("Incorrect public key length, %d expected, %d found", Constants.VRF_PK_LENGTH(), publicKeyBytes.length));
        }
        return VRFPublicKey.nativeDeserializePublicKey(publicKeyBytes, checkPublicKey, compressed);
    }

    public static VRFPublicKey deserialize(byte[] publicKeyBytes, boolean checkPublicKey) {
        return VRFPublicKey.deserialize(publicKeyBytes, checkPublicKey, true);
    }

    public static VRFPublicKey deserialize(byte[] publicKeyBytes) {
        return VRFPublicKey.deserialize(publicKeyBytes, true, true);
    }

    private native byte[] nativeSerializePublicKey(boolean var1);

    public byte[] serializePublicKey(boolean compressed) {
        if (this.publicKeyPointer == 0L) {
            throw new IllegalStateException("Public key was freed.");
        }
        return this.nativeSerializePublicKey(compressed);
    }

    public byte[] serializePublicKey() {
        return this.serializePublicKey(true);
    }

    private native void nativeFreePublicKey();

    public void freePublicKey() {
        if (this.publicKeyPointer != 0L) {
            this.nativeFreePublicKey();
            this.publicKeyPointer = 0L;
        }
    }

    private native boolean nativeVerifyKey();

    public boolean verifyKey() {
        if (this.publicKeyPointer == 0L) {
            throw new IllegalStateException("Public key was freed.");
        }
        return this.nativeVerifyKey();
    }

    private native FieldElement nativeProofToHash(VRFProof var1, FieldElement var2);

    public FieldElement proofToHash(VRFProof proof, FieldElement message) {
        if (this.publicKeyPointer == 0L) {
            throw new IllegalStateException("Public key was freed.");
        }
        return this.nativeProofToHash(proof, message);
    }

    @Override
    public void close() throws Exception {
        this.freePublicKey();
    }

    static {
        Library.load();
    }
}

