/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.vrfnative;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.Library;

public class VRFProof
implements AutoCloseable {
    private long proofPointer;

    private VRFProof(long proofPointer) {
        if (proofPointer == 0L) {
            throw new IllegalArgumentException("Proof pointer must be not null.");
        }
        this.proofPointer = proofPointer;
    }

    private native byte[] nativeSerializeProof(boolean var1);

    private static native VRFProof nativeDeserializeProof(byte[] var0, boolean var1, boolean var2);

    private static native void nativeFreeProof(long var0);

    public static VRFProof deserialize(byte[] proofBytes, boolean checkVRFProof, boolean compressed) {
        if (proofBytes.length != Constants.VRF_PROOF_LENGTH()) {
            throw new IllegalArgumentException(String.format("Incorrect proof length, %d expected, %d found", Constants.VRF_PROOF_LENGTH(), proofBytes.length));
        }
        return VRFProof.nativeDeserializeProof(proofBytes, checkVRFProof, compressed);
    }

    public static VRFProof deserialize(byte[] proofBytes, boolean checkVRFProof) {
        return VRFProof.deserialize(proofBytes, checkVRFProof, true);
    }

    public static VRFProof deserialize(byte[] proofBytes) {
        return VRFProof.deserialize(proofBytes, true, true);
    }

    public byte[] serializeProof(boolean compressed) {
        if (this.proofPointer == 0L) {
            throw new IllegalStateException("Proof was freed.");
        }
        return this.nativeSerializeProof(compressed);
    }

    public byte[] serializeProof() {
        return this.serializeProof(true);
    }

    private native boolean nativeIsValidVRFProof();

    public boolean isValidVRFProof() {
        if (this.proofPointer == 0L) {
            throw new IllegalArgumentException("VRF Proof was freed.");
        }
        return this.nativeIsValidVRFProof();
    }

    public void freeProof() {
        if (this.proofPointer != 0L) {
            VRFProof.nativeFreeProof(this.proofPointer);
            this.proofPointer = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.freeProof();
    }

    static {
        Library.load();
    }
}

