/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.schnorrnative;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.Library;
import com.horizen.schnorrnative.SchnorrPublicKey;

public class SchnorrSecretKey
implements AutoCloseable {
    private long secretKeyPointer;

    private SchnorrSecretKey(long secretKeyPointer) {
        if (secretKeyPointer == 0L) {
            throw new IllegalArgumentException("Secret key pointer must be not null.");
        }
        this.secretKeyPointer = secretKeyPointer;
    }

    private static native SchnorrSecretKey nativeDeserializeSecretKey(byte[] var0);

    public static SchnorrSecretKey deserialize(byte[] secretKeyBytes) {
        if (secretKeyBytes.length != Constants.SCHNORR_SK_LENGTH()) {
            throw new IllegalArgumentException(String.format("Incorrect secret key length, %d expected, %d found", Constants.SCHNORR_SK_LENGTH(), secretKeyBytes.length));
        }
        return SchnorrSecretKey.nativeDeserializeSecretKey(secretKeyBytes);
    }

    private native byte[] nativeSerializeSecretKey();

    public byte[] serializeSecretKey() {
        if (this.secretKeyPointer == 0L) {
            throw new IllegalStateException("Secret key was freed.");
        }
        return this.nativeSerializeSecretKey();
    }

    private native void nativeFreeSecretKey();

    public void freeSecretKey() {
        if (this.secretKeyPointer != 0L) {
            this.nativeFreeSecretKey();
            this.secretKeyPointer = 0L;
        }
    }

    private native SchnorrPublicKey nativeGetPublicKey();

    public SchnorrPublicKey getPublicKey() {
        if (this.secretKeyPointer == 0L) {
            throw new IllegalStateException("Secret key was freed.");
        }
        return this.nativeGetPublicKey();
    }

    @Override
    public void close() throws Exception {
        this.freeSecretKey();
    }

    static {
        Library.load();
    }
}

