/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.merkletreenative;

import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.merkletreenative.MerklePath;
import java.util.Map;
import java.util.Set;

public class InMemorySparseMerkleTree
implements AutoCloseable {
    private long merkleTreePointer;

    private InMemorySparseMerkleTree(long merkleTreePointer) {
        if (merkleTreePointer == 0L) {
            throw new IllegalArgumentException("merkleTreePointer must be not null.");
        }
        this.merkleTreePointer = merkleTreePointer;
    }

    private static native InMemorySparseMerkleTree nativeInit(int var0);

    public static InMemorySparseMerkleTree init(int height) {
        return InMemorySparseMerkleTree.nativeInit(height);
    }

    private native boolean nativeIsPositionEmpty(long var1) throws Exception;

    public boolean isPositionEmpty(long position) throws Exception {
        if (this.merkleTreePointer == 0L) {
            throw new IllegalStateException("InMemorySparseMerkleTree instance was freed.");
        }
        return this.nativeIsPositionEmpty(position);
    }

    private native void nativeAddLeaves(Map<Long, FieldElement> var1) throws Exception;

    public void addLeaves(Map<Long, FieldElement> leaves) throws Exception {
        if (this.merkleTreePointer == 0L) {
            throw new IllegalStateException("InMemorySparseMerkleTree instance was freed.");
        }
        this.nativeAddLeaves(leaves);
    }

    private native void nativeRemoveLeaves(Long[] var1) throws Exception;

    public void removeLeaves(Set<Long> positions) throws Exception {
        if (this.merkleTreePointer == 0L) {
            throw new IllegalStateException("InMemorySparseMerkleTree instance was freed.");
        }
        this.nativeRemoveLeaves(positions.toArray(new Long[0]));
    }

    private native void nativeFinalizeInPlace() throws Exception;

    public void finalizeInPlace() throws Exception {
        if (this.merkleTreePointer == 0L) {
            throw new IllegalStateException("InMemorySparseMerkleTree instance was freed.");
        }
        this.nativeFinalizeInPlace();
    }

    private native FieldElement nativeRoot() throws Exception;

    public FieldElement root() throws Exception {
        if (this.merkleTreePointer == 0L) {
            throw new IllegalStateException("InMemorySparseMerkleTree instance was freed.");
        }
        return this.nativeRoot();
    }

    private native MerklePath nativeGetMerklePath(long var1) throws Exception;

    public MerklePath getMerklePath(long leafPosition) throws Exception {
        if (this.merkleTreePointer == 0L) {
            throw new IllegalStateException("InMemorySparseMerkleTree instance was freed.");
        }
        return this.nativeGetMerklePath(leafPosition);
    }

    private native void nativeFreeInMemorySparseMerkleTree();

    public void freeInMemorySparseMerkleTree() {
        if (this.merkleTreePointer != 0L) {
            this.nativeFreeInMemorySparseMerkleTree();
            this.merkleTreePointer = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.freeInMemorySparseMerkleTree();
    }

    static {
        Library.load();
    }
}

