/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cswnative;

import com.horizen.fwtnative.ForwardTransferOutput;
import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.merkletreenative.MerklePath;
import java.util.List;

public class CswFtProverData
implements AutoCloseable {
    private final ForwardTransferOutput output;
    private final byte[] ftInputSecretKey;
    private final FieldElement mcbScTxsComStart;
    private final MerklePath merklePathToScHash;
    private final MerklePath ftTreePath;
    private final FieldElement scCreationCommitment;
    private final FieldElement scbBtrTreeRoot;
    private final FieldElement wCertTreeRoot;
    private final FieldElement[] scTxsComHashes;

    public CswFtProverData(ForwardTransferOutput output, byte[] ftInputSecretKey, FieldElement mcbScTxsComStart, MerklePath merklePathToScHash, MerklePath ftTreePath, FieldElement scCreationCommitment, FieldElement scbBtrTreeRoot, FieldElement wCertTreeRoot, List<FieldElement> scTxsComHashes) {
        this.output = output;
        if (ftInputSecretKey.length != Constants.SC_SK_SIZE()) {
            throw new IllegalArgumentException(String.format("Incorrect ftInputSecretKey element length, %d expected, %d found", Constants.SC_SK_SIZE(), ftInputSecretKey.length));
        }
        this.ftInputSecretKey = ftInputSecretKey;
        this.mcbScTxsComStart = mcbScTxsComStart;
        if (merklePathToScHash.getLength() != Constants.SC_COMM_TREE_HEIGHT()) {
            throw new IllegalArgumentException(String.format("Incorrect merklePathToScHash element length, %d expected, %d found", Constants.SC_COMM_TREE_HEIGHT(), merklePathToScHash.getLength()));
        }
        this.merklePathToScHash = merklePathToScHash;
        if (ftTreePath.getLength() != Constants.SC_COMM_TREE_FT_SUBTREE_HEIGHT()) {
            throw new IllegalArgumentException(String.format("Incorrect ftTreePath element length, %d expected, %d found", Constants.SC_COMM_TREE_FT_SUBTREE_HEIGHT(), ftTreePath.getLength()));
        }
        this.ftTreePath = ftTreePath;
        this.scCreationCommitment = scCreationCommitment;
        this.scbBtrTreeRoot = scbBtrTreeRoot;
        this.wCertTreeRoot = wCertTreeRoot;
        this.scTxsComHashes = scTxsComHashes.toArray(new FieldElement[0]);
    }

    public ForwardTransferOutput getOutput() {
        return this.output;
    }

    public byte[] getFtInputSecretKey() {
        return this.ftInputSecretKey;
    }

    public FieldElement getMcbScTxsComStart() {
        return this.mcbScTxsComStart;
    }

    public MerklePath getMerklePathToScHash() {
        return this.merklePathToScHash;
    }

    public MerklePath getFtTreePath() {
        return this.ftTreePath;
    }

    public FieldElement getScCreationTxHash() {
        return this.scCreationCommitment;
    }

    public FieldElement getScbBtrTreeRoot() {
        return this.scbBtrTreeRoot;
    }

    public FieldElement getwCertTreeRoot() {
        return this.wCertTreeRoot;
    }

    public FieldElement[] getScTxsComHashes() {
        return this.scTxsComHashes;
    }

    @Override
    public void close() throws Exception {
        this.mcbScTxsComStart.close();
        this.merklePathToScHash.close();
        this.ftTreePath.close();
        this.scCreationCommitment.close();
        this.scbBtrTreeRoot.close();
        this.wCertTreeRoot.close();
        for (FieldElement fe : this.scTxsComHashes) {
            fe.close();
        }
    }
}

