/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.commitmenttreenative;

import com.horizen.certnative.BackwardTransfer;
import com.horizen.commitmenttreenative.CustomBitvectorElementsConfig;
import com.horizen.commitmenttreenative.CustomFieldElementsConfig;
import com.horizen.commitmenttreenative.ScAbsenceProof;
import com.horizen.commitmenttreenative.ScExistenceProof;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.merkletreenative.MerklePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CommitmentTree
implements AutoCloseable {
    private long commitmentTreePointer;

    private CommitmentTree(long commitmentTreePointer) {
        this.commitmentTreePointer = commitmentTreePointer;
    }

    private static native CommitmentTree nativeInit();

    public static CommitmentTree init() {
        return CommitmentTree.nativeInit();
    }

    private native void nativeFreeCommitmentTree(long var1);

    public void freeCommitmentTree() {
        if (this.commitmentTreePointer != 0L) {
            this.nativeFreeCommitmentTree(this.commitmentTreePointer);
            this.commitmentTreePointer = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.freeCommitmentTree();
    }

    private native boolean nativeAddScCr(byte[] var1, long var2, byte[] var4, byte[] var5, int var6, int var7, byte var8, CustomFieldElementsConfig[] var9, CustomBitvectorElementsConfig[] var10, long var11, long var13, byte[] var15, byte[] var16, byte[] var17, byte[] var18);

    public boolean addScCr(byte[] scId, long amount, byte[] pubKey, byte[] txHash, int outIdx, int withdrawalEpochLength, byte mcBtrRequestDataLength, CustomFieldElementsConfig[] customFieldElementsConfigs, CustomBitvectorElementsConfig[] customBitvectorElementsConfigs, long btrFee, long ftMinAmount, byte[] customCreationData, Optional<byte[]> constantOpt, byte[] certVerificationKey, Optional<byte[]> cswVerificationKeyOpt) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeAddScCr(scId, amount, pubKey, txHash, outIdx, withdrawalEpochLength, mcBtrRequestDataLength, customFieldElementsConfigs, customBitvectorElementsConfigs, btrFee, ftMinAmount, customCreationData, constantOpt.orElse(null), certVerificationKey, cswVerificationKeyOpt.orElse(null));
    }

    private native boolean nativeAddFwt(byte[] var1, long var2, byte[] var4, byte[] var5, byte[] var6, int var7);

    public boolean addFwt(byte[] scId, long amount, byte[] pubKey, byte[] mcReturnAddress, byte[] txHash, int outIdx) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeAddFwt(scId, amount, pubKey, mcReturnAddress, txHash, outIdx);
    }

    private native boolean nativeAddBtr(byte[] var1, long var2, byte[] var4, byte[][] var5, byte[] var6, int var7);

    public boolean addBtr(byte[] scId, long scFee, byte[] mcDestinationAddress, byte[][] scRequestData, byte[] txHash, int outIdx) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeAddBtr(scId, scFee, mcDestinationAddress, scRequestData, txHash, outIdx);
    }

    private native boolean nativeAddCert(byte[] var1, int var2, long var3, BackwardTransfer[] var5, byte[][] var6, byte[] var7, long var8, long var10);

    public boolean addCert(byte[] scId, int epochNumber, long quality, BackwardTransfer[] btList, Optional<byte[][]> customFieldsOpt, byte[] endCumulativeScTxCommitmentTreeRoot, long btrFee, long ftMinAmount) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeAddCert(scId, epochNumber, quality, btList, customFieldsOpt.orElse(null), endCumulativeScTxCommitmentTreeRoot, btrFee, ftMinAmount);
    }

    public native boolean nativeAddCertLeaf(byte[] var1, byte[] var2);

    public boolean addCertLeaf(byte[] scId, byte[] leaf) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeAddCertLeaf(scId, leaf);
    }

    private native boolean nativeAddCsw(byte[] var1, long var2, byte[] var4, byte[] var5);

    public boolean addCsw(byte[] scId, long amount, byte[] nullifier, byte[] mcPubKeyHash) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeAddCsw(scId, amount, nullifier, mcPubKeyHash);
    }

    private native Optional<FieldElement[]> nativeGetFwtLeaves(byte[] var1);

    public Optional<List<FieldElement>> getFwtLeaves(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetFwtLeaves(scId).map(array -> new ArrayList<FieldElement>(Arrays.asList(array)));
    }

    private native Optional<FieldElement[]> nativeGetBtrLeaves(byte[] var1);

    public Optional<List<FieldElement>> getBtrLeaves(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetBtrLeaves(scId).map(array -> new ArrayList<FieldElement>(Arrays.asList(array)));
    }

    private native Optional<FieldElement[]> nativeGetCrtLeaves(byte[] var1);

    public Optional<List<FieldElement>> getCrtLeaves(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetCrtLeaves(scId).map(array -> new ArrayList<FieldElement>(Arrays.asList(array)));
    }

    private native Optional<FieldElement> nativeGetScCrCommitment(byte[] var1);

    public Optional<FieldElement> getScCrCommitment(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetScCrCommitment(scId);
    }

    private native Optional<FieldElement> nativeGetFwtCommitment(byte[] var1);

    public Optional<FieldElement> getFwtCommitment(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetFwtCommitment(scId);
    }

    private native Optional<FieldElement> nativeBtrCommitment(byte[] var1);

    public Optional<FieldElement> getBtrCommitment(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeBtrCommitment(scId);
    }

    private native Optional<FieldElement> nativeGetCertCommitment(byte[] var1);

    public Optional<FieldElement> getCertCommitment(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetCertCommitment(scId);
    }

    private native Optional<FieldElement> nativeGetCswCommitment(byte[] var1);

    public Optional<FieldElement> getCswCommitment(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetCswCommitment(scId);
    }

    private native Optional<FieldElement> nativeGetScCommitment(byte[] var1);

    public Optional<FieldElement> getScCommitment(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetScCommitment(scId);
    }

    private native Optional<FieldElement> nativeGetCommitment();

    public Optional<FieldElement> getCommitment() {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetCommitment();
    }

    private native Optional<ScExistenceProof> nativeGetScExistenceProof(byte[] var1);

    public Optional<ScExistenceProof> getScExistenceProof(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetScExistenceProof(scId);
    }

    private static native boolean nativeVerifyScCommitment(FieldElement var0, ScExistenceProof var1, FieldElement var2);

    public static boolean verifyScCommitment(FieldElement scCommitment, ScExistenceProof existenceProof, FieldElement commitment) {
        return CommitmentTree.nativeVerifyScCommitment(scCommitment, existenceProof, commitment);
    }

    private native Optional<ScAbsenceProof> nativeGetScAbsenceProof(byte[] var1);

    public Optional<ScAbsenceProof> getScAbsenceProof(byte[] scId) {
        if (this.commitmentTreePointer == 0L) {
            throw new IllegalStateException("CommitmentTree instance was freed.");
        }
        return this.nativeGetScAbsenceProof(scId);
    }

    private static native boolean nativeVerifyScAbsence(byte[] var0, ScAbsenceProof var1, FieldElement var2);

    public static boolean verifyScAbsence(byte[] scId, ScAbsenceProof absenceProof, FieldElement commitment) {
        return CommitmentTree.nativeVerifyScAbsence(scId, absenceProof, commitment);
    }

    private native Optional<MerklePath> nativeGetScCommitmentMerklePath(byte[] var1);

    public Optional<MerklePath> getScCommitmentMerklePath(byte[] scId) {
        return this.nativeGetScCommitmentMerklePath(scId);
    }

    private native Optional<MerklePath> nativeGetFwtMerklePath(byte[] var1, int var2);

    public Optional<MerklePath> getFwtMerklePath(byte[] scId, int leafIndex) {
        return this.nativeGetFwtMerklePath(scId, leafIndex);
    }

    private native Optional<MerklePath> nativeGetBtrMerklePath(byte[] var1, int var2);

    public Optional<MerklePath> getBtrMerklePath(byte[] scId, int leafIndex) {
        return this.nativeGetBtrMerklePath(scId, leafIndex);
    }

    private native Optional<MerklePath> nativeGetCertMerklePath(byte[] var1, int var2);

    public Optional<MerklePath> getCertMerklePath(byte[] scId, int leafIndex) {
        return this.nativeGetCertMerklePath(scId, leafIndex);
    }

    static {
        Library.load();
    }
}

