/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.vrfnative;

import com.horizen.librustsidechains.Library;
import com.horizen.vrfnative.VRFPublicKey;

public class VRFSecretKey
implements AutoCloseable {
    public static final int SECRET_KEY_LENGTH;
    private long secretKeyPointer;

    private static native int nativeGetSecretKeySize();

    private VRFSecretKey(long secretKeyPointer) {
        if (secretKeyPointer == 0L) {
            throw new IllegalArgumentException("Secret key pointer must be not null.");
        }
        this.secretKeyPointer = secretKeyPointer;
    }

    private static native VRFSecretKey nativeDeserializeSecretKey(byte[] var0);

    public static VRFSecretKey deserialize(byte[] secretKeyBytes) {
        if (secretKeyBytes.length != SECRET_KEY_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect secret key length, %d expected, %d found", SECRET_KEY_LENGTH, secretKeyBytes.length));
        }
        return VRFSecretKey.nativeDeserializeSecretKey(secretKeyBytes);
    }

    private native byte[] nativeSerializeSecretKey();

    public byte[] serializeSecretKey() {
        if (this.secretKeyPointer == 0L) {
            throw new IllegalStateException("Secret key was freed.");
        }
        return this.nativeSerializeSecretKey();
    }

    private native void nativeFreeSecretKey();

    public void freeSecretKey() {
        if (this.secretKeyPointer != 0L) {
            this.nativeFreeSecretKey();
            this.secretKeyPointer = 0L;
        }
    }

    private native VRFPublicKey nativeGetPublicKey();

    public VRFPublicKey getPublicKey() {
        if (this.secretKeyPointer == 0L) {
            throw new IllegalStateException("Secret key was freed.");
        }
        return this.nativeGetPublicKey();
    }

    @Override
    public void close() throws Exception {
        this.freeSecretKey();
    }

    static {
        Library.load();
        SECRET_KEY_LENGTH = VRFSecretKey.nativeGetSecretKeySize();
    }
}

