/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.schnorrnative;

import com.horizen.librustsidechains.Library;

public class SchnorrSignature
implements AutoCloseable {
    public static final int SIGNATURE_LENGTH;
    private long signaturePointer;

    private static native int nativeGetSignatureSize();

    private SchnorrSignature(long signaturePointer) {
        if (signaturePointer == 0L) {
            throw new IllegalArgumentException("Signature pointer must be not null.");
        }
        this.signaturePointer = signaturePointer;
    }

    public SchnorrSignature() {
        this.signaturePointer = 0L;
    }

    private native byte[] nativeSerializeSignature();

    private static native SchnorrSignature nativeDeserializeSignature(byte[] var0, boolean var1);

    private static native void nativefreeSignature(long var0);

    public static SchnorrSignature deserialize(byte[] signatureBytes, boolean checkSignature) {
        if (signatureBytes.length != SIGNATURE_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect signature length, %d expected, %d found", SIGNATURE_LENGTH, signatureBytes.length));
        }
        return SchnorrSignature.nativeDeserializeSignature(signatureBytes, checkSignature);
    }

    public static SchnorrSignature deserialize(byte[] signatureBytes) {
        return SchnorrSignature.deserialize(signatureBytes, true);
    }

    public byte[] serializeSignature() {
        return this.nativeSerializeSignature();
    }

    private native boolean nativeIsValidSignature();

    public boolean isValidSignature() {
        if (this.signaturePointer == 0L) {
            throw new IllegalArgumentException("Schnorr signature was freed.");
        }
        return this.nativeIsValidSignature();
    }

    public void freeSignature() {
        if (this.signaturePointer != 0L) {
            SchnorrSignature.nativefreeSignature(this.signaturePointer);
            this.signaturePointer = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.freeSignature();
    }

    static {
        Library.load();
        SIGNATURE_LENGTH = SchnorrSignature.nativeGetSignatureSize();
    }
}

