/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.schnorrnative;

import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.schnorrnative.SchnorrSignature;

public class SchnorrPublicKey
implements AutoCloseable {
    public static final int PUBLIC_KEY_LENGTH;
    private long publicKeyPointer;

    private static native int nativeGetPublicKeySize();

    private SchnorrPublicKey(long publicKeyPointer) {
        if (publicKeyPointer == 0L) {
            throw new IllegalArgumentException("Public key pointer must be not null.");
        }
        this.publicKeyPointer = publicKeyPointer;
    }

    private static native SchnorrPublicKey nativeDeserializePublicKey(byte[] var0, boolean var1, boolean var2);

    public static SchnorrPublicKey deserialize(byte[] publicKeyBytes, boolean checkPublicKey, boolean compressed) {
        if (publicKeyBytes.length != PUBLIC_KEY_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect public key length, %d expected, %d found", PUBLIC_KEY_LENGTH, publicKeyBytes.length));
        }
        return SchnorrPublicKey.nativeDeserializePublicKey(publicKeyBytes, checkPublicKey, compressed);
    }

    public static SchnorrPublicKey deserialize(byte[] publicKeyBytes, boolean checkPublicKey) {
        return SchnorrPublicKey.deserialize(publicKeyBytes, checkPublicKey, true);
    }

    public static SchnorrPublicKey deserialize(byte[] publicKeyBytes) {
        return SchnorrPublicKey.deserialize(publicKeyBytes, true, true);
    }

    private native byte[] nativeSerializePublicKey(boolean var1);

    public byte[] serializePublicKey(boolean compressed) {
        if (this.publicKeyPointer == 0L) {
            throw new IllegalStateException("Public key was freed.");
        }
        return this.nativeSerializePublicKey(compressed);
    }

    public byte[] serializePublicKey() {
        return this.serializePublicKey(true);
    }

    private native void nativeFreePublicKey();

    public void freePublicKey() {
        if (this.publicKeyPointer != 0L) {
            this.nativeFreePublicKey();
            this.publicKeyPointer = 0L;
        }
    }

    private native boolean nativeVerifySignature(SchnorrSignature var1, FieldElement var2);

    private native boolean nativeVerifyKey();

    public boolean verifySignature(SchnorrSignature signature, FieldElement message) {
        if (this.publicKeyPointer == 0L) {
            throw new IllegalStateException("Public key was freed.");
        }
        return this.nativeVerifySignature(signature, message);
    }

    public boolean verifyKey() {
        if (this.publicKeyPointer == 0L) {
            throw new IllegalStateException("Public key was freed.");
        }
        return this.nativeVerifyKey();
    }

    @Override
    public void close() throws Exception {
        this.freePublicKey();
    }

    static {
        Library.load();
        PUBLIC_KEY_LENGTH = SchnorrPublicKey.nativeGetPublicKeySize();
    }
}

