/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.poseidonnative;

import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;

public class PoseidonHash
implements AutoCloseable {
    public static final int HASH_LENGTH;
    private long poseidonHashPointer;

    private static native int nativeGetHashSize();

    private PoseidonHash(long poseidonHashPointer) {
        if (poseidonHashPointer == 0L) {
            throw new IllegalArgumentException("poseidonHashPointer must be not null.");
        }
        this.poseidonHashPointer = poseidonHashPointer;
    }

    private static native PoseidonHash nativeGetConstantLengthPoseidonHash(int var0, FieldElement[] var1);

    private static native PoseidonHash nativeGetVariableLengthPoseidonHash(boolean var0, FieldElement[] var1);

    public static PoseidonHash getInstance() {
        return PoseidonHash.nativeGetVariableLengthPoseidonHash(false, new FieldElement[0]);
    }

    public static PoseidonHash getInstance(FieldElement[] personalization) {
        return PoseidonHash.nativeGetVariableLengthPoseidonHash(false, personalization);
    }

    public static PoseidonHash getInstanceConstantLength(int inputSize) {
        return PoseidonHash.nativeGetConstantLengthPoseidonHash(inputSize, new FieldElement[0]);
    }

    public static PoseidonHash getInstanceConstantLength(int inputSize, FieldElement[] personalization) {
        return PoseidonHash.nativeGetConstantLengthPoseidonHash(inputSize, personalization);
    }

    public static PoseidonHash getInstanceVariableLength(boolean modRate) {
        return PoseidonHash.nativeGetVariableLengthPoseidonHash(modRate, new FieldElement[0]);
    }

    public static PoseidonHash getInstanceVariableLength(boolean modRate, FieldElement[] personalization) {
        return PoseidonHash.nativeGetVariableLengthPoseidonHash(modRate, personalization);
    }

    private native void nativeUpdate(FieldElement var1);

    public void update(FieldElement input) {
        if (this.poseidonHashPointer == 0L) {
            throw new IllegalStateException("PoseidonHash instance was freed.");
        }
        this.nativeUpdate(input);
    }

    private native FieldElement nativeFinalize();

    public FieldElement finalizeHash() {
        if (this.poseidonHashPointer == 0L) {
            throw new IllegalStateException("PoseidonHash instance was freed.");
        }
        return this.nativeFinalize();
    }

    private native FieldElement nativeReset(FieldElement[] var1);

    public FieldElement reset(FieldElement[] personalization) {
        if (this.poseidonHashPointer == 0L) {
            throw new IllegalStateException("PoseidonHash instance was freed.");
        }
        return this.nativeReset(personalization);
    }

    public FieldElement reset() {
        if (this.poseidonHashPointer == 0L) {
            throw new IllegalStateException("PoseidonHash instance was freed.");
        }
        return this.nativeReset(new FieldElement[0]);
    }

    @Deprecated
    public static FieldElement computePoseidonHash(FieldElement[] inputs) {
        PoseidonHash digest = PoseidonHash.getInstanceConstantLength(inputs.length);
        for (FieldElement fe : inputs) {
            digest.update(fe);
        }
        FieldElement hashOutput = digest.finalizeHash();
        digest.freePoseidonHash();
        return hashOutput;
    }

    private native void nativeFreePoseidonHash();

    public void freePoseidonHash() {
        if (this.poseidonHashPointer != 0L) {
            this.nativeFreePoseidonHash();
            this.poseidonHashPointer = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.freePoseidonHash();
    }

    static {
        Library.load();
        HASH_LENGTH = PoseidonHash.nativeGetHashSize();
    }
}

