/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.merkletreenative;

import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;

public class MerklePath
implements AutoCloseable {
    private long merklePathPointer;

    private MerklePath(long merklePathPointer) {
        if (merklePathPointer == 0L) {
            throw new IllegalArgumentException("merklePathPointer must be not null.");
        }
        this.merklePathPointer = merklePathPointer;
    }

    private native boolean nativeVerify(int var1, FieldElement var2, FieldElement var3);

    public boolean verify(int merkleTreeHeight, FieldElement leaf, FieldElement root) {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("MerklePath instance was freed.");
        }
        return this.nativeVerify(merkleTreeHeight, leaf, root);
    }

    private native boolean nativeVerifyWithoutLengthCheck(FieldElement var1, FieldElement var2);

    public boolean verify(FieldElement leaf, FieldElement root) {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("MerklePath instance was freed.");
        }
        return this.nativeVerifyWithoutLengthCheck(leaf, root);
    }

    private native FieldElement nativeApply(FieldElement var1);

    public FieldElement apply(FieldElement leaf) {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("MerklePath instance was freed.");
        }
        return this.nativeApply(leaf);
    }

    private native boolean nativeIsLeftmost();

    public boolean isLeftmost() {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("MerklePath instance was freed.");
        }
        return this.nativeIsLeftmost();
    }

    private native boolean nativeIsRightmost();

    public boolean isRightmost() {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("MerklePath instance was freed.");
        }
        return this.nativeIsRightmost();
    }

    private native boolean nativeAreRightLeavesEmpty();

    public boolean areRightLeavesEmpty() {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("MerklePath instance was freed.");
        }
        return this.nativeAreRightLeavesEmpty();
    }

    private native long nativeLeafIndex();

    public long leafIndex() {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("MerklePath instance was freed.");
        }
        return this.nativeLeafIndex();
    }

    private native byte[] nativeSerialize();

    public byte[] serialize() {
        if (this.merklePathPointer == 0L) {
            throw new IllegalStateException("Field element was freed.");
        }
        return this.nativeSerialize();
    }

    private static native MerklePath nativeDeserialize(byte[] var0, boolean var1);

    public static MerklePath deserialize(byte[] merklePathBytes, boolean semanticChecks) {
        return MerklePath.nativeDeserialize(merklePathBytes, semanticChecks);
    }

    public static MerklePath deserialize(byte[] merklePathBytes) {
        return MerklePath.nativeDeserialize(merklePathBytes, true);
    }

    private native void nativeFreeMerklePath(long var1);

    public void freeMerklePath() {
        if (this.merklePathPointer != 0L) {
            this.nativeFreeMerklePath(this.merklePathPointer);
            this.merklePathPointer = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.freeMerklePath();
    }

    static {
        Library.load();
    }
}

