/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.merkletreenative;

import com.horizen.librustsidechains.FieldElement;
import com.horizen.librustsidechains.Library;
import com.horizen.merkletreenative.MerklePath;

public class InMemoryOptimizedMerkleTree
implements AutoCloseable {
    private long inMemoryOptimizedMerkleTreePointer;

    private InMemoryOptimizedMerkleTree(long inMemoryOptimizedMerkleTreePointer) {
        if (inMemoryOptimizedMerkleTreePointer == 0L) {
            throw new IllegalArgumentException("inMemoryOptimizedMerkleTreePointer must be not null.");
        }
        this.inMemoryOptimizedMerkleTreePointer = inMemoryOptimizedMerkleTreePointer;
    }

    private static native InMemoryOptimizedMerkleTree nativeInit(int var0, long var1);

    public static InMemoryOptimizedMerkleTree init(int height, long processingStep) {
        return InMemoryOptimizedMerkleTree.nativeInit(height, processingStep);
    }

    private native boolean nativeAppend(FieldElement var1);

    public boolean append(FieldElement input) {
        if (this.inMemoryOptimizedMerkleTreePointer == 0L) {
            throw new IllegalStateException("InMemoryOptimizedMerkleTree instance was freed.");
        }
        return this.nativeAppend(input);
    }

    private native InMemoryOptimizedMerkleTree nativeFinalize();

    public InMemoryOptimizedMerkleTree finalizeTree() {
        if (this.inMemoryOptimizedMerkleTreePointer == 0L) {
            throw new IllegalStateException("InMemoryOptimizedMerkleTree instance was freed.");
        }
        return this.nativeFinalize();
    }

    private native boolean nativeFinalizeInPlace();

    public boolean finalizeTreeInPlace() {
        if (this.inMemoryOptimizedMerkleTreePointer == 0L) {
            throw new IllegalStateException("InMemoryOptimizedMerkleTree instance was freed.");
        }
        return this.nativeFinalizeInPlace();
    }

    private native FieldElement nativeRoot();

    public FieldElement root() {
        if (this.inMemoryOptimizedMerkleTreePointer == 0L) {
            throw new IllegalStateException("InMemoryOptimizedMerkleTree instance was freed.");
        }
        return this.nativeRoot();
    }

    private native MerklePath nativeGetMerklePath(long var1);

    public MerklePath getMerklePath(long leafIndex) {
        if (this.inMemoryOptimizedMerkleTreePointer == 0L) {
            throw new IllegalStateException("InMemoryOptimizedMerkleTree instance was freed.");
        }
        return this.nativeGetMerklePath(leafIndex);
    }

    private native void nativeReset();

    public void reset() {
        if (this.inMemoryOptimizedMerkleTreePointer == 0L) {
            throw new IllegalStateException("InMemoryOptimizedMerkleTree instance was freed.");
        }
        this.nativeReset();
    }

    private native void nativeFreeInMemoryOptimizedMerkleTree(long var1);

    public void freeInMemoryOptimizedMerkleTree() {
        if (this.inMemoryOptimizedMerkleTreePointer != 0L) {
            this.nativeFreeInMemoryOptimizedMerkleTree(this.inMemoryOptimizedMerkleTreePointer);
            this.inMemoryOptimizedMerkleTreePointer = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.freeInMemoryOptimizedMerkleTree();
    }

    static {
        Library.load();
    }
}

