/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.librustsidechains;

import com.horizen.librustsidechains.Library;
import java.util.Random;

public class FieldElement
implements AutoCloseable {
    public static final int FIELD_ELEMENT_LENGTH;
    private long fieldElementPointer;

    private static native int nativeGetFieldElementSize();

    protected FieldElement(long fieldElementPointer) {
        this.fieldElementPointer = fieldElementPointer;
    }

    private static native FieldElement nativeCreateFromLong(long var0);

    public static FieldElement createFromLong(long value) {
        return FieldElement.nativeCreateFromLong(value);
    }

    private static native FieldElement nativeCreateRandom(long var0);

    public static FieldElement createRandom(long seed) {
        return FieldElement.nativeCreateRandom(seed);
    }

    public static FieldElement createRandom() {
        long seed = new Random().nextLong();
        return FieldElement.nativeCreateRandom(seed);
    }

    protected native byte[] nativeSerializeFieldElement();

    public byte[] serializeFieldElement() {
        if (this.fieldElementPointer == 0L) {
            throw new IllegalStateException("Field element was freed.");
        }
        return this.nativeSerializeFieldElement();
    }

    private static native FieldElement nativeDeserializeFieldElement(byte[] var0);

    public static FieldElement deserialize(byte[] fieldElementBytes) {
        if (fieldElementBytes.length != FIELD_ELEMENT_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect field element length, %d expected, %d found", FIELD_ELEMENT_LENGTH, fieldElementBytes.length));
        }
        return FieldElement.nativeDeserializeFieldElement(fieldElementBytes);
    }

    protected native void nativePrintFieldElementBytes();

    public void printFieldElementBytes() {
        if (this.fieldElementPointer == 0L) {
            throw new IllegalStateException("Field element was freed.");
        }
        this.nativePrintFieldElementBytes();
    }

    private static native void nativeFreeFieldElement(long var0);

    public void freeFieldElement() {
        if (this.fieldElementPointer != 0L) {
            FieldElement.nativeFreeFieldElement(this.fieldElementPointer);
            this.fieldElementPointer = 0L;
        }
    }

    private native boolean nativeEquals(FieldElement var1);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldElement)) {
            return false;
        }
        return this.nativeEquals((FieldElement)o);
    }

    @Override
    public void close() {
        this.freeFieldElement();
    }

    static {
        Library.load();
        FIELD_ELEMENT_LENGTH = FieldElement.nativeGetFieldElementSize();
    }
}

