/*
 * Decompiled with CFR 0.152.
 */
package sparkz.util.encode;

import java.io.IOException;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.util.encode.BytesEncoder;

public final class Base16$
implements BytesEncoder {
    public static final Base16$ MODULE$ = new Base16$();
    private static final String Alphabet = "0123456789abcdefABCDEF";
    private static final char[] hexArray = "0123456789abcdef".toCharArray();
    private static final byte[] hexIndex;

    static {
        ObjectRef index = ObjectRef.create((Object)((byte[])Array$.MODULE$.fill(128, (Function0)(JFunction0.mcB.sp & Serializable)() -> (byte)255, (ClassTag)ClassTag$.MODULE$.Byte())));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.charArrayOps(MODULE$.hexArray()))), (Function1 & Serializable)x0$1 -> {
            Base16$.$anonfun$hexIndex$2(index, x0$1);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.charArrayOps("abcdef".toCharArray()), (Function1 & Serializable)c -> {
            ((byte[])index.elem)[RichChar$.MODULE$.toUpper$extension((char)Predef$.MODULE$.charWrapper((char)BoxesRunTime.unboxToChar((Object)c)))] = ((byte[])index.elem)[BoxesRunTime.unboxToChar((Object)c)];
            return BoxedUnit.UNIT;
        });
        hexIndex = (byte[])index.elem;
    }

    @Override
    public String Alphabet() {
        return Alphabet;
    }

    private char[] hexArray() {
        return hexArray;
    }

    private byte[] hexIndex() {
        return hexIndex;
    }

    @Override
    public String encode(byte[] input) {
        if (input.length == 0) {
            return "";
        }
        char[] buf = new char[input.length * 2];
        for (int j = 0; j < input.length; ++j) {
            int v = input[j] & 0xFF;
            buf[j * 2] = this.hexArray()[v >>> 4];
            buf[j * 2 + 1] = this.hexArray()[v & 0xF];
        }
        return new String(buf);
    }

    @Override
    public Try<byte[]> decode(String input) {
        boolean isError = false;
        String errorMsg = "";
        if (input.length() % 2 != 0) {
            isError = true;
            errorMsg = new StringBuilder(27).append("invalid length ").append(input.length()).append(" of Hex data").toString();
        }
        byte[] out = (byte[])Array$.MODULE$.ofDim(input.length() / 2, (ClassTag)ClassTag$.MODULE$.Byte());
        for (int j = 0; j < input.length() && !isError; j += 2) {
            char c1 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), j);
            char c2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), j + 1);
            if (c1 > '\u0000' && c1 < '\u007f' && c2 > '\u0000' && c2 < '\u007f') {
                byte b2;
                byte b1 = this.hexIndex()[c1];
                if ((byte)(b1 | (b2 = this.hexIndex()[c2])) < 0) {
                    isError = true;
                    errorMsg = "invalid characters encountered in Hex data";
                    continue;
                }
                out[j / 2] = (byte)(b1 << 4 | b2);
                continue;
            }
            isError = true;
            errorMsg = "invalid characters encountered in Hex data";
        }
        return !isError ? new Success((Object)out) : new Failure((Throwable)new IOException(errorMsg));
    }

    public static final /* synthetic */ void $anonfun$hexIndex$2(ObjectRef index$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char c = tuple2._1$mcC$sp();
        int i = tuple2._2$mcI$sp();
        ((byte[])index$1.elem)[c] = (byte)i;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Base16$() {
    }
}

