/*
 * Decompiled with CFR 0.152.
 */
package sparkz.util.serialization;

import java.io.Serializable;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.Shrink$;
import org.scalacheck.util.Buildable$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.anyvals.PosInt$;
import org.scalactic.source.Position;
import org.scalatest.compatible.Assertion;
import org.scalatest.matchers.should.Matchers;
import org.scalatest.prop.Configuration;
import org.scalatest.propspec.AnyPropSpecLike;
import org.scalatestplus.scalacheck.CheckerAsserting$;
import org.scalatestplus.scalacheck.ScalaCheckPropertyChecks;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Factory$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import sparkz.util.Generators;
import sparkz.util.TestHelpers$;
import sparkz.util.serialization.VLQReader;
import sparkz.util.serialization.VLQWriter;
import sparkz.util.serialization.Writer;

@ScalaSignature(bytes="\u0006\u0005\u0005]ba\u0002\u0007\u000e!\u0003\r\t\u0001\u0006\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006w\u00011\t\u0001\u0010\u0005\u0006\u0013\u00021\tA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u001d!\u0007A1A\u0005\n\u0015DQ!\u001c\u0001\u0005\n9DQ!\u001d\u0001\u0005\nIDq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !1\u0011Q\u0007\u0001\u0005\nQ\u0012AD\u0016'R%\u0016\fG-\u001a:Xe&$XM]*qK\u000eLg-[2bi&|gN\u0003\u0002\u000f\u001f\u0005i1/\u001a:jC2L'0\u0019;j_:T!\u0001E\t\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u000511\u000f]1sWj\u001c\u0001aE\u0003\u0001+}\u00193\u0006\u0005\u0002\u0017;5\tqC\u0003\u0002\u00193\u0005A\u0001O]8qgB,7M\u0003\u0002\u001b7\u0005I1oY1mCR,7\u000f\u001e\u0006\u00029\u0005\u0019qN]4\n\u0005y9\"aC!osB\u0013x\u000e]*qK\u000e\u0004\"\u0001I\u0011\u000e\u0003=I!AI\b\u0003\u0015\u001d+g.\u001a:bi>\u00148\u000f\u0005\u0002%S5\tQE\u0003\u0002'O\u0005Q1oY1mC\u000eDWmY6\u000b\u0005!Z\u0012!D:dC2\fG/Z:ua2,8/\u0003\u0002+K\tA2kY1mC\u000eCWmY6Qe>\u0004XM\u001d;z\u0007\",7m[:\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013AB:i_VdGM\u0003\u000213\u0005AQ.\u0019;dQ\u0016\u00148/\u0003\u00023[\tAQ*\u0019;dQ\u0016\u00148/\u0001\u0004%S:LG\u000f\n\u000b\u0002kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t!QK\\5u\u00035\u0011\u0017\u0010^3Ck\u001a\u0014V-\u00193feR\u0011Q(\u0011\t\u0003}}j\u0011!D\u0005\u0003\u00016\u0011\u0011B\u0016'R%\u0016\fG-\u001a:\t\u000b\t\u0013\u0001\u0019A\"\u0002\u000b\tLH/Z:\u0011\u0007Y\"e)\u0003\u0002Fo\t)\u0011I\u001d:bsB\u0011agR\u0005\u0003\u0011^\u0012AAQ=uK\u0006y!-\u001f;f\u0003J\u0014\u0018-_,sSR,'\u000fF\u0001L!\tqD*\u0003\u0002N\u001b\tIa\u000bT)Xe&$XM]\u0001\u000eg\u0016\f\bK]5n-\u0006dw)\u001a8\u0016\u0003A\u00032!U*V\u001b\u0005\u0011&B\u0001\u0014\u001c\u0013\t!&KA\u0002HK:\u00042A\u00160b\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002['\u00051AH]8pizJ\u0011\u0001O\u0005\u0003;^\nq\u0001]1dW\u0006<W-\u0003\u0002`A\n\u00191+Z9\u000b\u0005u;\u0004C\u0001\u001cc\u0013\t\u0019wGA\u0002B]f\fa\"\u001a=qK\u000e$X\r\u001a,bYV,7/F\u0001g!\r1fl\u001a\t\u0005m!\u001c%.\u0003\u0002jo\t1A+\u001e9mKJ\u0002\"AN6\n\u00051<$\u0001\u0002'p]\u001e\f\u0011BY=uKNduN\\4\u0015\u0005\r{\u0007\"\u00029\u0007\u0001\u0004Q\u0017!\u0001<\u0002\u0013\rDWmY6TSj,G#B:~\u007f\u0006\r\u0001C\u0001;{\u001d\t)\u0018P\u0004\u0002wq:\u0011\u0001l^\u0005\u00029%\u0011!dG\u0005\u0003;fI!a\u001f?\u0003\u0013\u0005\u001b8/\u001a:uS>t'BA/\u001a\u0011\u0015qx\u00011\u0001k\u0003\rawn\u001e\u0005\u0007\u0003\u00039\u0001\u0019\u00016\u0002\t!Lw\r\u001b\u0005\b\u0003\u000b9\u0001\u0019AA\u0004\u0003\u0011\u0019\u0018N_3\u0011\u0007Y\nI!C\u0002\u0002\f]\u00121!\u00138u\u0003I\u0011\u0017\u0010^3t5&<',Y4hK\u0012duN\\4\u0015\u0007\r\u000b\t\u0002C\u0003q\u0011\u0001\u0007!.\u0001\ndQ\u0016\u001c7nU5{KjKwMW1hO\u0016$GcB\u001b\u0002\u0018\u0005e\u00111\u0004\u0005\u0006}&\u0001\rA\u001b\u0005\u0007\u0003\u0003I\u0001\u0019\u00016\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b\u0005Y\u0001O]3uif\u0004&/\u001b8u)\u0011\t\t#!\r\u0011\t\u0005\r\u00121\u0006\b\u0005\u0003K\t9\u0003\u0005\u0002Yo%\u0019\u0011\u0011F\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\ti#a\f\u0003\rM#(/\u001b8h\u0015\r\tIc\u000e\u0005\u0007\u0003gQ\u0001\u0019A\"\u0002\u0007\u0005\u0014(/\u0001\u000eqe&tG\u000fS8mKNLeNQ=uK\u0006\u0013(/Y=Ta\u0006\u001cW\r")
public interface VLQReaderWriterSpecification
extends Generators,
ScalaCheckPropertyChecks,
Matchers {
    public void sparkz$util$serialization$VLQReaderWriterSpecification$_setter_$sparkz$util$serialization$VLQReaderWriterSpecification$$seqPrimValGen_$eq(Gen<Seq<Object>> var1);

    public void sparkz$util$serialization$VLQReaderWriterSpecification$_setter_$sparkz$util$serialization$VLQReaderWriterSpecification$$expectedValues_$eq(Seq<Tuple2<byte[], Object>> var1);

    public VLQReader byteBufReader(byte[] var1);

    public VLQWriter byteArrayWriter();

    public Gen<Seq<Object>> sparkz$util$serialization$VLQReaderWriterSpecification$$seqPrimValGen();

    public Seq<Tuple2<byte[], Object>> sparkz$util$serialization$VLQReaderWriterSpecification$$expectedValues();

    private byte[] bytesLong(long v) {
        return this.byteArrayWriter().putULong(v).toBytes();
    }

    private Assertion checkSize(long low, long high, int size) {
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.bytesLong(low).length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)size));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.bytesLong(high).length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)size));
        return (Assertion)this.forAll(Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)low), (Object)BoxesRunTime.boxToLong((long)high), Gen.Choose$.MODULE$.chooseLong()), (Seq)Nil$.MODULE$, (Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$checkSize$1(this, size, BoxesRunTime.unboxToLong((Object)v)), this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }

    private byte[] bytesZigZaggedLong(long v) {
        return this.byteArrayWriter().putLong(v).toBytes();
    }

    private void checkSizeZigZagged(long low, long high, int size) {
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.bytesZigZaggedLong(low).length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)size));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.bytesZigZaggedLong(high).length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)size));
        this.forAll(Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)low), (Object)BoxesRunTime.boxToLong((long)high), Gen.Choose$.MODULE$.chooseLong()), (Seq)Nil$.MODULE$, (Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$checkSizeZigZagged$1(this, size, BoxesRunTime.unboxToLong((Object)v)), this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
    }

    private String prettyPrint(byte[] arr) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(arr), (Function1 & Serializable)b -> VLQReaderWriterSpecification.$anonfun$prettyPrint$1(BoxesRunTime.unboxToByte((Object)b)), ClassTag$.MODULE$.apply(String.class))).mkString(", ");
    }

    private void printHolesInByteArraySpace() {
        for (int v = Short.MIN_VALUE; v <= Short.MAX_VALUE; v = (int)((short)(v + 1))) {
            byte[] bytes = package$.MODULE$.BigInt().apply(v).toByteArray();
            try {
                short deserV = this.byteBufReader(bytes).getShort();
                byte[] roundtripBytes = this.byteArrayWriter().putShort(deserV).toBytes();
                if (Predef$.MODULE$.wrapByteArray(roundtripBytes).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(bytes)) || roundtripBytes[0] == bytes[0]) continue;
                Predef$.MODULE$.println((Object)new StringBuilder(38).append("bytes from deserialized ").append(deserV).append(" = ").append(this.prettyPrint(roundtripBytes)).append(", expected ").append(this.prettyPrint(bytes)).toString());
                continue;
            }
            catch (Throwable throwable) {}
        }
    }

    public static /* synthetic */ Gen $anonfun$seqPrimValGen$1(VLQReaderWriterSpecification $this, int length) {
        return Gen$.MODULE$.listOfN(length, Gen$.MODULE$.oneOf(Arbitrary$.MODULE$.arbByte().arbitrary(), Arbitrary$.MODULE$.arbShort().arbitrary(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gen[]{Arbitrary$.MODULE$.arbInt().arbitrary(), Arbitrary$.MODULE$.arbLong().arbitrary(), $this.arrayGen(Arbitrary$.MODULE$.arbByte(), ClassTag$.MODULE$.Byte()), $this.arrayGen(Arbitrary$.MODULE$.arbBool(), ClassTag$.MODULE$.Boolean())}))).map((Function1 & Serializable)anyValSeq -> anyValSeq);
    }

    public static /* synthetic */ void $anonfun$$init$$6(VLQReaderWriterSpecification $this, Seq values) {
        VLQWriter writer = $this.byteArrayWriter();
        values.foreach((Function1 & Serializable)any -> {
            Writer writer;
            Object object = any;
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                writer = writer.put(by);
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                writer.putShort(s);
                writer = s >= 0 ? writer.putUShort((int)s) : BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                writer.putInt(n);
                writer = n >= 0 ? writer.putUInt((long)n) : BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                writer.putLong(l);
                writer = writer.putULong(l);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                writer = writer.putUShort((int)((short)byArray.length)).putBytes(byArray);
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                writer = writer.putUShort((int)((short)blArray.length)).putBits(blArray);
            } else {
                throw $this.fail(new StringBuilder(32).append("writer: unsupported value type: ").append(any.getClass()).toString(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            }
            return writer;
        });
        VLQReader reader = $this.byteBufReader(writer.toBytes());
        values.foreach((Function1 & Serializable)x0$2 -> {
            Assertion assertion;
            Object object = x0$2;
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                assertion = $this.convertToAnyShouldWrapper(BoxesRunTime.boxToByte((byte)reader.getByte()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToByte((byte)by), Equality$.MODULE$.default());
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                $this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)reader.getShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToShort((short)s), Equality$.MODULE$.default());
                assertion = s >= 0 ? $this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)((short)reader.getUShort())), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToShort((short)s), Equality$.MODULE$.default()) : BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)reader.getInt()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToInteger((int)n), Equality$.MODULE$.default());
                assertion = n >= 0 ? $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)reader.getUInt()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToInteger((int)n), Equality$.MODULE$.default()) : BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)reader.getLong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToLong((long)l), Equality$.MODULE$.default());
                assertion = $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)reader.getULong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToLong((long)l), Equality$.MODULE$.default());
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                int size = reader.getUShort();
                assertion = $this.convertToAnyShouldWrapper(reader.getBytes(size), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110), Prettifier$.MODULE$.default()).shouldEqual((Object)byArray, Equality$.MODULE$.default());
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int size = reader.getUShort();
                assertion = $this.convertToAnyShouldWrapper(reader.getBits(size), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113), Prettifier$.MODULE$.default()).shouldEqual((Object)blArray, Equality$.MODULE$.default());
            } else {
                throw $this.fail(new StringBuilder(32).append("reader: unsupported value type: ").append(object.getClass()).toString(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            }
            return assertion;
        });
    }

    public static /* synthetic */ Assertion $anonfun$checkSize$1(VLQReaderWriterSpecification $this, int size$1, long v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)$this.bytesLong(v).length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)size$1));
    }

    public static /* synthetic */ Assertion $anonfun$checkSizeZigZagged$1(VLQReaderWriterSpecification $this, int size$2, long v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)$this.bytesZigZaggedLong(v).length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)size$2));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$12(VLQReaderWriterSpecification $this, long v) {
        VLQWriter writer = $this.byteArrayWriter();
        writer.putULong(v);
        writer.putLong(v);
        VLQReader reader = $this.byteBufReader(writer.toBytes());
        $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)reader.getLong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194), Prettifier$.MODULE$.default()).should($this.not()).be((Object)BoxesRunTime.boxToLong((long)v));
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)reader.getULong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195), Prettifier$.MODULE$.default()).should($this.not()).be((Object)BoxesRunTime.boxToLong((long)v));
    }

    private void check$1(int in) {
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.byteBufReader(this.byteArrayWriter().putUInt((long)in).toBytes()).getUShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)in));
    }

    private void checkFail$1(int in) {
        this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254)).thrownBy((Function0)(JFunction0.mcI.sp & Serializable)() -> this.byteBufReader(this.byteArrayWriter().putUInt((long)in).toBytes()).getUShort());
    }

    private void check$2(long in) {
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)this.byteBufReader(this.byteArrayWriter().putULong(in).toBytes()).getUInt()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)in));
    }

    private void checkFail$2(long in) {
        this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299)).thrownBy((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.byteBufReader(this.byteArrayWriter().putULong(in).toBytes()).getUInt());
    }

    public static /* synthetic */ Assertion $anonfun$$init$$38(VLQReaderWriterSpecification $this, byte v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToByte((byte)$this.byteBufReader(((VLQWriter)$this.byteArrayWriter().put(v)).toBytes()).getByte()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToByte((byte)v));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$40(VLQReaderWriterSpecification $this, byte v) {
        int uv = v & 0xFF;
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)$this.byteBufReader(((VLQWriter)$this.byteArrayWriter().putUByte(uv)).toBytes()).getUByte()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)uv));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$42(VLQReaderWriterSpecification $this, short v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)$this.byteBufReader($this.byteArrayWriter().putShort(v).toBytes()).getShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToShort((short)v));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$44(VLQReaderWriterSpecification $this, short v) {
        int uv = v & 0xFFFF;
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)$this.byteBufReader($this.byteArrayWriter().putUShort(uv).toBytes()).getUShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)uv));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$46(VLQReaderWriterSpecification $this, int v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)$this.byteBufReader($this.byteArrayWriter().putInt(v).toBytes()).getInt()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)v));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$48(VLQReaderWriterSpecification $this, int v) {
        long uv = (long)v + (long)Integer.MIN_VALUE * -1L;
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)$this.byteBufReader($this.byteArrayWriter().putUInt(uv).toBytes()).getUInt()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)uv));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$50(VLQReaderWriterSpecification $this, long v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)$this.byteBufReader($this.byteArrayWriter().putLong(v).toBytes()).getLong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)v));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$52(VLQReaderWriterSpecification $this, long v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)$this.byteBufReader($this.byteArrayWriter().putULong(v).toBytes()).getULong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)v));
    }

    public static /* synthetic */ Assertion $anonfun$$init$$58(VLQReaderWriterSpecification $this, boolean v) {
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)$this.byteBufReader(((VLQWriter)$this.byteArrayWriter().putBoolean(v)).toBytes()).getBoolean()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)v));
    }

    public static /* synthetic */ boolean $anonfun$$init$$60(String x$1) {
        return x$1.length() < 256;
    }

    private void roundtrip$1(byte v, byte[] expected) {
        byte[] bytes = ((VLQWriter)this.byteArrayWriter().put(v)).toBytes();
        this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default());
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToByte((byte)this.byteBufReader(expected).getByte()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToByte((byte)v));
    }

    private void roundtrip$2(int v, byte[] expected) {
        byte[] bytes = ((VLQWriter)this.byteArrayWriter().putUByte(v)).toBytes();
        this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default());
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.byteBufReader(expected).getUByte()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)v));
    }

    public static /* synthetic */ String $anonfun$prettyPrint$1(byte b) {
        return String.format("0x%02X", BoxesRunTime.boxToByte((byte)b));
    }

    private void roundtrip$3(short v, byte[] expected) {
        byte[] bytes = this.byteArrayWriter().putShort(v).toBytes();
        this.withClue(new StringBuilder(36).append("for value ").append(v).append(" got bytes ").append(this.prettyPrint(bytes)).append(" (expected ").append(this.prettyPrint(expected)).append("): \n").toString(), (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default()));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)this.byteBufReader(expected).getShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToShort((short)v));
    }

    private void roundtrip$4(int v, byte[] expected) {
        byte[] bytes = this.byteArrayWriter().putUShort(v).toBytes();
        this.withClue(new StringBuilder(36).append("for value ").append(v).append(" got bytes ").append(this.prettyPrint(bytes)).append(" (expected ").append(this.prettyPrint(expected)).append("): \n").toString(), (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default()));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.byteBufReader(expected).getUShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)v));
    }

    private void roundtrip$5(int v, byte[] expected) {
        byte[] bytes = this.byteArrayWriter().putInt(v).toBytes();
        this.withClue(new StringBuilder(36).append("for value ").append(v).append(" got bytes ").append(this.prettyPrint(bytes)).append(" (expected ").append(this.prettyPrint(expected)).append("): \n").toString(), (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default()));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.byteBufReader(expected).getInt()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)v));
    }

    private void roundtrip$6(long v, byte[] expected) {
        byte[] bytes = this.byteArrayWriter().putUInt(v).toBytes();
        this.withClue(new StringBuilder(36).append("for value ").append(v).append(" got bytes ").append(this.prettyPrint(bytes)).append(" (expected ").append(this.prettyPrint(expected)).append("): \n").toString(), (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default()));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)this.byteBufReader(expected).getUInt()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)v));
    }

    private void roundtrip$7(long v, byte[] expected) {
        byte[] bytes = this.byteArrayWriter().putLong(v).toBytes();
        this.withClue(new StringBuilder(36).append("for value ").append(v).append(" got bytes ").append(this.prettyPrint(bytes)).append(" (expected ").append(this.prettyPrint(expected)).append("): \n").toString(), (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default()));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)this.byteBufReader(expected).getLong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)v));
    }

    private void roundtrip$8(long v, byte[] expected) {
        byte[] bytes = this.byteArrayWriter().putULong(v).toBytes();
        this.withClue(new StringBuilder(36).append("for value ").append(v).append(" got bytes ").append(this.prettyPrint(bytes)).append(" (expected ").append(this.prettyPrint(expected)).append("): \n").toString(), (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(bytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default()));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)this.byteBufReader(expected).getULong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)v));
    }

    public static /* synthetic */ boolean $anonfun$$init$$86(short x$2) {
        return x$2 >= 0;
    }

    public static /* synthetic */ Assertion $anonfun$$init$$87(VLQReaderWriterSpecification $this, short v) {
        byte[] expected = $this.byteArrayWriter().putUShort((int)v).toBytes();
        $this.convertToAnyShouldWrapper($this.byteArrayWriter().putUInt((long)v).toBytes(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default());
        return $this.convertToAnyShouldWrapper($this.byteArrayWriter().putULong((long)v).toBytes(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default());
    }

    public static /* synthetic */ Assertion $anonfun$$init$$89(VLQReaderWriterSpecification $this, short v) {
        byte[] expected = $this.byteArrayWriter().putShort(v).toBytes();
        $this.convertToAnyShouldWrapper($this.byteArrayWriter().putInt((int)v).toBytes(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default());
        return $this.convertToAnyShouldWrapper($this.byteArrayWriter().putLong((long)v).toBytes(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647), Prettifier$.MODULE$.default()).shouldEqual((Object)expected, Equality$.MODULE$.default());
    }

    public static void $init$(VLQReaderWriterSpecification $this) {
        $this.sparkz$util$serialization$VLQReaderWriterSpecification$_setter_$sparkz$util$serialization$VLQReaderWriterSpecification$$seqPrimValGen_$eq((Gen<Seq<Object>>)Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1000), (Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)length -> VLQReaderWriterSpecification.$anonfun$seqPrimValGen$1($this, BoxesRunTime.unboxToInt((Object)length))));
        $this.sparkz$util$serialization$VLQReaderWriterSpecification$_setter_$sparkz$util$serialization$VLQReaderWriterSpecification$$expectedValues_$eq((Seq<Tuple2<byte[], Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)BoxesRunTime.boxToLong((long)0L)), new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})), (Object)BoxesRunTime.boxToLong((long)127L)), new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{162, 116})), (Object)BoxesRunTime.boxToLong((long)14882L)), new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{190, 247, 146, 132, 11})), (Object)BoxesRunTime.boxToLong((long)2961488830L)), new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{190, 247, 146, 132, 27})), (Object)BoxesRunTime.boxToLong((long)7256456126L)), new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 230, 235, 156, 195, 201, 164, 73})), (Object)BoxesRunTime.boxToLong((long)41256202580718336L)), new Tuple2((Object)TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{155, 168, 249, 194, 187, 214, 128, 133, 166, 1})), (Object)BoxesRunTime.boxToLong((long)-6482365742730816485L))}))));
        ((AnyPropSpecLike)$this).property("predefined long values and serialized data round trip", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.sparkz$util$serialization$VLQReaderWriterSpecification$$expectedValues().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] bytes = (byte[])tuple2._1();
            long v = tuple2._2$mcJ$sp();
            VLQWriter writer = $this.byteArrayWriter();
            writer.putULong(v);
            byte[] encodedBytes = writer.toBytes();
            $this.withClue(new StringBuilder(13).append("for value ").append(v).append(": \n").toString(), (Function0 & Serializable)() -> $this.convertToAnyShouldWrapper(encodedBytes, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59), Prettifier$.MODULE$.default()).shouldEqual((Object)bytes, Equality$.MODULE$.default()));
            VLQReader r = $this.byteBufReader(encodedBytes);
            $this.withClue(new StringBuilder(13).append("for bytes ").append(bytes).append(": \n").toString(), (Function0 & Serializable)() -> $this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)r.getULong()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToLong((long)v), Equality$.MODULE$.default()));
            int value = r.remaining();
            Assertion assertion = $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)value), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0));
            return assertion;
        }), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        ((AnyPropSpecLike)$this).property("round trip serialization/deserialization of arbitrary value list", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.forAll($this.sparkz$util$serialization$VLQReaderWriterSpecification$$seqPrimValGen(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[]{$this.minSuccessful(PosInt$.MODULE$.ensuringValid(500))}), (Function1 & Serializable)values -> {
            VLQReaderWriterSpecification.$anonfun$$init$$6($this, values);
            return BoxedUnit.UNIT;
        }, $this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        ((AnyPropSpecLike)$this).property("size of serialized data", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            $this.checkSize(0L, 127L, 1);
            $this.checkSize(128L, 16383L, 2);
            $this.checkSize(16384L, 0x1FFFFFL, 3);
            $this.checkSize(0x200000L, 0xFFFFFFFL, 4);
            $this.checkSize(0x10000000L, 0x7FFFFFFFFL, 5);
            $this.checkSize(0x800000000L, 0x3FFFFFFFFFFL, 6);
            $this.checkSize(0x40000000000L, 0x1FFFFFFFFFFFFL, 7);
            $this.checkSize(0x2000000000000L, 0xFFFFFFFFFFFFFFL, 8);
            $this.checkSize(0x100000000000000L, Long.MAX_VALUE, 9);
            return $this.checkSize(Long.MIN_VALUE, -1L, 10);
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        ((AnyPropSpecLike)$this).property("size of serialized zigzag'ed data", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.checkSizeZigZagged(-64L, 63L, 1);
            $this.checkSizeZigZagged(-8192L, -65L, 2);
            $this.checkSizeZigZagged(64L, 8191L, 2);
            $this.checkSizeZigZagged(-1048576L, -8193L, 3);
            $this.checkSizeZigZagged(8192L, 1048575L, 3);
            $this.checkSizeZigZagged(-134217728L, -1048577L, 4);
            $this.checkSizeZigZagged(0x100000L, 0x7FFFFFFL, 4);
            $this.checkSizeZigZagged(-17179869184L, -134217729L, 5);
            $this.checkSizeZigZagged(0x8000000L, 0x3FFFFFFFFL, 5);
            $this.checkSizeZigZagged(-2199023255552L, -17179869185L, 6);
            $this.checkSizeZigZagged(0x400000000L, 0x1FFFFFFFFFFL, 6);
            $this.checkSizeZigZagged(-281474976710656L, -2199023255553L, 7);
            $this.checkSizeZigZagged(0x20000000000L, 0xFFFFFFFFFFFFL, 7);
            $this.checkSizeZigZagged(-36028797018963968L, -281474976710657L, 8);
            $this.checkSizeZigZagged(0x1000000000000L, 0x7FFFFFFFFFFFFFL, 8);
            $this.checkSizeZigZagged(-4611686018427387904L, -36028797018963969L, 9);
            $this.checkSizeZigZagged(0x80000000000000L, 0x3FFFFFFFFFFFFFFFL, 9);
            $this.checkSizeZigZagged(Long.MIN_VALUE, -4611686018427387905L, 10);
            $this.checkSizeZigZagged(0x4000000000000000L, Long.MAX_VALUE, 10);
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        ((AnyPropSpecLike)$this).property("fail deserialization by deliberately messing with different methods", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll(Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (Seq)Nil$.MODULE$, (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()), (Seq)Nil$.MODULE$, (Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$12($this, BoxesRunTime.unboxToLong((Object)v)), $this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        ((AnyPropSpecLike)$this).property("malformed input for deserialization", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            $this.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> $this.byteBufReader(TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128}))).getULong(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            return $this.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> $this.byteBufReader(TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 0}))).getULong(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        ((AnyPropSpecLike)$this).property("Coll[Boolean] bit encoding format", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq expectations = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Boolean())), Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new boolean[]{false}), (Object)new byte[]{0}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new boolean[]{true}), (Object)new byte[]{1}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new boolean[]{false, false, true}), (Object)new byte[]{4}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new boolean[]{true, true, false}), (Object)new byte[]{3}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new boolean[]{true, false, true}), (Object)new byte[]{5}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.booleanArrayOps((boolean[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (ClassTag)ClassTag$.MODULE$.Boolean())), (Object)BoxesRunTime.boxToBoolean((boolean)true), (ClassTag)ClassTag$.MODULE$.Boolean())), (Object)new byte[]{0, 1}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.booleanArrayOps((boolean[])Array$.MODULE$.fill(9, (Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (ClassTag)ClassTag$.MODULE$.Boolean())), (Object)BoxesRunTime.boxToBoolean((boolean)true), (ClassTag)ClassTag$.MODULE$.Boolean())), (Object)new byte[]{0, 2}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.booleanArrayOps((boolean[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (ClassTag)ClassTag$.MODULE$.Boolean())), (Object)BoxesRunTime.boxToBoolean((boolean)true), (ClassTag)ClassTag$.MODULE$.Boolean())), (Object)new byte[]{0, 4})}));
            expectations.foreach((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                boolean[] bools = (boolean[])tuple2._1();
                byte[] bytes = (byte[])tuple2._2();
                $this.convertToAnyShouldWrapper($this.byteArrayWriter().putBits(bools).toBytes(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220), Prettifier$.MODULE$.default()).shouldEqual((Object)bytes, Equality$.MODULE$.default());
                Assertion assertion = $this.convertToAnyShouldWrapper($this.byteBufReader(bytes).getBits(bools.length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221), Prettifier$.MODULE$.default()).shouldEqual((Object)bools, Equality$.MODULE$.default());
                return assertion;
            });
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        ((AnyPropSpecLike)$this).property("putUByte range check assertion", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            VLQWriter w = $this.byteArrayWriter();
            w.putUByte(0);
            w.putUByte(255);
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229)).thrownBy((Function0 & Serializable)() -> (VLQWriter)w.putUByte(-1));
            return $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230)).thrownBy((Function0 & Serializable)() -> (VLQWriter)w.putUByte(256));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        ((AnyPropSpecLike)$this).property("putUShort range check assertion", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            VLQWriter w = $this.byteArrayWriter();
            w.putUShort(0);
            w.putUShort(65535);
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237)).thrownBy((Function0 & Serializable)() -> w.putUShort(-1));
            return $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238)).thrownBy((Function0 & Serializable)() -> w.putUShort(65536));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        ((AnyPropSpecLike)$this).property("putUInt range check assertion", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            VLQWriter w = $this.byteArrayWriter();
            w.putUInt(0L);
            w.putUInt(0xFFFFFFFFL);
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245)).thrownBy((Function0 & Serializable)() -> w.putUInt(-1L));
            return $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246)).thrownBy((Function0 & Serializable)() -> w.putUInt(0x100000000L));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        ((AnyPropSpecLike)$this).property("getUShort range check assertion", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.check$1(0);
            $this.check$1(65535);
            $this.checkFail$1(-1);
            $this.checkFail$1(65536);
            $this.checkFail$1(Integer.MAX_VALUE);
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        ((AnyPropSpecLike)$this).property("getBytes size check", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            byte[] bytes = new byte[]{1, 2, 3};
            VLQReader r = $this.byteBufReader(bytes);
            $this.convertToAnyShouldWrapper(r.getBytes(3), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269), Prettifier$.MODULE$.default()).shouldBe((Object)bytes);
            VLQReader r2 = $this.byteBufReader(bytes);
            r2.position_$eq(2);
            $this.convertToAnyShouldWrapper(r2.getBytes(1), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275), Prettifier$.MODULE$.default()).shouldBe(ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bytes), 2, 3));
            VLQReader r3 = $this.byteBufReader(bytes);
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280)).thrownBy((Function0 & Serializable)() -> r3.getBytes(4));
            VLQReader r4 = $this.byteBufReader(bytes);
            r4.position_$eq(2);
            return $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288)).thrownBy((Function0 & Serializable)() -> r4.getBytes(2));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        ((AnyPropSpecLike)$this).property("getUInt range check assertion", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.check$2(0L);
            $this.check$2(0xFFFFFFFFL);
            $this.checkFail$2(-1L);
            $this.checkFail$2(0x100000000L);
            $this.checkFail$2(Long.MAX_VALUE);
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        ((AnyPropSpecLike)$this).property("Byte roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$38($this, BoxesRunTime.unboxToByte((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbByte(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ByteIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        ((AnyPropSpecLike)$this).property("unsigned Byte roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$40($this, BoxesRunTime.unboxToByte((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbByte(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ByteIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        ((AnyPropSpecLike)$this).property("Short roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$42($this, BoxesRunTime.unboxToShort((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbShort(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ShortIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        ((AnyPropSpecLike)$this).property("unsigned Short roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$44($this, BoxesRunTime.unboxToShort((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbShort(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ShortIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        ((AnyPropSpecLike)$this).property("Int roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$46($this, BoxesRunTime.unboxToInt((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbInt(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        ((AnyPropSpecLike)$this).property("unsigned Int roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$48($this, BoxesRunTime.unboxToInt((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbInt(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        ((AnyPropSpecLike)$this).property("Long roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$50($this, BoxesRunTime.unboxToLong((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbLong(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        ((AnyPropSpecLike)$this).property("ULong roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$52($this, BoxesRunTime.unboxToLong((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbLong(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        ((AnyPropSpecLike)$this).property("Boolean array roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> $this.convertToAnyShouldWrapper($this.byteBufReader($this.byteArrayWriter().putBits(v).toBytes()).getBits(((boolean[])v).length), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351), Prettifier$.MODULE$.default()).shouldBe(v), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbBool(), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Boolean())), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapBooleanArray(xs)), Shrink$.MODULE$.shrinkContainer((Function1 & Serializable)xs -> Predef$.MODULE$.wrapBooleanArray(xs), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Boolean()))), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        ((AnyPropSpecLike)$this).property("Boolean roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$58($this, BoxesRunTime.unboxToBoolean((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbBool(), Shrink$.MODULE$.shrinkAny(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        ((AnyPropSpecLike)$this).property("short string roundtrip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll(Gen$.MODULE$.alphaStr().suchThat((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VLQReaderWriterSpecification.$anonfun$$init$$60(x$1))), (Seq)Nil$.MODULE$, (Function1 & Serializable)v -> $this.convertToStringShouldWrapper($this.byteBufReader($this.byteArrayWriter().putShortString(v).toBytes()).getShortString(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360), Prettifier$.MODULE$.default()).shouldBe(v), $this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkString(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        ((AnyPropSpecLike)$this).property("byte corner cases", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.roundtrip$1((byte)-128, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-128})));
            $this.roundtrip$1((byte)0, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            $this.roundtrip$1((byte)127, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        ((AnyPropSpecLike)$this).property("unsigned byte corner cases", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$2(-1, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
            $this.roundtrip$2(0, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            $this.roundtrip$2(255, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255})));
            return $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$2(256, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        ((AnyPropSpecLike)$this).property("Short corner cases", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.roundtrip$3((short)Short.MIN_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 3})));
            $this.roundtrip$3((short)-8194, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{131, 128, 1})));
            $this.roundtrip$3((short)-8193, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 1})));
            $this.roundtrip$3((short)-8192, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 127})));
            $this.roundtrip$3((short)-8191, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{253, 127})));
            $this.roundtrip$3((short)-66, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{131, 1})));
            $this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)$this.byteBufReader(TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{131, 0}))).getShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)-2));
            $this.roundtrip$3((short)-65, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 1})));
            $this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)$this.byteBufReader(TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 0}))).getShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)-1));
            $this.roundtrip$3((short)-64, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})));
            $this.roundtrip$3((short)-63, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{125})));
            $this.roundtrip$3((short)-1, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
            $this.roundtrip$3((short)0, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            $this.roundtrip$3((short)1, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
            $this.roundtrip$3((short)62, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{124})));
            $this.roundtrip$3((short)63, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{126})));
            $this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)$this.byteBufReader(TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 0}))).getShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0));
            $this.roundtrip$3((short)64, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 1})));
            $this.convertToAnyShouldWrapper(BoxesRunTime.boxToShort((short)$this.byteBufReader(TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{130, 0}))).getShort()), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            $this.roundtrip$3((short)65, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{130, 1})));
            $this.roundtrip$3((short)8190, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{252, 127})));
            $this.roundtrip$3((short)8191, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 127})));
            $this.roundtrip$3((short)8192, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 1})));
            $this.roundtrip$3((short)8193, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{130, 128, 1})));
            $this.roundtrip$3((short)Short.MAX_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 3})));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        ((AnyPropSpecLike)$this).property("unsigned Short corner cases", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$4(-2, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$4(-1, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
            $this.roundtrip$4(0, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            $this.roundtrip$4(1, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
            $this.roundtrip$4(126, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{126})));
            $this.roundtrip$4(127, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})));
            $this.roundtrip$4(128, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 1})));
            $this.roundtrip$4(129, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 1})));
            $this.roundtrip$4(16382, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 127})));
            $this.roundtrip$4(16383, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 127})));
            $this.roundtrip$4(16384, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 1})));
            $this.roundtrip$4(16385, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 1})));
            $this.roundtrip$4(65534, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 3})));
            $this.roundtrip$4(65535, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 3})));
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$4(65536, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
            return $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$4(65537, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        ((AnyPropSpecLike)$this).property("Int corner cases", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.roundtrip$5(Integer.MIN_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 1})));
            $this.roundtrip$5(-1073741825, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 248, 255, 255, 255, 255, 1})));
            $this.roundtrip$5(-1073741824, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 7})));
            $this.roundtrip$5(-134217729, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 1})));
            $this.roundtrip$5(-134217728, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 127})));
            $this.roundtrip$5(-1048577, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 1})));
            $this.roundtrip$5(-1048576, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 127})));
            $this.roundtrip$5(-8194, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{131, 128, 1})));
            $this.roundtrip$5(-8193, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 1})));
            $this.roundtrip$5(-8192, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 127})));
            $this.roundtrip$5(-8191, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{253, 127})));
            $this.roundtrip$5(-66, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{131, 1})));
            $this.roundtrip$5(-65, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 1})));
            $this.roundtrip$5(-64, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})));
            $this.roundtrip$5(-63, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{125})));
            $this.roundtrip$5(-1, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
            $this.roundtrip$5(0, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            $this.roundtrip$5(1, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
            $this.roundtrip$5(62, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{124})));
            $this.roundtrip$5(63, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{126})));
            $this.roundtrip$5(64, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 1})));
            $this.roundtrip$5(65, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{130, 1})));
            $this.roundtrip$5(8190, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{252, 127})));
            $this.roundtrip$5(8191, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 127})));
            $this.roundtrip$5(8192, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 1})));
            $this.roundtrip$5(8193, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{130, 128, 1})));
            $this.roundtrip$5(1048575, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 127})));
            $this.roundtrip$5(0x100000, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 1})));
            $this.roundtrip$5(0x7FFFFFF, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 127})));
            $this.roundtrip$5(0x8000000, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 1})));
            $this.roundtrip$5(0x3FFFFFFF, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 7})));
            $this.roundtrip$5(0x40000000, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 248, 255, 255, 255, 255, 1})));
            $this.roundtrip$5(Integer.MAX_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 255, 255, 255, 255, 255, 1})));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        ((AnyPropSpecLike)$this).property("unsigned Int corner cases", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$6(-1L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
            $this.roundtrip$6(0L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            $this.roundtrip$6(126L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{126})));
            $this.roundtrip$6(127L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})));
            $this.roundtrip$6(128L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 1})));
            $this.roundtrip$6(129L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 1})));
            $this.roundtrip$6(16383L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 127})));
            $this.roundtrip$6(16384L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 1})));
            $this.roundtrip$6(16385L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 1})));
            $this.roundtrip$6(0x1FFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 127})));
            $this.roundtrip$6(0x200000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 1})));
            $this.roundtrip$6(0xFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 127})));
            $this.roundtrip$6(0x10000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 1})));
            $this.roundtrip$6((long)Integer.MAX_VALUE * 2L + 1L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 15})));
            return $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.roundtrip$6((long)Integer.MAX_VALUE * 2L + 2L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        ((AnyPropSpecLike)$this).property("Long corner cases", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.roundtrip$7(Long.MIN_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 1})));
            $this.roundtrip$7(-4611686018427387905L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(-4611686018427387904L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(-36028797018963969L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(-36028797018963968L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(-281474976710657L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(-281474976710656L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(-2199023255553L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(-2199023255552L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(-17179869185L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(-17179869184L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 127})));
            $this.roundtrip$7(-134217729L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 128, 1})));
            $this.roundtrip$7(-134217728L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 127})));
            $this.roundtrip$7(-1048577L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 128, 1})));
            $this.roundtrip$7(-1048576L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 127})));
            $this.roundtrip$7(-8194L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{131, 128, 1})));
            $this.roundtrip$7(-8193L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 1})));
            $this.roundtrip$7(-8192L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 127})));
            $this.roundtrip$7(-8191L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{253, 127})));
            $this.roundtrip$7(-66L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{131, 1})));
            $this.roundtrip$7(-65L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 1})));
            $this.roundtrip$7(-64L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})));
            $this.roundtrip$7(-63L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{125})));
            $this.roundtrip$7(-1L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
            $this.roundtrip$7(0L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            $this.roundtrip$7(1L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
            $this.roundtrip$7(62L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{124})));
            $this.roundtrip$7(63L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{126})));
            $this.roundtrip$7(64L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 1})));
            $this.roundtrip$7(65L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{130, 1})));
            $this.roundtrip$7(8190L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{252, 127})));
            $this.roundtrip$7(8191L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 127})));
            $this.roundtrip$7(8192L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 1})));
            $this.roundtrip$7(8193L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{130, 128, 1})));
            $this.roundtrip$7(1048575L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 127})));
            $this.roundtrip$7(0x100000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 1})));
            $this.roundtrip$7(0x7FFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 127})));
            $this.roundtrip$7(0x8000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 1})));
            $this.roundtrip$7(0x3FFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 127})));
            $this.roundtrip$7(0x400000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(0x1FFFFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(0x20000000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(0xFFFFFFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(0x1000000000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(0x7FFFFFFFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(0x80000000000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(0x3FFFFFFFFFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$7(0x4000000000000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$7(Long.MAX_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{254, 255, 255, 255, 255, 255, 255, 255, 255, 1})));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
        ((AnyPropSpecLike)$this).property("unsigned Long corner cases", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.roundtrip$8(Long.MIN_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$8(-1L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 1})));
            $this.roundtrip$8(126L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{126})));
            $this.roundtrip$8(127L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{127})));
            $this.roundtrip$8(128L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 1})));
            $this.roundtrip$8(129L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 1})));
            $this.roundtrip$8(16383L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 127})));
            $this.roundtrip$8(16384L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 1})));
            $this.roundtrip$8(16385L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{129, 128, 1})));
            $this.roundtrip$8(0x1FFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 127})));
            $this.roundtrip$8(0x200000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 1})));
            $this.roundtrip$8(0xFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 127})));
            $this.roundtrip$8(0x10000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 1})));
            $this.roundtrip$8(0x7FFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 127})));
            $this.roundtrip$8(0x800000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 1})));
            $this.roundtrip$8(0x3FFFFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 127})));
            $this.roundtrip$8(0x40000000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$8(0x1FFFFFFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$8(0x2000000000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$8(0xFFFFFFFFFFFFFFL, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 255, 127})));
            $this.roundtrip$8(0x100000000000000L, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, 128, 128, 128, 128, 128, 128, 128, 1})));
            $this.roundtrip$8(Long.MAX_VALUE, TestHelpers$.MODULE$.bytesFromInts((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255, 255, 255, 255, 255, 255, 255, 255, 127})));
        }, new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
        ((AnyPropSpecLike)$this).ignore("find holes in byte array space of VLQ", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.printHolesInByteArraySpace(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        ((AnyPropSpecLike)$this).property("putUShort, putUInt, putULong equivalence", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll(Arbitrary$.MODULE$.arbShort().arbitrary().suchThat((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VLQReaderWriterSpecification.$anonfun$$init$$86(BoxesRunTime.unboxToShort((Object)x$2)))), (Seq)Nil$.MODULE$, (Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$87($this, BoxesRunTime.unboxToShort((Object)v)), $this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ShortIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
        ((AnyPropSpecLike)$this).property("putShort, putInt, putLong equivalence", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)$this.forAll((Function1 & Serializable)v -> VLQReaderWriterSpecification.$anonfun$$init$$89($this, BoxesRunTime.unboxToShort((Object)v)), $this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbShort(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ShortIsIntegral$.MODULE$), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644)), new Position("VLQReaderWriterSpecification.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
    }
}

