/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.transaction;

import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.transaction.exception.TransactionSemanticValidityException;
import io.horizen.utxo.box.BoxUnlocker;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.CoreTransactionsIdsEnum;
import io.horizen.utxo.transaction.FeePaymentsTransactionSerializer;
import io.horizen.utxo.transaction.MempoolIncompatibleTransactionIncompatibilityChecker;
import io.horizen.utxo.transaction.TransactionIncompatibilityChecker;
import java.util.Collections;
import java.util.List;
import scala.Array;
import sparkz.core.serialization.SparkzSerializer;

public class FeePaymentsTransaction
extends BoxTransaction<PublicKey25519Proposition, ZenBox> {
    public static final byte FEE_PAYMENTS_TRANSACTION_VERSION = 1;
    private final List<ZenBox> feePayments;
    private final byte version;

    public FeePaymentsTransaction(List<ZenBox> feePayments, byte version) {
        this.feePayments = feePayments;
        this.version = version;
    }

    @Override
    public void semanticValidity() throws TransactionSemanticValidityException {
        if (this.version != 1) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: unsupported version number.", this.id()));
        }
        if (this.feePayments.isEmpty()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no output data present.", this.id()));
        }
    }

    @Override
    public byte[] customDataMessageToSign() {
        return Array.emptyByteArray();
    }

    @Override
    public byte[] customFieldsData() {
        return Array.emptyByteArray();
    }

    @Override
    public List<BoxUnlocker<PublicKey25519Proposition>> unlockers() {
        return Collections.emptyList();
    }

    @Override
    public TransactionIncompatibilityChecker incompatibilityChecker() {
        return MempoolIncompatibleTransactionIncompatibilityChecker.getChecker();
    }

    @Override
    public List<ZenBox> newBoxes() {
        return Collections.unmodifiableList(this.feePayments);
    }

    @Override
    public long fee() {
        return 0L;
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.FeePaymentsTransactionId.id();
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }

    public SparkzSerializer serializer() {
        return FeePaymentsTransactionSerializer.getSerializer();
    }
}

