/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.transaction;

import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utxo.box.BoxUnlocker;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.TransactionIncompatibilityChecker;
import java.util.List;

public class DefaultTransactionIncompatibilityChecker
implements TransactionIncompatibilityChecker {
    @Override
    public <T extends BoxTransaction> boolean isTransactionCompatible(T newTx, List<T> currentTxs) {
        if (newTx == null || currentTxs == null) {
            throw new IllegalArgumentException("Parameters can't be null.");
        }
        for (BoxUnlocker unlocker : newTx.unlockers()) {
            ByteArrayWrapper closedBoxId = new ByteArrayWrapper(unlocker.closedBoxId());
            for (BoxTransaction tx : currentTxs) {
                if (!tx.boxIdsToOpen().contains(closedBoxId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isMemoryPoolCompatible() {
        return true;
    }
}

