/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.storage.StorageIterator;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.companion.SidechainBoxesCompanion;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import io.horizen.utxo.wallet.WalletBox;
import io.horizen.utxo.wallet.WalletBoxSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001\u0002\u000f\u001e\u0001\u0019B\u0001B\b\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")\u0001\n\u0001C\u0001\u0013\"9a\n\u0001b\u0001\n\u0013y\u0005B\u00023\u0001A\u0003%\u0001\u000bC\u0004f\u0001\t\u0007I\u0011\u00024\t\rU\u0004\u0001\u0015!\u0003h\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0012\u0011%\t)\u0005\u0001b\u0001\n\u0013\t9\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA%\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011q\u000f\u0001\u0005\n\u0005M\u0003bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003s\u0002A\u0011AAJ\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!a.\u0001\t\u0003\tI\fC\u0004\u0002d\u0002!\t!!:\t\u000f\t\u0005\u0001\u0001\"\u0001\u0003\u0004!9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqAa\u000e\u0001\t\u0003\u0011IDA\rTS\u0012,7\r[1j]^\u000bG\u000e\\3u\u0005>D8\u000b^8sC\u001e,'B\u0001\u0010 \u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001I\u0011\u0002\tU$\bp\u001c\u0006\u0003E\r\nq\u0001[8sSj,gNC\u0001%\u0003\tIwn\u0001\u0001\u0014\u000b\u00019S&\r\u001c\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tqs&D\u0001\"\u0013\t\u0001\u0014E\u0001\bTS\u0012,7\r[1j]RK\b/Z:\u0011\u0005I\"T\"A\u001a\u000b\u0005y\t\u0013BA\u001b4\u0005Q\u0019\u0016\u000eZ3dQ\u0006Lgn\u0015;pe\u0006<W-\u00138g_B\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0005kRLGNC\u0001<\u0003\u0019\u0019\b/\u0019:lu&\u0011Q\b\u000f\u0002\u000e'B\f'o\u001b>M_\u001e<\u0017N\\4\u0011\u0005Iz\u0014B\u0001!4\u0005\u001d\u0019Fo\u001c:bO\u0016\fqc]5eK\u000eD\u0017-\u001b8C_b,7oQ8na\u0006t\u0017n\u001c8\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015{\u0012!C2p[B\fg.[8o\u0013\t9EIA\fTS\u0012,7\r[1j]\n{\u00070Z:D_6\u0004\u0018M\\5p]\u00061A(\u001b8jiz\"2A\u0013'N!\tY\u0005!D\u0001\u001e\u0011\u0015q2\u00011\u0001?\u0011\u0015\t5\u00011\u0001C\u00031yv/\u00197mKR\u0014u\u000e_3t+\u0005\u0001\u0006\u0003B)W1zk\u0011A\u0015\u0006\u0003'R\u000bq!\\;uC\ndWM\u0003\u0002VS\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0013&!\u0004'j].,G\rS1tQ6\u000b\u0007\u000f\u0005\u0002Z96\t!L\u0003\u0002\\C\u0005)Q\u000f^5mg&\u0011QL\u0017\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJ\u0004\"a\u00182\u000e\u0003\u0001T!!Y\u0010\u0002\r]\fG\u000e\\3u\u0013\t\u0019\u0007MA\u0005XC2dW\r\u001e\"pq\u0006iql^1mY\u0016$(i\u001c=fg\u0002\n!cX<bY2,GOQ8yKN\u0014\u0015\u0010V=qKV\tq\rE\u0003R-\"\fI\u0002\r\u0002jgB\u0019!n\\9\u000e\u0003-T!\u0001\\7\u0002\t1\fgn\u001a\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u00018NA\u0003DY\u0006\u001c8\u000f\u0005\u0002sg2\u0001A!\u0003;\b\u0003\u0003\u0005\tQ!\u0001w\u0005\ryF%M\u0001\u0014?^\fG\u000e\\3u\u0005>DXm\u001d\"z)f\u0004X\rI\t\u0003oj\u0004\"\u0001\u000b=\n\u0005eL#a\u0002(pi\"Lgn\u001a\u0019\u0004w\u0006\u0015\u0001\u0003\u0002?\u0000\u0003\u0007i\u0011! \u0006\u0003}~\t1AY8y\u0013\r\t\t! \u0002\u0004\u0005>D\bc\u0001:\u0002\u0006\u0011a\u0011qAA\u0005\u0003\u0003\u0005\tQ!\u0001\u0002\f\t\u0019q\f\n\u001a\u0005\u0013Q<\u0011\u0011aA\u0001\u0006\u00031\u0018cA<\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014\u0005\n1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&!\u0011qCA\t\u0005-\u0001&o\u001c9pg&$\u0018n\u001c8\u0011\u000bE\u000bY\u0002\u00170\n\u0007\u0005u!KA\u0002NCB\fAcX<bY2,GOQ8yKN\u0014\u0015\r\\1oG\u0016\u001cXCAA\u0012!\u0019\tf+!\n\u0002@A\"\u0011qEA\u0016!\u0011Qw.!\u000b\u0011\u0007I\fY\u0003B\u0006\u0002.%\t\t\u0011!A\u0003\u0002\u0005E\"aA0%g\u0005)rl^1mY\u0016$(i\u001c=fg\n\u000bG.\u00198dKN\u0004\u0013cA<\u00024A\"\u0011QGA\u001d!\u0011ax0a\u000e\u0011\u0007I\fI\u0004\u0002\u0007\u0002<\u0005u\u0012\u0011!A\u0001\u0006\u0003\tYAA\u0002`IQ\"1\"!\f\n\u0003\u0003\r\tQ!\u0001\u00022A\u0019\u0001&!\u0011\n\u0007\u0005\r\u0013F\u0001\u0003M_:<\u0017\u0001F0xC2dW\r\u001e\"pqN+'/[1mSj,'/\u0006\u0002\u0002JA\u0019q,a\u0013\n\u0007\u00055\u0003MA\nXC2dW\r\u001e\"pqN+'/[1mSj,'/A\u000b`o\u0006dG.\u001a;C_b\u001cVM]5bY&TXM\u001d\u0011\u0002-\r\fGnY;mCR,'i\u001c=fg\n\u000bG.\u00198dKN$\"!!\u0016\u0011\u0007!\n9&C\u0002\u0002Z%\u0012A!\u00168ji\u0006\u0011R\u000f\u001d3bi\u0016\u0014u\u000e_3t\u0005\u0006d\u0017M\\2f)\u0019\t)&a\u0018\u0002d!1\u0011\u0011M\u0007A\u0002y\u000b\u0001BY8y)>\fE\r\u001a\u0005\u0007\u0003Kj\u0001\u0019\u00010\u0002\u0017\t|\u0007\u0010V8SK6|g/Z\u0001\u0013C\u0012$w+\u00197mKR\u0014u\u000e\u001f\"z)f\u0004X\r\u0006\u0003\u0002V\u0005-\u0004BBA7\u001d\u0001\u0007a,A\u0005xC2dW\r\u001e\"pq\u0006)\"/Z7pm\u0016<\u0016\r\u001c7fi\n{\u0007PQ=UsB,G\u0003BA+\u0003gBa!!\u001e\u0010\u0001\u0004A\u0016!\u00042pq&#Gk\u001c*f[>4X-A\bm_\u0006$w+\u00197mKR\u0014u\u000e_3t\u0003\r9W\r\u001e\u000b\u0005\u0003{\n\u0019\t\u0005\u0003)\u0003\u007fr\u0016bAAAS\t1q\n\u001d;j_:Dq!!\"\u0012\u0001\u0004\t9)A\u0003c_bLE\rE\u0003)\u0003\u0013\u000bi)C\u0002\u0002\f&\u0012Q!\u0011:sCf\u00042\u0001KAH\u0013\r\t\t*\u000b\u0002\u0005\u0005f$X\r\u0006\u0003\u0002\u0016\u00065\u0006#BAL\u0003Osf\u0002BAM\u0003GsA!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0004\u0003?+\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\r\t)+K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI+a+\u0003\t1K7\u000f\u001e\u0006\u0004\u0003KK\u0003bBAX%\u0001\u0007\u0011\u0011W\u0001\u0007E>D\u0018\nZ:\u0011\r\u0005]\u0015qUAD\u0003\u00199W\r^!mYV\u0011\u0011QS\u0001\nO\u0016$()\u001f+za\u0016$B!!&\u0002<\"9\u0011Q\u0018\u000bA\u0002\u0005}\u0016a\u00022pqRK\b/\u001a\u0019\u0005\u0003\u0003\f\t\u000e\u0005\u0004\u0002D\u0006-\u0017q\u001a\b\u0005\u0003\u000b\f9\rE\u0002\u0002\u001c&J1!!3*\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001/!4\u000b\u0007\u0005%\u0017\u0006E\u0002s\u0003#$A\"a5\u0002<\u0006\u0005\t\u0011!B\u0001\u0003+\u00141a\u0018\u00136#\r9\u0018q\u001b\u0019\u0005\u00033\fi\u000e\u0005\u0003}\u007f\u0006m\u0007c\u0001:\u0002^\u0012a\u0011q\\Aq\u0003\u0003\u0005\tQ!\u0001\u0002\f\t\u0019q\f\n\u001c\u0005\u0019\u0005M\u00171XA\u0001\u0004\u0003\u0015\t!!6\u0002\u001f\u001d,GOQ8yKN\u0014\u0015\r\\1oG\u0016$B!a\u0010\u0002h\"9\u0011QX\u000bA\u0002\u0005%\b\u0007BAv\u0003_\u0004b!a1\u0002L\u00065\bc\u0001:\u0002p\u0012a\u0011\u0011_At\u0003\u0003\u0005\tQ!\u0001\u0002t\n\u0019q\fJ\u001c\u0012\u0007]\f)\u0010\r\u0003\u0002x\u0006m\b\u0003\u0002?\u0000\u0003s\u00042A]A~\t1\ti0a@\u0002\u0002\u0003\u0005)\u0011AA\u0006\u0005\ryF\u0005\u000f\u0003\r\u0003c\f9/!A\u0002\u0002\u000b\u0005\u00111_\u0001\u0007kB$\u0017\r^3\u0015\u0011\t\u0015!q\u0002B\n\u0005/\u0001RAa\u0002\u0003\f)k!A!\u0003\u000b\u0005eJ\u0013\u0002\u0002B\u0007\u0005\u0013\u00111\u0001\u0016:z\u0011\u0019\u0011\tB\u0006a\u00011\u00069a/\u001a:tS>t\u0007b\u0002B\u000b-\u0001\u0007\u0011QS\u0001\u0014o\u0006dG.\u001a;C_b,\u0006\u000fZ1uK2K7\u000f\u001e\u0005\b\u000531\u0002\u0019AAY\u0003A\u0011w\u000e_%egJ+Wn\u001c<f\u0019&\u001cH/A\u0007mCN$h+\u001a:tS>t\u0017\nZ\u000b\u0003\u0005?\u0001B\u0001KA@1\u0006\u0001\"o\u001c7mE\u0006\u001c7NV3sg&|gn]\u000b\u0003\u0005K\u0001R!a&\u0002(b\u000b\u0001B]8mY\n\f7m\u001b\u000b\u0005\u0005\u000b\u0011Y\u0003\u0003\u0004\u0003\u0012e\u0001\r\u0001W\u0001\bSN,U\u000e\u001d;z+\t\u0011\t\u0004E\u0002)\u0005gI1A!\u000e*\u0005\u001d\u0011un\u001c7fC:\f1bZ3u\u0013R,'/\u0019;peV\u0011!1\b\t\u0004e\tu\u0012b\u0001B g\ty1\u000b^8sC\u001e,\u0017\n^3sCR|'\u000f")
public class SidechainWalletBoxStorage
implements SidechainTypes,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final LinkedHashMap<ByteArrayWrapper, WalletBox> _walletBoxes;
    private final LinkedHashMap<Class<? extends Box<? extends Proposition>>, Map<ByteArrayWrapper, WalletBox>> _walletBoxesByType;
    private final LinkedHashMap<Class<? extends Box<? extends Proposition>>, Object> _walletBoxesBalances;
    private final WalletBoxSerializer _walletBoxSerializer;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private LinkedHashMap<ByteArrayWrapper, WalletBox> _walletBoxes() {
        return this._walletBoxes;
    }

    private LinkedHashMap<Class<? extends Box<? extends Proposition>>, Map<ByteArrayWrapper, WalletBox>> _walletBoxesByType() {
        return this._walletBoxesByType;
    }

    private LinkedHashMap<Class<? extends Box<? extends Proposition>>, Object> _walletBoxesBalances() {
        return this._walletBoxesBalances;
    }

    private WalletBoxSerializer _walletBoxSerializer() {
        return this._walletBoxSerializer;
    }

    private void calculateBoxesBalances() {
        this._walletBoxesByType().keys().foreach((Function1 & Serializable & scala.Serializable)bc -> this._walletBoxesBalances().put(bc, ((TraversableOnce)((TraversableLike)this._walletBoxesByType().apply(bc)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SidechainWalletBoxStorage.$anonfun$calculateBoxesBalances$2(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    private void updateBoxesBalance(WalletBox boxToAdd, WalletBox boxToRemove) {
        block2: {
            BoxedUnit boxedUnit;
            if (boxToAdd != null) {
                Class<?> bca = boxToAdd.box().getClass();
                boxedUnit = this._walletBoxesBalances().put(bca, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(bca, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + boxToAdd.box().value())));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (boxToRemove == null) break block2;
            Class<?> bcr = boxToRemove.box().getClass();
            this._walletBoxesBalances().put(bcr, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(bcr, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - boxToRemove.box().value())));
        }
    }

    private void addWalletBoxByType(WalletBox walletBox) {
        Class<?> bc = walletBox.box().getClass();
        ByteArrayWrapper key = Utils.calculateKey(walletBox.box().id());
        Option t = this._walletBoxesByType().get(bc);
        if (t.isEmpty()) {
            LinkedHashMap m = new LinkedHashMap();
            m.put((Object)key, (Object)walletBox);
            this._walletBoxesByType().put(bc, (Object)m);
        } else {
            ((MapLike)t.get()).put((Object)key, (Object)walletBox);
        }
    }

    private void removeWalletBoxByType(ByteArrayWrapper boxIdToRemove) {
        this._walletBoxesByType().keys().foreach((Function1 & Serializable & scala.Serializable)bc -> ((MapLike)this._walletBoxesByType().apply(bc)).remove((Object)boxIdToRemove));
    }

    private void loadWalletBoxes() {
        this._walletBoxes().clear();
        this._walletBoxesByType().clear();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).foreach((Function1 & Serializable & scala.Serializable)wb -> {
            SidechainWalletBoxStorage.$anonfun$loadWalletBoxes$1(this, wb);
            return BoxedUnit.UNIT;
        });
        this.calculateBoxesBalances();
    }

    public Option<WalletBox> get(byte[] boxId) {
        return this._walletBoxes().get((Object)Utils.calculateKey(boxId));
    }

    public List<WalletBox> get(List<byte[]> boxIds) {
        return (List)((TraversableLike)boxIds.map((Function1 & Serializable & scala.Serializable)data -> Utils.calculateKey(data), List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SidechainWalletBoxStorage.$anonfun$get$2(this, id))).map((Function1 & Serializable & scala.Serializable)id -> (WalletBox)this._walletBoxes().apply(id), List$.MODULE$.canBuildFrom());
    }

    public List<WalletBox> getAll() {
        return this._walletBoxes().values().toList();
    }

    public List<WalletBox> getByType(Class<? extends Box<? extends Proposition>> boxType) {
        Nil$ nil$;
        Option option = this._walletBoxesByType().get(boxType);
        if (option instanceof Some) {
            Some some = (Some)option;
            Map v = (Map)some.value();
            nil$ = v.values().toList();
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return nil$;
    }

    public long getBoxesBalance(Class<? extends Box<? extends Proposition>> boxType) {
        return BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(boxType, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Try<SidechainWalletBoxStorage> update(ByteArrayWrapper version, List<WalletBox> walletBoxUpdateList, List<byte[]> boxIdsRemoveList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(walletBoxUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of WalletBoxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!walletBoxUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "WalletBox to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxIdsRemoveList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "BoxId to remove must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            removeList.addAll(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)boxIdsRemoveList.map((Function1 & Serializable & scala.Serializable)x$2 -> Utils.calculateKey(x$2), List$.MODULE$.canBuildFrom())).asJavaCollection());
            walletBoxUpdateList.foreach((Function1 & Serializable & scala.Serializable)wb -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(wb.box().id()), new ByteArrayWrapper(this._walletBoxSerializer().toBytes(wb))))));
            $this.storage.update(version, updateList, removeList);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(removeList).asScala()).foreach((Function1 & Serializable & scala.Serializable)key -> {
                SidechainWalletBoxStorage.$anonfun$update$8(this, key);
                return BoxedUnit.UNIT;
            });
            walletBoxUpdateList.foreach((Function1 & Serializable & scala.Serializable)wba -> {
                SidechainWalletBoxStorage.$anonfun$update$9(this, wba);
                return BoxedUnit.UNIT;
            });
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletBoxStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            this.loadWalletBoxes();
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public StorageIterator getIterator() {
        return this.storage.getIterator();
    }

    public static final /* synthetic */ long $anonfun$calculateBoxesBalances$2(Tuple2 x$1) {
        return ((WalletBox)x$1._2()).box().value();
    }

    public static final /* synthetic */ void $anonfun$loadWalletBoxes$1(SidechainWalletBoxStorage $this, Pair wb) {
        BoxedUnit boxedUnit;
        Try<WalletBox> walletBox = $this._walletBoxSerializer().parseBytesTry(((ByteArrayWrapper)wb.getValue()).data());
        if (walletBox.isSuccess()) {
            $this._walletBoxes().put((Object)Utils.calculateKey(((WalletBox)walletBox.get()).box().id()), walletBox.get());
            $this.addWalletBoxByType((WalletBox)walletBox.get());
        } else if ($this.log().underlying().isErrorEnabled()) {
            $this.log().underlying().error("Error while WalletBox parsing.", new Object[]{walletBox});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$get$2(SidechainWalletBoxStorage $this, ByteArrayWrapper id) {
        return $this._walletBoxes().get((Object)id).isDefined();
    }

    public static final /* synthetic */ void $anonfun$update$8(SidechainWalletBoxStorage $this, ByteArrayWrapper key) {
        block0: {
            Option btr = $this._walletBoxes().remove((Object)key);
            $this.removeWalletBoxByType(key);
            if (!btr.isDefined()) break block0;
            $this.updateBoxesBalance(null, (WalletBox)btr.get());
        }
    }

    public static final /* synthetic */ void $anonfun$update$9(SidechainWalletBoxStorage $this, WalletBox wba) {
        block0: {
            ByteArrayWrapper key = Utils.calculateKey(wba.box().id());
            Option bta = $this._walletBoxes().put((Object)key, (Object)wba);
            $this.addWalletBoxByType(wba);
            if (!bta.isEmpty()) break block0;
            $this.updateBoxesBalance(wba, null);
        }
    }

    public SidechainWalletBoxStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.storage = storage;
        SidechainTypes.$init$(this);
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
        this._walletBoxes = new LinkedHashMap();
        this._walletBoxesByType = new LinkedHashMap();
        this._walletBoxesBalances = new LinkedHashMap();
        this._walletBoxSerializer = new WalletBoxSerializer(sidechainBoxesCompanion);
        this.loadWalletBoxes();
    }
}

