/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.api.http.route;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.api.http.ApiResponseUtil$;
import io.horizen.api.http.JacksonSupport$;
import io.horizen.api.http.route.ErrorNotEnabledOnSeederNode$;
import io.horizen.api.http.route.TransactionBaseApiRoute;
import io.horizen.api.http.route.TransactionBaseErrorResponse;
import io.horizen.api.http.route.TransactionBaseRestScheme;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proof.SchnorrProof;
import io.horizen.proof.SchnorrSignatureSerializer;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.MCPublicKeyHashProposition;
import io.horizen.proposition.MCPublicKeyHashPropositionSerializer;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.PublicKey25519PropositionSerializer;
import io.horizen.proposition.SchnorrPropositionSerializer;
import io.horizen.proposition.VrfPublicKeySerializer;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.Secret;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Pair;
import io.horizen.utils.ZenCoinsUtils;
import io.horizen.utxo.api.http.route.SidechainTransactionApiRoute$;
import io.horizen.utxo.api.http.route.SidechainTransactionRestScheme;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.block.SidechainBlockHeader;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.box.data.BoxData;
import io.horizen.utxo.box.data.ForgerBoxData;
import io.horizen.utxo.box.data.WithdrawalRequestBoxData;
import io.horizen.utxo.box.data.ZenBoxData;
import io.horizen.utxo.chain.SidechainFeePaymentsInfo;
import io.horizen.utxo.companion.SidechainTransactionsCompanion;
import io.horizen.utxo.node.NodeHistory;
import io.horizen.utxo.node.NodeMemoryPool;
import io.horizen.utxo.node.NodeState;
import io.horizen.utxo.node.NodeWallet;
import io.horizen.utxo.node.SidechainNodeView;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.CertificateKeyRotationTransaction;
import io.horizen.utxo.transaction.OpenStakeTransaction;
import io.horizen.utxo.transaction.SidechainCoreTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;
import sparkz.core.settings.RESTApiSettings;
import sparkz.core.transaction.box.proposition.Proposition;

@ScalaSignature(bytes="\u0006\u0001\u0011Ma\u0001\u0002\u001f>\u0001*C!\"!\n\u0001\u0005+\u0007I\u0011IA\u0014\u0011)\tY\u0004\u0001B\tB\u0003%\u0011\u0011\u0006\u0005\u000b\u0003{\u0001!Q3A\u0005\u0002\u0005}\u0002BCA)\u0001\tE\t\u0015!\u0003\u0002B!Q\u00111\u000b\u0001\u0003\u0016\u0004%\t!a\u0010\t\u0015\u0005U\u0003A!E!\u0002\u0013\t\t\u0005\u0003\u0006\u0002X\u0001\u0011)\u001a!C\u0001\u00033B!\"!\u001a\u0001\u0005#\u0005\u000b\u0011BA.\u0011)\t9\u0007\u0001BK\u0002\u0013\u0005\u0011\u0011\u000e\u0005\u000b\u0003k\u0002!\u0011#Q\u0001\n\u0005-\u0004BCA<\u0001\tU\r\u0011\"\u0001\u0002z!Q\u0011q\u0014\u0001\u0003\u0012\u0003\u0006I!a\u001f\t\u0015\u0005\u0005\u0006A!b\u0001\n\u0007\n\u0019\u000b\u0003\u0007\u0002,\u0002\u0011\t\u0011)A\u0005\u0003K\u000bi\u000b\u0003\u0006\u00020\u0002\u0011)\u0019!C\"\u0003cCA\"a0\u0001\u0005\u0003\u0005\u000b\u0011BAZ\u0003\u0003Dq!a1\u0001\t\u0003\t)\rC\u0005\u0002^\u0002\u0011\r\u0011b\u0011\u0002`\"A\u0011Q\u001e\u0001!\u0002\u0013\t\t\u000f\u0003\u0005?\u0001\t\u0007I\u0011IAx\u0011!\u0011I\u0002\u0001Q\u0001\n\u0005E\bb\u0002B\u000e\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005;\u0001A\u0011AAx\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003_DqA!\t\u0001\t\u0003\ty\u000fC\u0004\u0003$\u0001!\t!a<\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002p\"9!q\u0005\u0001\u0005\u0002\u0005=\bb\u0002B\u0015\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005W\u0001A\u0011AAx\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003_DqAa\f\u0001\t\u0013\u0011\t\u0004C\u0004\u0003h\u0001!IA!\u001b\t\u000f\tM\u0004\u0001\"\u0003\u0003v!9!\u0011\u0018\u0001\u0005\n\tm\u0006b\u0002B\u000f\u0001\u0011%!\u0011\u001a\u0005\b\u0007'\u0001A\u0011IB\u000b\u0011%\u0019y\u0004AA\u0001\n\u0003\u0019\t\u0005C\u0005\u0004V\u0001\t\n\u0011\"\u0001\u0004X!I1Q\u000e\u0001\u0012\u0002\u0013\u00051q\u000e\u0005\n\u0007g\u0002\u0011\u0013!C\u0001\u0007_B\u0011b!\u001e\u0001#\u0003%\taa\u001e\t\u0013\rm\u0004!%A\u0005\u0002\ru\u0004\"CBA\u0001E\u0005I\u0011ABB\u0011%\u00199\tAA\u0001\n\u0003\u001aI\tC\u0005\u0004\u001a\u0002\t\t\u0011\"\u0001\u0004\u001c\"I1Q\u0014\u0001\u0002\u0002\u0013\u00051q\u0014\u0005\n\u0007W\u0003\u0011\u0011!C!\u0007[C\u0011ba/\u0001\u0003\u0003%\ta!0\t\u0013\r\u001d\u0007!!A\u0005B\r%\u0007\"CBf\u0001\u0005\u0005I\u0011IBg\u0011%\u0019y\rAA\u0001\n\u0003\u001a\tnB\u0005\u0004Vv\n\t\u0011#\u0001\u0004X\u001aAA(PA\u0001\u0012\u0003\u0019I\u000eC\u0004\u0002DZ\"\ta!9\t\u0013\r-g'!A\u0005F\r5\u0007\"CBrm\u0005\u0005I\u0011QBs\u0011%\u0019IPNA\u0001\n\u0003\u001bY\u0010C\u0005\u0005\nY\n\t\u0011\"\u0003\u0005\f\ta2+\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\f\u0005/\u001b*pkR,'B\u0001 @\u0003\u0015\u0011x.\u001e;f\u0015\t\u0001\u0015)\u0001\u0003iiR\u0004(B\u0001\"D\u0003\r\t\u0007/\u001b\u0006\u0003\t\u0016\u000bA!\u001e;y_*\u0011aiR\u0001\bQ>\u0014\u0018N_3o\u0015\u0005A\u0015AA5p\u0007\u0001\u0019\u0002\u0002A&\u0002\f\u0005M\u0011q\u0004\t\r\u0019B\u0013FM[7tsr|\u0018QA\u0007\u0002\u001b*\u0011aH\u0014\u0006\u0003\u0001>S!AQ#\n\u0005Ek%a\u0006+sC:\u001c\u0018m\u0019;j_:\u0014\u0015m]3Ba&\u0014v.\u001e;f!\u0011\u0019f\u000b\u00170\u000e\u0003QS!!V\"\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003/R\u0013aBQ8y)J\fgn]1di&|g\u000e\u0005\u0002Z96\t!L\u0003\u0002\\\u000b\u0006Y\u0001O]8q_NLG/[8o\u0013\ti&LA\u0006Qe>\u0004xn]5uS>t\u0007cA0c16\t\u0001M\u0003\u0002b\u0007\u0006\u0019!m\u001c=\n\u0005\r\u0004'a\u0001\"pqB\u0011Q\r[\u0007\u0002M*\u0011qmQ\u0001\u0006E2|7m[\u0005\u0003S\u001a\u0014AcU5eK\u000eD\u0017-\u001b8CY>\u001c7\u000eS3bI\u0016\u0014\bCA3l\u0013\tagM\u0001\bTS\u0012,7\r[1j]\ncwnY6\u0011\u00059\fX\"A8\u000b\u0005A\u001c\u0015!B2iC&t\u0017B\u0001:p\u0005a\u0019\u0016\u000eZ3dQ\u0006LgNR3f!\u0006LX.\u001a8ug&sgm\u001c\t\u0003i^l\u0011!\u001e\u0006\u0003m\u000e\u000bAA\\8eK&\u0011\u00010\u001e\u0002\f\u001d>$W\rS5ti>\u0014\u0018\u0010\u0005\u0002uu&\u001110\u001e\u0002\n\u001d>$Wm\u0015;bi\u0016\u0004\"\u0001^?\n\u0005y,(A\u0003(pI\u0016<\u0016\r\u001c7fiB\u0019A/!\u0001\n\u0007\u0005\rQO\u0001\bO_\u0012,W*Z7pef\u0004vn\u001c7\u0011\u0007Q\f9!C\u0002\u0002\nU\u0014\u0011cU5eK\u000eD\u0017-\u001b8O_\u0012,g+[3x!\u0011\ti!a\u0004\u000e\u0003\u0015K1!!\u0005F\u00059\u0019\u0016\u000eZ3dQ\u0006Lg\u000eV=qKN\u0004B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0003\u00033\tQa]2bY\u0006LA!!\b\u0002\u0018\t9\u0001K]8ek\u000e$\b\u0003BA\u000b\u0003CIA!a\t\u0002\u0018\ta1+\u001a:jC2L'0\u00192mK\u0006A1/\u001a;uS:<7/\u0006\u0002\u0002*A!\u00111FA\u001c\u001b\t\tiC\u0003\u0003\u0002&\u0005=\"\u0002BA\u0019\u0003g\tAaY8sK*\u0011\u0011QG\u0001\u0007gB\f'o\u001b>\n\t\u0005e\u0012Q\u0006\u0002\u0010%\u0016\u001bF+\u00119j'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u001bg&$Wm\u00195bS:tu\u000eZ3WS\u0016<\bj\u001c7eKJ\u0014VMZ\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0003bGR|'O\u0003\u0002\u0002L\u0005!\u0011m[6b\u0013\u0011\ty%!\u0012\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\f1d]5eK\u000eD\u0017-\u001b8O_\u0012,g+[3x\u0011>dG-\u001a:SK\u001a\u0004\u0013\u0001H:jI\u0016\u001c\u0007.Y5o)J\fgn]1di&|g.Q2u_J\u0014VMZ\u0001\u001eg&$Wm\u00195bS:$&/\u00198tC\u000e$\u0018n\u001c8BGR|'OU3gA\u0005I1m\\7qC:LwN\\\u000b\u0003\u00037\u0002B!!\u0018\u0002b5\u0011\u0011q\f\u0006\u0004\u0003/\u001a\u0015\u0002BA2\u0003?\u0012adU5eK\u000eD\u0017-\u001b8Ue\u0006t7/Y2uS>t7oQ8na\u0006t\u0017n\u001c8\u0002\u0015\r|W\u000e]1oS>t\u0007%\u0001\u0004qCJ\fWn]\u000b\u0003\u0003W\u0002B!!\u001c\u0002r5\u0011\u0011q\u000e\u0006\u0004\u0003O*\u0015\u0002BA:\u0003_\u0012QBT3uo>\u00148\u000eU1sC6\u001c\u0018a\u00029be\u0006l7\u000fI\u0001\fG&\u00148-^5u)f\u0004X-\u0006\u0002\u0002|A!\u0011QPAM\u001d\u0011\ty(a%\u000f\t\u0005\u0005\u0015q\u0012\b\u0005\u0003\u0007\u000biI\u0004\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tI)S\u0001\u0007yI|w\u000e\u001e \n\u0003!K!AR$\n\u0007\u0005EU)A\tdef\u0004Ho\u001c7jEB\u0014xN^5eKJLA!!&\u0002\u0018\u0006a1)\u001b:dk&$H+\u001f9fg*\u0019\u0011\u0011S#\n\t\u0005m\u0015Q\u0014\u0002\r\u0007&\u00148-^5u)f\u0004Xm\u001d\u0006\u0005\u0003+\u000b9*\u0001\u0007dSJ\u001cW/\u001b;UsB,\u0007%A\u0004d_:$X\r\u001f;\u0016\u0005\u0005\u0015\u0006\u0003BA\"\u0003OKA!!+\u0002F\ty\u0011i\u0019;peJ+gMR1di>\u0014\u00180\u0001\u0005d_:$X\r\u001f;!\u0013\r\t\t\u000bU\u0001\u0003K\u000e,\"!a-\u0011\t\u0005U\u00161X\u0007\u0003\u0003oSA!!/\u0002\u0018\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005u\u0016q\u0017\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!\u0013\r\ty\u000bU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005\u001d\u0017\u0011[Aj\u0003+\f9.!7\u0002\\R1\u0011\u0011ZAg\u0003\u001f\u00042!a3\u0001\u001b\u0005i\u0004bBAQ#\u0001\u000f\u0011Q\u0015\u0005\b\u0003_\u000b\u00029AAZ\u0011\u001d\t)#\u0005a\u0001\u0003SAq!!\u0010\u0012\u0001\u0004\t\t\u0005C\u0004\u0002TE\u0001\r!!\u0011\t\u000f\u0005]\u0013\u00031\u0001\u0002\\!9\u0011qM\tA\u0002\u0005-\u0004bBA<#\u0001\u0007\u00111P\u0001\u0004i\u0006<WCAAq!\u0019\t\u0019/!;\u0002\u00065\u0011\u0011Q\u001d\u0006\u0005\u0003O\f9\"A\u0004sK\u001adWm\u0019;\n\t\u0005-\u0018Q\u001d\u0002\t\u00072\f7o\u001d+bO\u0006!A/Y4!+\t\t\t\u0010\u0005\u0003\u0002t\nMa\u0002BA{\u0005\u001bqA!a>\u0003\b9!\u0011\u0011 B\u0001\u001d\u0011\tY0a@\u000f\t\u0005\u0015\u0015Q`\u0005\u0003\u0003\u0017J1\u0001QA%\u0013\u0011\u0011\u0019A!\u0002\u0002\u0011M\u001c\u0017\r\\1eg2T1\u0001QA%\u0013\u0011\u0011IAa\u0003\u0002\rM,'O^3s\u0015\u0011\u0011\u0019A!\u0002\n\t\t=!\u0011C\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\u0011IAa\u0003\n\t\tU!q\u0003\u0002\u0006%>,H/\u001a\u0006\u0005\u0005\u001f\u0011\t\"\u0001\u0004s_V$X\rI\u0001\tM&tGMQ=JI\u0006)2M]3bi\u0016\u001cuN]3Ue\u0006t7/Y2uS>t\u0017aH2sK\u0006$XmQ8sKR\u0013\u0018M\\:bGRLwN\\*j[Bd\u0017NZ5fI\u0006\u00112/\u001a8e\u0007>Lgn\u001d+p\u0003\u0012$'/Z:t\u000359\u0018\u000e\u001e5ee\u0006<8i\\5og\u0006yQ.Y6f\r>\u0014x-\u001a:Ti\u0006\\W-A\tta\u0016tGMR8sO&twm\u0015;bW\u0016\f!d\u0019:fCR,w\n]3o'R\f7.\u001a+sC:\u001c\u0018m\u0019;j_:\fAe\u0019:fCR,w\n]3o'R\f7.\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0016.\u001c9mS\u001aLW\rZ\u0001\u001dGJ,\u0017\r^3LKf\u0014v\u000e^1uS>tGK]1og\u0006\u001cG/[8o\u0003\r\u0012W/\u001b7e\u001fB,gn\u0015;bW\u0016$&/\u00198tC\u000e$\u0018n\u001c8TS6\u0004H.\u001b4jK\u0012$BAa\r\u0003FA1!Q\u0007B\u001e\u0005\u007fi!Aa\u000e\u000b\t\te\u0012qC\u0001\u0005kRLG.\u0003\u0003\u0003>\t]\"a\u0001+ssB\u00191K!\u0011\n\u0007\t\rCK\u0001\u000bPa\u0016t7\u000b^1lKR\u0013\u0018M\\:bGRLwN\u001c\u0005\b\u0005\u000f\u0002\u0003\u0019\u0001B%\u0003\u0011\u0011w\u000eZ=\u0011\t\t-#\u0011\r\b\u0005\u0005\u001b\u0012iF\u0004\u0003\u0003P\tmc\u0002\u0002B)\u00053rAAa\u0015\u0003X9!\u0011\u0011\u0011B+\u0013\t!U)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0003}}J1Aa\u0018>\u0003y\u0019\u0016\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]J+7\u000f^*dQ\u0016lW-\u0003\u0003\u0003d\t\u0015$A\u0006*fc>\u0003XM\\*uC.,7+[7qY&4\u0017.\u001a3\u000b\u0007\t}S(A\rck&dGm\u00149f]N#\u0018m[3Ue\u0006t7/Y2uS>tG\u0003\u0002B\u001a\u0005WBqAa\u0012\"\u0001\u0004\u0011i\u0007\u0005\u0003\u0003L\t=\u0014\u0002\u0002B9\u0005K\u0012ABU3r\u001fB,gn\u0015;bW\u0016\f\u0011e\u0019:fCR,\u0017I\u001c3TS\u001etw\n]3o'R\f7.\u001a+sC:\u001c\u0018m\u0019;j_:$BBa\r\u0003x\tm$1\u0012BP\u0005SCaA!\u001f#\u0001\u0004q\u0016\u0001C5oaV$(i\u001c=\t\u000f\tu$\u00051\u0001\u0003\u0000\u0005y\u0011N\u001c9viB\u0013\u0018N^1uK.+\u0017\u0010\u0005\u0003\u0003\u0002\n\u001dUB\u0001BB\u0015\r\u0011))R\u0001\u0007g\u0016\u001c'/\u001a;\n\t\t%%1\u0011\u0002\u0010!JLg/\u0019;f\u0017\u0016L('N\u001b2s!9!Q\u0012\u0012A\u0002\t=\u0015!E8viB,H\u000f\u0015:pa>\u001c\u0018\u000e^5p]B!!\u0011\u0013BM\u001d\u0011\u0011\u0019J!&\u0011\t\u0005\u0015\u0015qC\u0005\u0005\u0005/\u000b9\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00057\u0013iJ\u0001\u0004TiJLgn\u001a\u0006\u0005\u0005/\u000b9\u0002C\u0004\u0003\"\n\u0002\rAa)\u0002\u0017\u0019|'oZ3s\u0013:$W\r\u001f\t\u0005\u0003+\u0011)+\u0003\u0003\u0003(\u0006]!aA%oi\"9!1\u0016\u0012A\u0002\t5\u0016\u0001C5oaV$h)Z3\u0011\r\u0005U!q\u0016BZ\u0013\u0011\u0011\t,a\u0006\u0003\r=\u0003H/[8o!\u0011\t)B!.\n\t\t]\u0016q\u0003\u0002\u0005\u0019>tw-\u0001\thKR\u001c\u0005.\u00198hK\u0006#GM]3tgR!!Q\u0018Bc!\u0019\t)Ba,\u0003@B\u0019\u0011L!1\n\u0007\t\r'LA\rQk\nd\u0017nY&fsJ*T'M\u001dQe>\u0004xn]5uS>t\u0007B\u0002BdG\u0001\u0007A0\u0001\u0004xC2dW\r\u001e\u000b\u0011\u0005\u0017\u0014\u0019N!<\u0003z\u000e\u00151\u0011BB\u0007\u0007\u001f\u0001bA!\u000e\u0003<\t5\u0007cA*\u0003P&\u0019!\u0011\u001b+\u00031MKG-Z2iC&t7i\u001c:f)J\fgn]1di&|g\u000eC\u0004\u0003V\u0012\u0002\rAa6\u0002\u001di,gNQ8y\t\u0006$\u0018\rT5tiB1!\u0011\u001cBq\u0005OtAAa7\u0003`:!\u0011Q\u0011Bo\u0013\t\tI\"\u0003\u0003\u0003\u0010\u0005]\u0011\u0002\u0002Br\u0005K\u0014A\u0001T5ti*!!qBA\f!\u0011\u0011YE!;\n\t\t-(Q\r\u0002\u0012)J\fgn]1di&|gnT;uaV$\bb\u0002BxI\u0001\u0007!\u0011_\u0001\u001do&$\b\u000e\u001a:bo\u0006d'+Z9vKN$(i\u001c=ECR\fG*[:u!\u0019\u0011IN!9\u0003tB!!1\nB{\u0013\u0011\u00119P!\u001a\u0003EQ\u0013\u0018M\\:bGRLwN\\,ji\"$'/Y<bYJ+\u0017/^3ti>+H\u000f];u\u0011\u001d\u0011Y\u0010\na\u0001\u0005{\f\u0011CZ8sO\u0016\u0014(i\u001c=ECR\fG*[:u!\u0019\u0011IN!9\u0003\u0000B!!1JB\u0001\u0013\u0011\u0019\u0019A!\u001a\u0003/Q\u0013\u0018M\\:bGRLwN\u001c$pe\u001e,'oT;uaV$\bbBB\u0004I\u0001\u0007!1W\u0001\u0004M\u0016,\u0007bBB\u0006I\u0001\u0007!qX\u0001\u000eG\"\fgnZ3BI\u0012\u0014Xm]:\t\r\t\u001dG\u00051\u0001}\u0011\u001d\u0019\t\u0002\na\u0001\u0003\u000b\t\u0011c]5eK\u000eD\u0017-\u001b8O_\u0012,g+[3x\u0003]a\u0017n\u001d;PM\u0012K7/\u00192mK\u0012,e\u000e\u001a9pS:$8\u000f\u0006\u0003\u0004\u0018\ru\u0002C\u0002Bm\u00073\u0019i\"\u0003\u0003\u0004\u001c\t\u0015(aA*fcBQ\u0011QCB\u0010\u0007G\u0019yc!\u000e\n\t\r\u0005\u0012q\u0003\u0002\u0007)V\u0004H.Z\u001a\u0011\t\r\u00152qE\u0007\u0002\u0001%!1\u0011FB\u0016\u00059)e\u000e\u001a9pS:$\bK]3gSbL1a!\fN\u0005=!\u0015n]1cY\u0016\f\u0005/\u001b*pkR,\u0007\u0003BB\u0013\u0007cIAaa\r\u0004,\taQI\u001c3q_&tG\u000fU1uQB1\u0011Q\u0003BX\u0007o\u0001Ba!\n\u0004:%!11HB\u0016\u0005!)%O]8s\u001bN<\u0007bBA4K\u0001\u0007\u00111N\u0001\u0005G>\u0004\u0018\u0010\u0006\b\u0004D\r%31JB'\u0007\u001f\u001a\tfa\u0015\u0015\r\u0005%7QIB$\u0011\u001d\t\tK\na\u0002\u0003KCq!a,'\u0001\b\t\u0019\fC\u0005\u0002&\u0019\u0002\n\u00111\u0001\u0002*!I\u0011Q\b\u0014\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003'2\u0003\u0013!a\u0001\u0003\u0003B\u0011\"a\u0016'!\u0003\u0005\r!a\u0017\t\u0013\u0005\u001dd\u0005%AA\u0002\u0005-\u0004\"CA<MA\u0005\t\u0019AA>\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0017+\t\u0005%21L\u0016\u0003\u0007;\u0002Baa\u0018\u0004j5\u00111\u0011\r\u0006\u0005\u0007G\u001a)'A\u0005v]\u000eDWmY6fI*!1qMA\f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007W\u001a\tGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0004r)\"\u0011\u0011IB.\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0004z)\"\u00111LB.\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"aa +\t\u0005-41L\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019)I\u000b\u0003\u0002|\rm\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0004\fB!1QRBL\u001b\t\u0019yI\u0003\u0003\u0004\u0012\u000eM\u0015\u0001\u00027b]\u001eT!a!&\u0002\t)\fg/Y\u0005\u0005\u00057\u001by)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003$\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BBQ\u0007O\u0003B!!\u0006\u0004$&!1QUA\f\u0005\r\te.\u001f\u0005\n\u0007S{\u0013\u0011!a\u0001\u0005G\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCABX!\u0019\u0019\tla.\u0004\"6\u001111\u0017\u0006\u0005\u0007k\u000b9\"\u0001\u0006d_2dWm\u0019;j_:LAa!/\u00044\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0019yl!2\u0011\t\u0005U1\u0011Y\u0005\u0005\u0007\u0007\f9BA\u0004C_>dW-\u00198\t\u0013\r%\u0016'!AA\u0002\r\u0005\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t\r\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r-\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0004@\u000eM\u0007\"CBUi\u0005\u0005\t\u0019ABQ\u0003q\u0019\u0016\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]\u0006\u0003\u0018NU8vi\u0016\u00042!a37'\u0015141\\A\u0010!\u0011\t)b!8\n\t\r}\u0017q\u0003\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r]\u0017!B1qa2LHCDBt\u0007[\u001cyo!=\u0004t\u000eU8q\u001f\u000b\u0007\u0003\u0013\u001cIoa;\t\u000f\u0005\u0005\u0016\bq\u0001\u0002&\"9\u0011qV\u001dA\u0004\u0005M\u0006bBA\u0013s\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003{I\u0004\u0019AA!\u0011\u001d\t\u0019&\u000fa\u0001\u0003\u0003Bq!a\u0016:\u0001\u0004\tY\u0006C\u0004\u0002he\u0002\r!a\u001b\t\u000f\u0005]\u0014\b1\u0001\u0002|\u00059QO\\1qa2LH\u0003BB\u007f\t\u000b\u0001b!!\u0006\u00030\u000e}\b\u0003EA\u000b\t\u0003\tI#!\u0011\u0002B\u0005m\u00131NA>\u0013\u0011!\u0019!a\u0006\u0003\rQ+\b\u000f\\37\u0011%!9AOA\u0001\u0002\u0004\tI-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011AQ\u0002\t\u0005\u0007\u001b#y!\u0003\u0003\u0005\u0012\r=%AB(cU\u0016\u001cG\u000f")
public class SidechainTransactionApiRoute
extends TransactionBaseApiRoute<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>, SidechainBlockHeader, SidechainBlock, SidechainFeePaymentsInfo, NodeHistory, NodeState, NodeWallet, NodeMemoryPool, SidechainNodeView>
implements SidechainTypes,
Product,
scala.Serializable {
    private final RESTApiSettings settings;
    private final ActorRef sidechainNodeViewHolderRef;
    private final ActorRef sidechainTransactionActorRef;
    private final SidechainTransactionsCompanion companion;
    private final NetworkParams params;
    private final Enumeration.Value circuitType;
    private final ClassTag<SidechainNodeView> tag;
    private final Function1<RequestContext, Future<RouteResult>> route;

    public static Option<Tuple6<RESTApiSettings, ActorRef, ActorRef, SidechainTransactionsCompanion, NetworkParams, Enumeration.Value>> unapply(SidechainTransactionApiRoute sidechainTransactionApiRoute) {
        return SidechainTransactionApiRoute$.MODULE$.unapply(sidechainTransactionApiRoute);
    }

    public static SidechainTransactionApiRoute apply(RESTApiSettings rESTApiSettings, ActorRef actorRef, ActorRef actorRef2, SidechainTransactionsCompanion sidechainTransactionsCompanion, NetworkParams networkParams, Enumeration.Value value, ActorRefFactory actorRefFactory, ExecutionContext executionContext) {
        return SidechainTransactionApiRoute$.MODULE$.apply(rESTApiSettings, actorRef, actorRef2, sidechainTransactionsCompanion, networkParams, value, actorRefFactory, executionContext);
    }

    @Override
    public BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> sidechainTxToScbt(SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<io.horizen.proposition.Proposition, Proof<io.horizen.proposition.Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<io.horizen.proposition.Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<io.horizen.proposition.Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<io.horizen.proposition.Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<io.horizen.proposition.Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<io.horizen.proposition.Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<io.horizen.proposition.Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public RESTApiSettings settings() {
        return this.settings;
    }

    @Override
    public ActorRef sidechainNodeViewHolderRef() {
        return this.sidechainNodeViewHolderRef;
    }

    public ActorRef sidechainTransactionActorRef() {
        return this.sidechainTransactionActorRef;
    }

    public SidechainTransactionsCompanion companion() {
        return this.companion;
    }

    public NetworkParams params() {
        return this.params;
    }

    public Enumeration.Value circuitType() {
        return this.circuitType;
    }

    @Override
    public ActorRefFactory context() {
        return super.context();
    }

    @Override
    public ExecutionContext ec() {
        return super.ec();
    }

    @Override
    public ClassTag<SidechainNodeView> tag() {
        return this.tag;
    }

    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.route;
    }

    public Function1<RequestContext, Future<RouteResult>> findById() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("findById")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqFindById.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            NodeMemoryPool memoryPool = sidechainNodeView.getNodeMemoryPool();
            NodeHistory history = sidechainNodeView.getNodeHistory();
            String txId = body2.transactionId();
            boolean format = BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            None$ transaction = None$.MODULE$;
            String error = "";
            Option<String> option = body2.blockHash();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                String hash = (String)some.value();
                transaction = SidechainTransactionApiRoute.searchTransactionInBlock$1(txId, hash, history);
                if (transaction.isEmpty()) {
                    error = new StringBuilder(41).append("Transaction ").append(txId).append(" not found in specified block").toString();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                transaction = SidechainTransactionApiRoute.searchTransactionInMemoryPool$1(txId, memoryPool);
                if (transaction.isEmpty()) {
                    error = new StringBuilder(37).append("Transaction ").append(txId).append(" not found in memory pool").toString();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError(option);
            }
            None$ none$ = transaction;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                BoxTransaction t = (BoxTransaction)some.value();
                function1 = format ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<BoxTransaction>(t)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(t))));
            } else if (None$.MODULE$.equals(none$)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionId(error, Optional.empty()));
            } else {
                throw new MatchError((Object)none$);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createCoreTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createCoreTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$1 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateCoreTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            block7: {
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Buffer inputBoxes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$5(body2, box)));
                if (inputBoxes.length() < body2.transactionInputs().size()) {
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionInput("Unable to find input(s)", Optional.empty()));
                } else {
                    ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> outputs = new ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>>();
                    body2.regularOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value()))));
                    body2.withdrawalRequests().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new WithdrawalRequestBoxData((MCPublicKeyHashProposition)MCPublicKeyHashPropositionSerializer.getSerializer().parseBytes(BytesUtils.fromHorizenMcTransparentAddress(element.mainchainAddress(), this.params())), element.value()))));
                    body2.forgerOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$9(outputs, element)));
                    long inputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long outputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(outputs).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long fee = inputsTotalAmount - outputsTotalAmount;
                    if (fee < 0L) {
                        function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(new IllegalArgumentException("Total inputs amount is less then total outputs amount."))));
                    } else {
                        try {
                            java.util.List boxIds = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.id(), Buffer$.MODULE$.canBuildFrom())).asJava();
                            java.util.List<Object> fakeProofs = Collections.nCopies(boxIds.size(), null);
                            body2.withdrawalRequests().foreach((Function1 & Serializable & scala.Serializable)element -> {
                                SidechainTransactionApiRoute.$anonfun$createCoreTransaction$14(element);
                                return BoxedUnit.UNIT;
                            });
                            SidechainCoreTransaction unsignedTransaction = new SidechainCoreTransaction(boxIds, outputs, fakeProofs, fee, 1);
                            byte[] messageToSign = unsignedTransaction.messageToSign();
                            Buffer proofs = (Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)box -> {
                                Proposition proposition = box.proposition();
                                if (!(proposition instanceof PublicKey25519Proposition)) {
                                    throw new IllegalArgumentException(new StringBuilder(91).append("Unexpected box locking proposition for box id [").append(BytesUtils.toHexString(box.id())).append("]. Expected: PublicKey25519Proposition, got ").append(box.proposition().getClass()).toString());
                                }
                                PublicKey25519Proposition publicKey25519Proposition = (PublicKey25519Proposition)proposition;
                                Signature25519 signature25519 = wallet.secretByPublicKey25519Proposition(publicKey25519Proposition).get().sign(messageToSign);
                                return signature25519;
                            }, Buffer$.MODULE$.canBuildFrom());
                            SidechainCoreTransaction transaction = new SidechainCoreTransaction(boxIds, outputs, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(proofs).asJava(), fee, 1);
                            if (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<SidechainCoreTransaction>(transaction));
                                break block7;
                            }
                            function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(transaction))));
                        }
                        catch (Throwable t) {
                            function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(t)));
                        }
                    }
                }
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> createCoreTransactionSimplified() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createCoreTransactionSimplified")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$5 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateCoreTransactionSimplified.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            List<SidechainTransactionRestScheme.TransactionOutput> outputList = body2.regularOutputs();
            List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput> withdrawalRequestList = body2.withdrawalRequests();
            List<SidechainTransactionRestScheme.TransactionForgerOutput> forgerOutputList = body2.forgerOutputs();
            long fee = body2.fee();
            NodeWallet wallet = sidechainNodeView.getNodeWallet();
            Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
            if (option instanceof Some) {
                Function1<RequestContext, Future<RouteResult>> function12;
                Some some = (Some)option;
                PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                Try<SidechainCoreTransaction> try_ = this.createCoreTransaction(outputList, withdrawalRequestList, forgerOutputList, fee, changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                    function12 = BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<SidechainCoreTransaction>(transaction)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(transaction))));
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    function12 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
                } else {
                    throw new MatchError(try_);
                }
                function1 = function12;
            } else if (None$.MODULE$.equals(option)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."))));
            } else {
                throw new MatchError(option);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> sendCoinsToAddress() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("sendCoinsToAddress")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$6 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqSendCoinsToAddress.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try try_ = (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Try<SidechainCoreTransaction> try_;
                List<SidechainTransactionRestScheme.TransactionOutput> outputList = body2.outputs();
                Option<Object> fee = body2.fee();
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                    try_ = this.createCoreTransaction(outputList, (List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput>)Nil$.MODULE$, (List<SidechainTransactionRestScheme.TransactionForgerOutput>)Nil$.MODULE$, BoxesRunTime.unboxToLong((Object)fee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                } else if (None$.MODULE$.equals(option)) {
                    try_ = new Try<SidechainCoreTransaction>((Throwable)new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."));
                } else {
                    throw new MatchError(option);
                }
                return try_;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                function1 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(transaction, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<SidechainCoreTransaction>(transaction)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(transaction)))));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> withdrawCoins() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("withdrawCoins")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$7 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqWithdrawCoins.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try try_ = (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Try<SidechainCoreTransaction> try_;
                List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput> withdrawalOutputsList = body2.outputs();
                Option<Object> fee = body2.fee();
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                    try_ = this.createCoreTransaction((List<SidechainTransactionRestScheme.TransactionOutput>)Nil$.MODULE$, withdrawalOutputsList, (List<SidechainTransactionRestScheme.TransactionForgerOutput>)Nil$.MODULE$, BoxesRunTime.unboxToLong((Object)fee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                } else if (None$.MODULE$.equals(option)) {
                    try_ = new Try<SidechainCoreTransaction>((Throwable)new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."));
                } else {
                    throw new MatchError(option);
                }
                return try_;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                function1 = this.validateAndSendTransaction(transaction, this.validateAndSendTransaction$default$2());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> makeForgerStake() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("makeForgerStake")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$8 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateForgerStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try try_ = (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Try<SidechainCoreTransaction> try_;
                List<SidechainTransactionRestScheme.TransactionForgerOutput> forgerOutputsList = body2.outputs();
                Option<Object> fee = body2.fee();
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                    try_ = this.createCoreTransaction((List<SidechainTransactionRestScheme.TransactionOutput>)Nil$.MODULE$, (List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput>)Nil$.MODULE$, forgerOutputsList, BoxesRunTime.unboxToLong((Object)fee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                } else if (None$.MODULE$.equals(option)) {
                    try_ = new Try<SidechainCoreTransaction>((Throwable)new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."));
                } else {
                    throw new MatchError(option);
                }
                return try_;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                function1 = this.validateAndSendTransaction(transaction, this.validateAndSendTransaction$default$2());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> spendForgingStake() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("spendForgingStake")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$9 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqSpendForgingStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Right right;
            Tuple2 tuple2;
            Function1<RequestContext, Future<RouteResult>> function1;
            Either either = (Either)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Left left;
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Buffer inputBoxes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$spendForgingStake$5(body2, box)));
                if (inputBoxes.length() < body2.transactionInputs().size()) {
                    left = package$.MODULE$.Left().apply(ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionInput("Unable to find input(s)", Optional.empty())));
                } else {
                    ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> outputs = new ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>>();
                    body2.regularOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value()))));
                    body2.forgerOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$spendForgingStake$8(outputs, element)));
                    long inputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long outputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(outputs).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long fee = inputsTotalAmount - outputsTotalAmount;
                    try {
                        java.util.List boxIds = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.id(), Buffer$.MODULE$.canBuildFrom())).asJava();
                        java.util.List<Object> fakeProofs = Collections.nCopies(boxIds.size(), null);
                        SidechainCoreTransaction unsignedTransaction = new SidechainCoreTransaction(boxIds, outputs, fakeProofs, fee, 1);
                        byte[] messageToSign = unsignedTransaction.messageToSign();
                        Buffer proofs = (Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)box -> {
                            Proposition proposition = box.proposition();
                            if (!(proposition instanceof PublicKey25519Proposition)) {
                                throw new IllegalArgumentException(new StringBuilder(91).append("Unexpected box locking proposition for box id [").append(BytesUtils.toHexString(box.id())).append("]. Expected: PublicKey25519Proposition, got ").append(box.proposition().getClass()).toString());
                            }
                            PublicKey25519Proposition publicKey25519Proposition = (PublicKey25519Proposition)proposition;
                            Signature25519 signature25519 = wallet.secretByPublicKey25519Proposition(publicKey25519Proposition).get().sign(messageToSign);
                            return signature25519;
                        }, Buffer$.MODULE$.canBuildFrom());
                        SidechainCoreTransaction transaction = new SidechainCoreTransaction(boxIds, outputs, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(proofs).asJava(), fee, 1);
                        Function1 & Serializable & scala.Serializable txRepresentation = BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? (Function1 & Serializable & scala.Serializable)tx -> new TransactionBaseRestScheme.TransactionDTO<BoxTransaction>((BoxTransaction)tx) : (Function1 & Serializable & scala.Serializable)tx -> new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(tx)));
                        left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)transaction, (Object)txRepresentation));
                    }
                    catch (Throwable t) {
                        left = package$.MODULE$.Left().apply(ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(t))));
                    }
                }
                return left;
            });
            if (either instanceof Left) {
                Function1<RequestContext, Future<RouteResult>> errorResponse;
                Left left = (Left)either;
                function1 = errorResponse = (Function1<RequestContext, Future<RouteResult>>)left.value();
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)tuple2._1();
                Function1 txRepresentation = (Function1)tuple2._2();
                function1 = this.validateAndSendTransaction(transaction, txRepresentation);
            } else {
                throw new MatchError((Object)either);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createOpenStakeTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createOpenStakeTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$13 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqOpenStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try<OpenStakeTransaction> try_ = this.buildOpenStakeTransaction((SidechainTransactionRestScheme.ReqOpenStake)body2);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                OpenStakeTransaction tx = (OpenStakeTransaction)success.value();
                function1 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(tx, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<OpenStakeTransaction>(tx)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(tx)))));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(exception)));
            } else {
                throw new MatchError(try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createOpenStakeTransactionSimplified() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createOpenStakeTransactionSimplified")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$14 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqOpenStakeSimplified.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try<OpenStakeTransaction> try_ = this.buildOpenStakeTransactionSimplified((SidechainTransactionRestScheme.ReqOpenStakeSimplified)body2);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                OpenStakeTransaction tx = (OpenStakeTransaction)success.value();
                function1 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(tx, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<OpenStakeTransaction>(tx)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(tx)))));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(exception)));
            } else {
                throw new MatchError(try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createKeyRotationTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createKeyRotationTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$15 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateKeyRotationTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1 function1;
            Enumeration.Value value = this.circuitType();
            Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorBadCircuit("The current circuit doesn't support key rotation transaction!", Optional.empty()));
            } else {
                Enumeration.Value value4 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    function1 = (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                        Function1<RequestContext, Future<RouteResult>> function1;
                        NodeWallet wallet = sidechainNodeView.getNodeWallet();
                        long fee = BoxesRunTime.unboxToLong((Object)body2.fee().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        NodeMemoryPool memoryPool = sidechainNodeView.getNodeMemoryPool();
                        ArrayList<byte[]> boxIdsToExclude = new ArrayList<byte[]>();
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(memoryPool.getTransactions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)transaction -> {
                            SidechainTransactionApiRoute.$anonfun$createKeyRotationTransaction$6(boxIdsToExclude, transaction);
                            return BoxedUnit.UNIT;
                        });
                        Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.boxesOfType(ZenBox.class, boxIdsToExclude)).asScala()).find((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createKeyRotationTransaction$8(fee, box)));
                        if (option instanceof Some) {
                            Function1<RequestContext, Future<RouteResult>> function12;
                            Some some = (Some)option;
                            Box inputBox = (Box)some.value();
                            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> CertificateKeyRotationTransaction.create(new Pair<ZenBox, PrivateKey25519>((ZenBox)inputBox, wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)inputBox.proposition()).get()), (PublicKey25519Proposition)inputBox.proposition(), fee, body2.keyType(), body2.keyIndex(), SchnorrPropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(body2.newKey())), (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(body2.signingKeySignature())), (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(body2.masterKeySignature())), (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(body2.newKeySignature()))));
                            if (try_ instanceof Success) {
                                Success success = (Success)try_;
                                CertificateKeyRotationTransaction keyRotationTransaction = (CertificateKeyRotationTransaction)success.value();
                                function12 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(keyRotationTransaction, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<CertificateKeyRotationTransaction>(keyRotationTransaction)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(keyRotationTransaction)))));
                            } else if (try_ instanceof Failure) {
                                Failure failure = (Failure)try_;
                                Throwable ex = failure.exception();
                                function12 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(ex)));
                            } else {
                                throw new MatchError((Object)try_);
                            }
                            function1 = function12;
                        } else if (None$.MODULE$.equals(option)) {
                            function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionInput("Not found input box to pay the fee", Optional.empty()));
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return function1;
                    });
                } else {
                    throw new MatchError((Object)value);
                }
            }
            return function1;
        })));
    }

    private Try<OpenStakeTransaction> buildOpenStakeTransactionSimplified(SidechainTransactionRestScheme.ReqOpenStakeSimplified body2) {
        return (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            NodeWallet wallet = sidechainNodeView.getNodeWallet();
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).find((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$buildOpenStakeTransactionSimplified$2(body2, box)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unable to find input for Proposition ").append(body2.forgerProposition()).toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Box inputBox = (Box)some.value();
            PrivateKey25519 inputPrivateKey = wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)inputBox.proposition()).get();
            Try<OpenStakeTransaction> try_ = this.createAndSignOpenStakeTransaction(inputBox, inputPrivateKey, body2.forgerProposition(), body2.forgerIndex(), body2.fee());
            return try_;
        });
    }

    private Try<OpenStakeTransaction> buildOpenStakeTransaction(SidechainTransactionRestScheme.ReqOpenStake body2) {
        return (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            NodeWallet wallet = sidechainNodeView.getNodeWallet();
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).find((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$buildOpenStakeTransaction$2(body2, box)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException("Unable to find input!");
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Box inputBox = (Box)some.value();
            PrivateKey25519 inputPrivateKey = wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)inputBox.proposition()).get();
            Try<OpenStakeTransaction> try_ = this.createAndSignOpenStakeTransaction(inputBox, inputPrivateKey, body2.regularOutputProposition(), body2.forgerIndex(), body2.fee());
            return try_;
        });
    }

    private Try<OpenStakeTransaction> createAndSignOpenStakeTransaction(Box<io.horizen.proposition.Proposition> inputBox, PrivateKey25519 inputPrivateKey, String outputProposition, int forgerIndex, Option<Object> inputFee) {
        long fee = BoxesRunTime.unboxToLong((Object)inputFee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        if (fee < 0L) {
            throw new IllegalArgumentException("Fee can't be negative!");
        }
        if (fee > inputBox.value()) {
            throw new IllegalArgumentException("Fee can't be greater than the input!");
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> OpenStakeTransaction.create(new Pair<ZenBox, PrivateKey25519>((ZenBox)inputBox, inputPrivateKey), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(outputProposition)), forgerIndex, fee));
    }

    private Option<PublicKey25519Proposition> getChangeAddress(NodeWallet wallet) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allSecrets()).asScala()).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$getChangeAddress$1(s))).map((Function1 & Serializable & scala.Serializable)x$16 -> (PublicKey25519Proposition)x$16.publicImage());
    }

    private Try<SidechainCoreTransaction> createCoreTransaction(List<SidechainTransactionRestScheme.TransactionOutput> zenBoxDataList, List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput> withdrawalRequestBoxDataList, List<SidechainTransactionRestScheme.TransactionForgerOutput> forgerBoxDataList, long fee, PublicKey25519Proposition changeAddress, NodeWallet wallet, SidechainNodeView sidechainNodeView) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            NodeMemoryPool memoryPool = sidechainNodeView.getNodeMemoryPool();
            ArrayList boxIdsToExclude = new ArrayList();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(memoryPool.getTransactions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)transaction -> {
                SidechainTransactionApiRoute.$anonfun$createCoreTransaction$18(boxIdsToExclude, transaction);
                return BoxedUnit.UNIT;
            });
            ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> outputs = new ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>>();
            zenBoxDataList.foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value()))));
            withdrawalRequestBoxDataList.foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$21(this, outputs, element)));
            forgerBoxDataList.foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$22(outputs, element)));
            long outputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(outputs).asScala()).map((Function1 & Serializable & scala.Serializable)boxData -> BoxesRunTime.boxToLong((long)boxData.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long inputsMinimumExpectedAmount = outputsTotalAmount + fee;
            LongRef inputsTotalAmount = LongRef.create((long)0L);
            ArrayBuffer boxes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.boxesOfType(ZenBox.class, boxIdsToExclude)).asScala()).foreach((Function1 & Serializable & scala.Serializable)box -> {
                SidechainTransactionApiRoute.$anonfun$createCoreTransaction$26(boxes, inputsTotalAmount, inputsMinimumExpectedAmount, box);
                return BoxedUnit.UNIT;
            }));
            if (inputsTotalAmount.elem < inputsMinimumExpectedAmount) {
                throw new IllegalArgumentException("Not enough balances in the wallet to create transaction.");
            }
            Object object = inputsTotalAmount.elem > inputsMinimumExpectedAmount ? BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(changeAddress, inputsTotalAmount.elem - inputsMinimumExpectedAmount))) : BoxedUnit.UNIT;
            java.util.List boxIds = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)boxes.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.id(), ArrayBuffer$.MODULE$.canBuildFrom())).asJava();
            java.util.List<Object> fakeProofs = Collections.nCopies(boxIds.size(), null);
            SidechainCoreTransaction unsignedTransaction = new SidechainCoreTransaction(boxIds, outputs, fakeProofs, fee, 1);
            byte[] messageToSign = unsignedTransaction.messageToSign();
            ArrayBuffer proofs = (ArrayBuffer)boxes.map((Function1 & Serializable & scala.Serializable)box -> wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)box.proposition()).get().sign(messageToSign), ArrayBuffer$.MODULE$.canBuildFrom());
            return new SidechainCoreTransaction(boxIds, outputs, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)proofs).asJava(), fee, 1);
        });
    }

    @Override
    public Seq<Tuple3<String, String, Option<String>>> listOfDisabledEndpoints(NetworkParams params) {
        Seq seq;
        if (!params.isHandlingTransactionsEnabled()) {
            Some error = new Some((Object)ErrorNotEnabledOnSeederNode$.MODULE$.description());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.transactionPathPrefix(), (Object)"createCoreTransaction", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"createCoreTransactionSimplified", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"sendCoinsToAddress", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"sendTransaction", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"withdrawCoins", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"makeForgerStake", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"spendForgingStake", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"createOpenStakeTransactionSimplified", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"createOpenStakeTransaction", (Object)error), new Tuple3((Object)this.transactionPathPrefix(), (Object)"createKeyRotationTransaction", (Object)error)}));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    public SidechainTransactionApiRoute copy(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, ActorRef sidechainTransactionActorRef, SidechainTransactionsCompanion companion, NetworkParams params, Enumeration.Value circuitType, ActorRefFactory context, ExecutionContext ec) {
        return new SidechainTransactionApiRoute(settings, sidechainNodeViewHolderRef, sidechainTransactionActorRef, companion, params, circuitType, context, ec);
    }

    public RESTApiSettings copy$default$1() {
        return this.settings();
    }

    public ActorRef copy$default$2() {
        return this.sidechainNodeViewHolderRef();
    }

    public ActorRef copy$default$3() {
        return this.sidechainTransactionActorRef();
    }

    public SidechainTransactionsCompanion copy$default$4() {
        return this.companion();
    }

    public NetworkParams copy$default$5() {
        return this.params();
    }

    public Enumeration.Value copy$default$6() {
        return this.circuitType();
    }

    public String productPrefix() {
        return "SidechainTransactionApiRoute";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.settings();
                break;
            }
            case 1: {
                object = this.sidechainNodeViewHolderRef();
                break;
            }
            case 2: {
                object = this.sidechainTransactionActorRef();
                break;
            }
            case 3: {
                object = this.companion();
                break;
            }
            case 4: {
                object = this.params();
                break;
            }
            case 5: {
                object = this.circuitType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SidechainTransactionApiRoute;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SidechainTransactionApiRoute)) return false;
        boolean bl = true;
        if (!bl) return false;
        SidechainTransactionApiRoute sidechainTransactionApiRoute = (SidechainTransactionApiRoute)x$1;
        RESTApiSettings rESTApiSettings = this.settings();
        RESTApiSettings rESTApiSettings2 = sidechainTransactionApiRoute.settings();
        if (rESTApiSettings == null) {
            if (rESTApiSettings2 != null) {
                return false;
            }
        } else if (!rESTApiSettings.equals(rESTApiSettings2)) return false;
        ActorRef actorRef = this.sidechainNodeViewHolderRef();
        ActorRef actorRef2 = sidechainTransactionApiRoute.sidechainNodeViewHolderRef();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!actorRef.equals(actorRef2)) return false;
        ActorRef actorRef3 = this.sidechainTransactionActorRef();
        ActorRef actorRef4 = sidechainTransactionApiRoute.sidechainTransactionActorRef();
        if (actorRef3 == null) {
            if (actorRef4 != null) {
                return false;
            }
        } else if (!actorRef3.equals(actorRef4)) return false;
        SidechainTransactionsCompanion sidechainTransactionsCompanion = this.companion();
        SidechainTransactionsCompanion sidechainTransactionsCompanion2 = sidechainTransactionApiRoute.companion();
        if (sidechainTransactionsCompanion == null) {
            if (sidechainTransactionsCompanion2 != null) {
                return false;
            }
        } else if (!((Object)sidechainTransactionsCompanion).equals(sidechainTransactionsCompanion2)) return false;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = sidechainTransactionApiRoute.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        Enumeration.Value value = this.circuitType();
        Enumeration.Value value2 = sidechainTransactionApiRoute.circuitType();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!sidechainTransactionApiRoute.canEqual(this)) return false;
        return true;
    }

    private static final Option searchTransactionInMemoryPool$1(String id, NodeMemoryPool memoryPool$1) {
        Optional opt = memoryPool$1.getTransactionById(id);
        return opt.isPresent() ? Option$.MODULE$.apply(opt.get()) : None$.MODULE$;
    }

    private static final Option searchTransactionInBlock$1(String id, String blockHash, NodeHistory history$1) {
        Optional opt = history$1.searchTransactionInsideSidechainBlock(id, blockHash);
        return opt.isPresent() ? Option$.MODULE$.apply(opt.get()) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$6(Box box$1, SidechainTransactionRestScheme.TransactionInput p) {
        return p.boxId().contentEquals(BytesUtils.toHexString(box$1.id()));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$5(SidechainTransactionRestScheme.ReqCreateCoreTransaction body$2, Box box) {
        return (box instanceof ZenBox || box instanceof ForgerBox) && body$2.transactionInputs().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$6(box, p)));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$9(java.util.List outputs$1, SidechainTransactionRestScheme.TransactionForgerOutput element) {
        ForgerBoxData forgerBoxToAdd = new ForgerBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value(), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString((String)element.blockSignPublicKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> element.publicKey()))), VrfPublicKeySerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.vrfPubKey())));
        return outputs$1.add(forgerBoxToAdd);
    }

    public static final /* synthetic */ void $anonfun$createCoreTransaction$14(SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput element) {
        if (element.value() < ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE)) {
            throw new IllegalArgumentException("Withdrawal transaction amount is below the MC dust threshold value.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$spendForgingStake$6(Box box$2, SidechainTransactionRestScheme.TransactionInput p) {
        return p.boxId().contentEquals(BytesUtils.toHexString(box$2.id()));
    }

    public static final /* synthetic */ boolean $anonfun$spendForgingStake$5(SidechainTransactionRestScheme.ReqSpendForgingStake body$7, Box box) {
        return (box instanceof ZenBox || box instanceof ForgerBox) && body$7.transactionInputs().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$spendForgingStake$6(box, p)));
    }

    public static final /* synthetic */ boolean $anonfun$spendForgingStake$8(java.util.List outputs$2, SidechainTransactionRestScheme.TransactionForgerOutput element) {
        ForgerBoxData forgerBoxToAdd = new ForgerBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value(), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString((String)element.blockSignPublicKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> element.publicKey()))), VrfPublicKeySerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.vrfPubKey())));
        return outputs$2.add(forgerBoxToAdd);
    }

    public static final /* synthetic */ void $anonfun$createKeyRotationTransaction$6(ArrayList boxIdsToExclude$1, BoxTransaction transaction) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(transaction.boxIdsToOpen()).asScala()).foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)boxIdsToExclude$1.add(id.data())));
    }

    public static final /* synthetic */ boolean $anonfun$createKeyRotationTransaction$8(long fee$1, Box box) {
        return box.value() >= fee$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOpenStakeTransactionSimplified$2(SidechainTransactionRestScheme.ReqOpenStakeSimplified body$9, Box box) {
        return box.proposition().equals(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(body$9.forgerProposition()))) && box.value() >= BoxesRunTime.unboxToLong((Object)body$9.fee().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$buildOpenStakeTransaction$2(SidechainTransactionRestScheme.ReqOpenStake body$10, Box box) {
        return BytesUtils.toHexString(box.id()).equals(body$10.transactionInput().boxId());
    }

    public static final /* synthetic */ boolean $anonfun$getChangeAddress$1(Secret s) {
        return s.publicImage() instanceof PublicKey25519Proposition;
    }

    public static final /* synthetic */ void $anonfun$createCoreTransaction$18(ArrayList boxIdsToExclude$2, BoxTransaction transaction) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(transaction.boxIdsToOpen()).asScala()).foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)boxIdsToExclude$2.add(id.data())));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$21(SidechainTransactionApiRoute $this, java.util.List outputs$3, SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput element) {
        if (element.value() < ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE)) {
            throw new IllegalArgumentException(new StringBuilder(69).append("Withdrawal transaction amount ").append(element.value()).append(" is below the MC dust threshold value: ").append(ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE)).toString());
        }
        return outputs$3.add(new WithdrawalRequestBoxData((MCPublicKeyHashProposition)MCPublicKeyHashPropositionSerializer.getSerializer().parseBytes(BytesUtils.fromHorizenMcTransparentAddress(element.mainchainAddress(), $this.params())), element.value()));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$22(java.util.List outputs$3, SidechainTransactionRestScheme.TransactionForgerOutput element) {
        ForgerBoxData forgingBoxToAdd = new ForgerBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value(), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString((String)element.blockSignPublicKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> element.publicKey()))), VrfPublicKeySerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.vrfPubKey())));
        return outputs$3.add(forgingBoxToAdd);
    }

    public static final /* synthetic */ void $anonfun$createCoreTransaction$26(ArrayBuffer boxes$1, LongRef inputsTotalAmount$1, long inputsMinimumExpectedAmount$1, Box box) {
        boxes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ZenBox[]{(ZenBox)box}));
        inputsTotalAmount$1.elem += box.value();
        if (inputsTotalAmount$1.elem >= inputsMinimumExpectedAmount$1) {
            throw Breaks$.MODULE$.break();
        }
    }

    public SidechainTransactionApiRoute(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, ActorRef sidechainTransactionActorRef, SidechainTransactionsCompanion companion, NetworkParams params, Enumeration.Value circuitType, ActorRefFactory context, ExecutionContext ec) {
        this.settings = settings;
        this.sidechainNodeViewHolderRef = sidechainNodeViewHolderRef;
        this.sidechainTransactionActorRef = sidechainTransactionActorRef;
        this.companion = companion;
        this.params = params;
        this.circuitType = circuitType;
        super(sidechainTransactionActorRef, companion, context, ec);
        SidechainTypes.$init$(this);
        Product.$init$((Product)this);
        this.tag = ClassTag$.MODULE$.apply(SidechainNodeView.class);
        this.route = (Function1)Directive$.MODULE$.addByNameNullaryApply(this.pathPrefix(this._segmentStringToPathMatcher(this.transactionPathPrefix()))).apply((Function0 & Serializable & scala.Serializable)() -> this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation(this.allTransactions()).$tilde(this.findById())).$tilde(this.decodeTransactionBytes())).$tilde(this.createCoreTransaction())).$tilde(this.createCoreTransactionSimplified())).$tilde(this.sendCoinsToAddress())).$tilde(this.sendTransaction())).$tilde(this.withdrawCoins())).$tilde(this.makeForgerStake())).$tilde(this.spendForgingStake())).$tilde(this.createOpenStakeTransaction())).$tilde(this.createOpenStakeTransactionSimplified())).$tilde(this.createKeyRotationTransaction()));
    }
}

