/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utils;

import io.horizen.utils.ByteArrayWrapper;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Random;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sparkz.crypto.hash.Blake2b256;

public final class Utils {
    public static final int SHA256_LENGTH = 32;
    public static final byte[] ZEROS_HASH;

    private Utils() {
    }

    public static byte[] doubleSHA256Hash(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bytes, 0, bytes.length);
            byte[] first = digest.digest();
            return digest.digest(first);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] Ripemd160Sha256Hash(byte[] bytes) {
        try {
            MessageDigest digest1 = MessageDigest.getInstance("SHA-256");
            MessageDigest digest2 = MessageDigest.getInstance("RIPEMD160");
            digest1.update(bytes, 0, bytes.length);
            byte[] first = digest1.digest();
            digest2.update(first, 0, first.length);
            byte[] second = digest2.digest();
            return second;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doubleSHA256HashOfConcatenation(byte[] bytes1, byte[] bytes2) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bytes1, 0, bytes1.length);
            digest.update(bytes2, 0, bytes2.length);
            byte[] first = digest.digest();
            return digest.digest(first);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static BigInteger decodeCompactBits(long compact) {
        int size = (int)(compact >> 24) & 0xFF;
        byte[] bytes = new byte[4 + size];
        bytes[3] = (byte)size;
        if (size >= 1) {
            bytes[4] = (byte)(compact >> 16 & 0xFFL);
        }
        if (size >= 2) {
            bytes[5] = (byte)(compact >> 8 & 0xFFL);
        }
        if (size >= 3) {
            bytes[6] = (byte)(compact & 0xFFL);
        }
        return Utils.decodeMPI(bytes, true);
    }

    public static long encodeCompactBits(BigInteger value) {
        int size = value.toByteArray().length;
        long result = size <= 3 ? value.longValueExact() << 8 * (3 - size) : value.shiftRight(8 * (size - 3)).longValueExact();
        if ((result & 0x800000L) != 0L) {
            result >>= 8;
            ++size;
        }
        result |= (long)(size << 24);
        return result |= value.signum() == -1 ? 0x800000L : 0L;
    }

    public static BigInteger decodeMPI(byte[] mpi, boolean hasLength) {
        boolean isNegative;
        byte[] buf;
        if (hasLength) {
            int length = (int)Utils.readUint32BE(mpi, 0);
            buf = new byte[length];
            System.arraycopy(mpi, 4, buf, 0, length);
        } else {
            buf = mpi;
        }
        if (buf.length == 0) {
            return BigInteger.ZERO;
        }
        boolean bl = isNegative = (buf[0] & 0x80) == 128;
        if (isNegative) {
            buf[0] = (byte)(buf[0] & 0x7F);
        }
        BigInteger result = new BigInteger(buf);
        return isNegative ? result.negate() : result;
    }

    public static long readUint32BE(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static byte[] nextVersion() {
        byte[] version = new byte[32];
        Random r = new Random();
        r.nextBytes(version);
        return version;
    }

    public static ByteArrayWrapper calculateKey(byte[] data) {
        return new ByteArrayWrapper(Blake2b256.hash((byte[])data));
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        ZEROS_HASH = new byte[32];
    }
}

