/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utils;

import java.util.HashMap;
import java.util.Map;
import sparkz.core.serialization.BytesSerializable;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Writer;

public class DynamicTypedSerializer<T extends BytesSerializable, S extends SparkzSerializer<T>>
implements SparkzSerializer<T> {
    protected HashMap<Byte, S> coreSerializers;
    protected HashMap<Class, Byte> coreSerializersClasses;
    protected HashMap<Byte, S> customSerializers;
    protected HashMap<Class, Byte> customSerializersClasses;
    protected byte CUSTOM_SERIALIZER_TYPE = (byte)127;

    public DynamicTypedSerializer(HashMap<Byte, S> coreSerializers, HashMap<Byte, S> customSerializers) {
        this.coreSerializers = coreSerializers;
        this.customSerializers = customSerializers;
        this.coreSerializersClasses = new HashMap();
        for (Map.Entry<Byte, S> entry : this.coreSerializers.entrySet()) {
            this.coreSerializersClasses.put(((SparkzSerializer)entry.getValue()).getClass(), entry.getKey());
        }
        if (this.coreSerializers.size() != this.coreSerializersClasses.size()) {
            throw new IllegalArgumentException("Core Serializers class types expected to be unique.");
        }
        this.customSerializersClasses = new HashMap();
        for (Map.Entry<Byte, S> entry : this.customSerializers.entrySet()) {
            this.customSerializersClasses.put(((SparkzSerializer)entry.getValue()).getClass(), entry.getKey());
        }
        if (this.customSerializers.size() != this.customSerializersClasses.size()) {
            throw new IllegalArgumentException("Custom Serializers class types expected to be unique.");
        }
    }

    public void serialize(T obj, Writer writer) {
        SparkzSerializer serializer = obj.serializer();
        if (this.coreSerializersClasses.containsKey(serializer.getClass())) {
            byte idOfSerializer = this.coreSerializersClasses.get(serializer.getClass());
            writer.put(idOfSerializer);
            serializer.serialize(obj, writer);
        } else if (this.customSerializersClasses.containsKey(serializer.getClass())) {
            byte idOfSerializer = this.customSerializersClasses.get(serializer.getClass());
            writer.put(this.CUSTOM_SERIALIZER_TYPE);
            writer.put(idOfSerializer);
            serializer.serialize(obj, writer);
        } else {
            throw new IllegalArgumentException("Object without defined serializer occurred.");
        }
    }

    public T parse(Reader reader) {
        if (reader.remaining() < 1) {
            throw new IllegalArgumentException("Unknown custom type id.");
        }
        byte type = reader.getByte();
        if (type == this.CUSTOM_SERIALIZER_TYPE) {
            byte customType = reader.getByte();
            SparkzSerializer serializer = (SparkzSerializer)this.customSerializers.get(customType);
            if (serializer != null) {
                return (T)((BytesSerializable)serializer.parse(reader));
            }
            throw new IllegalArgumentException("Unknown custom type id.");
        }
        SparkzSerializer serializer = (SparkzSerializer)this.coreSerializers.get(type);
        if (serializer != null) {
            return (T)((BytesSerializable)serializer.parse(reader));
        }
        throw new IllegalArgumentException("Unknown core type id.");
    }
}

